#!/usr/local/bin/perl

package SpeciesList;
use SimpleSet;
use MBGD::Taxonomy;
@ISA = qw{ SimpleSet };

$ALL_SPECIES;
$DEFAULT_SPECIES;

sub new {
	my($class) = @_;
	my($this) = {};
	bless $this, $class;
	return $this;
}

sub getAllSpecies {
	if (! $ALL_SPECIES) {
		$tax = MBGD::Taxonomy->new();
		my @tmp = $tax->get_all_spec;
		$ALL_SPECIES = \@tmp;
	}
	return $ALL_SPECIES;
}
sub getDefaultSpecies {
	if (! $DEFAULT_SPECIES) {
		$tax = MBGD::Taxonomy->new();
		my @tmp = $tax->get_default_spec;
		$DEFAULT_SPECIES = \@tmp;
	}
	return $DEFAULT_SPECIES;
}
if ($0 eq __FILE__) {
	$slist = SpeciesList->new;
	$species = $slist->getAllSpecies;
	print join(' ', @{$species}),"\n";
}

1;
