package MBGD_ACCUM::Schema::Gene;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("gene");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => "CURRENT_TIMESTAMP",
    is_nullable => 1,
    size => 14,
  },
  "spid",
  { data_type => "VARCHAR", default_value => undef, is_nullable => 0, size => 7 },
  "locus_tag",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 32,
  },
  "name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 24,
  },
  "geneid",
  { data_type => "INT", default_value => undef, is_nullable => 1, size => 10 },
  "descr",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 250,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint("gene_unique_geneset_locus", ["spid", "locus_tag"]);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-07-01 15:42:29
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:d1R4S+q+KHjaxENhVhK4bA

__PACKAGE__->has_many (
    transcripts => 'MBGD_ACCUM::Schema::Transcript', {
        'foreign.gene_id' => 'self.id'
    }
);
__PACKAGE__->has_many (
    geneannots => 'MBGD_ACCUM::Schema::Geneannot', {
        'foreign.gene_id' => 'self.id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
