package MBGD_ACCUM::Schema::Institution;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("institution");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => undef,
    is_nullable => 1,
    size => 14,
  },
  "name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 100,
  },
  "wwwlink",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 200,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint("institution_unique_name", ["name"]);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:50
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:kkw4pDI5970QfEdnMUiTbw

__PACKAGE__->has_many (
    projects => 'MBGD_ACCUM::Schema::Project', {
        'foreign.institution_id' => 'self.id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
