#!/usr/bin/perl -s
package RECOG::Cache::file;
###############################################################################
# ̾
#     RECOG::Cache::file.pm
# 
#     ꤵ줿ǥ쥯ȥ겼˥åե롣
#     ޤꤵ줿IDб륭åե򥪡ץƤ롣
# 
#     ꤵ줿ǥ쥯ȥ겼, ".index" Ȥ̾ΤΥե
#     åե̾IDбط롣(ǥåե)
#     åɤ߹ߡԤ᥽åɤˤꡢåե
#     롣
# ѥåѿ
#     IndexFileName
#
# Сѿ
#     'DirName'    åե(ǥåե)ǥ쥯ȥ̾
#     'Modified'   åեɲ/Ԥ줿˿ˤʤ
#     'Index'      åե̾IDбդԤϥå
#     'IndexCount' åե̾ο
#
# ᥽åɰ
#     new()
#     _init()
#     DESTROY
#     readIndex()
#     updateIndex()
#     create()
#     write()
#     close()
#     exists()
#     getline()
#     getlines()
#     purge()
#
# 
#
###############################################################################
use strict;
#our(@Cache::file::ISA);                                   # require 5.6.0;
use FileHandle;

#use File::Basename;
#use File::Path;

use RECOG::Cache;
@RECOG::Cache::file::ISA = ( 'Cache' );    # require 5.6.0;      # Ѿ硢Ƭ # 

#@PerlModuleTemplate::ISA = ('BaseName');    # Ѿ硢Ƭ # 

# ѥåѿ
use constant DefaultIndexFname  => "cache.idx";  # ǥåե̾

use constant DefaultFnamePrefix => 'cache';   # åե̾Υץե

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     @args : ѥ᡼: ؿ_init()򻲾
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
    my @args  = @_;
    
    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    my $self  = {};

    bless($self, $class);
    $self->_init(@args);
##    _init($self, @args);

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self : 󥹥󥹤Υե
#     %args : 󥹥ȥ饯ƤӽФΰ
#     $args{'space'}   : åե뤪ӥǥåե
#                        ǥ쥯ȥ̾(ǥեȡ"/tmp")
#     $args{'prefix'}  : åե̾ץե(ץ)
# 
#     ʤ
# 
#     
# 
#
sub _init {
    my $self  = shift;
    my %args  = @_;

#    # Ƥ _init() ƽ
#    $self->SUPER::_init(@args);            # ֥饹硢Ƭ # 

    # ʲ˽

    # åեǥ쥯ȥѿ¸롣
    my $dir = (defined $args{'space'} ? $args{'space'} : '/tmp');
    $self->{'DirName'} = $dir;

    # ǥåե̾ѿ¸
    my $indexFile;
    if(exists $args{'prefix'}) {
	$indexFile = join("/", $dir, $args{'prefix'} . ".idx");
	$self->{'FnamePrefix'} = $args{'prefix'};
    }
    else {
	$indexFile = join("/", $dir, DefaultIndexFname);
	$self->{'FnamePrefix'} = DefaultFnamePrefix;
    }
    $self->{'IndexFile'} = $indexFile;
    # ǥåե뤬¸ߤС򥪡ץ󤷤Ƥɤ߹
    # ¸ߤʤСǥåե롣
    if(-e $dir && -d $dir) {
	if(-e $indexFile) {
	    $self->readIndex();
	}
	else {
	    $self->{'IndexCount'} = 0;
	    $self->{'Modified'}   = 1;
	    $self->updateIndex();
	}
    }
    # ꤵ줿ǥ쥯ȥꤽΤΤʤ硢顼åϤ
    # ץλ롣
    else {
	die sprintf("***** %s : invalid directory name [%s] ******\n",
		    ref $self, $dir);
    }


#    return;
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self  : 󥹥󥹤Υե
# 
#     ʤ
# 
#     Υå奤ǥåե뤬ѹƤ硢
#     ǥåե˽Ϥ롣
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
sub DESTROY {
    my $self = shift;

    # ȤΥ饹˴³
    # ѡ饹Υ󥹥ѿѤƤʤϡ
    # ѡ饹 DESTROY() ƤӽФθǤ褤

    # ѹ줿ǥå򹹿
    $self->updateIndex();

    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
    $self->SUPER::DESTROY;
}

###############################################################################
# ̾
#     readIndex()
# 
#     ǥåեƤɤ߹ߡѿ'Index'ͤݻ롣
# 
#     $self  : 󥹥󥹤Υե
# 
#     ʤ
# 
#     ѿ'Index'˥åե̾()ȥǡID(̾)
#     бط򼨤ϥå(ե)򥻥åȤ롣
# 
#     
#
sub readIndex {
    my $self = shift;

    my $idxfname = $self->{'IndexFile'};
    my $idxfh = new FileHandle($idxfname) || die "open failure($!): $idxfname\n";

    # ǥåե뤫飱ԤɤߡIDȥե̾
    while(my $line = $idxfh->getline) {
	$line =~ s/[\r\n]+$//;
	my($id, $fname, @info) = split /\t/, $line;
	$self->{'Index'}{$id}{'file'} = $fname;
	$self->{'Index'}{$id}{'info'} = eval join("\t", @info);
#	#
#	# '##Count' ȤΥ쥳ɤˤϢ֤򿶤뤿Υˡֹ
#	if($id eq ControlID) {
#	    $self->{'IndexCount'} = $var;
#	}
#	# 
#	else {
#	    $self->{'Index'}{$id} = $var;
#	}
    }
    # 
    $idxfh->close;
}

###############################################################################
# ̾
#     addIndex()
# 
#     ǥåե˿쥳ɤɲä롣
# 
#     $self    : 󥹥󥹤Υե
###     $id      : åե򤹤뤿μ̻
###     $fname   : åե̾
#     $info    : ղþ(ϥå塢ꥹȤΥե󥹤)
# 
#     ʤ
# 
#     ǥåեɲý񤭹ߥ⡼ɤǥץ󤷡쥳ɤɲä롣
# 
#     
#
sub addIndex {
    my $self    = shift;
##    my $id      = shift;
##    my $fname   = shift;
    my $info    = shift;

    my $id    = $self->{'CacheID'};
    my $fname = $self->{'Index'}{$id}{'file'};

    my $idxfname = $self->{'IndexFile'};
    my $idxfh = new FileHandle(">> $idxfname") || die "open failure($!): $idxfname\n";

    # ˡID򿶤뤿褺
    my $comment = refSerialize($info) if(ref $info);
    print STDERR "id : $id\n";
    print STDERR "file : $fname\n";
    print STDERR "$comment\n" . join(" ", %$info) . "\n";
    my $rc = print $idxfh join("\t",
			       $id,
			       $fname,
			       $comment) . "\n";
    unless($rc) {
	die "write error($!) : $idxfname\n";
    }
    $self->{'Index'}{$id}{'info'} = $info;

    $idxfh->close;
}

###############################################################################
# ̾
#     updateIndex()
# 
#     ѿ'Index'Ƥѹ줿硢Ƥ򥤥ǥåե
#     ȿǤ롣
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#     ѿ'Modified'ͤξ硢ѿ'Index'ͤ򥤥ǥå
#     ե˽()롣
# 
#     
#
sub updateIndex {
    my $self = shift;

    # ǥåѹʤС⤻˽λ
    return unless($self->{'Modified'});

    my $rc;
    my $idxfname = $self->{'IndexFile'};
    my $idxfh = new FileHandle("> $idxfname") || die "open failure($!): $idxfname\n";

##    # ˡID򿶤뤿褺
##    $rc = print $idxfh join("\t", ControlID, $self->{'IndexCount'}) . "\n";
##    unless($rc) {
##	die "write error($!) : $idxfname\n";
##    }

    # IDȥåե̾бɽ
    foreach my $id (sort keys %{$self->{'Index'}})  {
#	unless($rc = print $idxfh join("\t", $id, $self->{'Index'}{$id}) . "\n") {
	unless($rc = print $idxfh join("\t",
				       $id,
				       $self->{'Index'}{$id}{'file'},
				       refSerialize($self->{'Index'}{$id}{'info'}),
				       ) . "\n") {
	    die "write error($!) : $idxfname\n";
	}
    }
    $idxfh->close;
    $self->{'Modified'} = undef;
}

###############################################################################
# ̾
#     create()
# 
#     åե롣
#     åե̾򥤥ǥåեϿˤϡaddIndex()
#     뤹뤳ȡ
# 
#     $self : 󥹥󥹤Υե
#     $id   : åե̾б뼱̻
#             ϡμ̻Ҥǥåե̤롣
# 
#     ʤ
# 
#     ǥåեƬ쥳ɤ顢˺å
#     եơˡʿåե̾롣
###     Υե񤭹ߥץ󤷡ǥåե˥åե
###     ̾ɲäԤ
# 
#
sub create {
    my $self  = shift;
    my $id    = shift;

    # $idꤵƤʤ硢뤤ϴ˥ǥåեϿ
    # 硢顼åϤƥץλ롣
    unless(defined $id) {
	die "cache ID not specified : $id\n";
    }

    if(exists $self->{'Index'}{$id}) {
	die "cache ID already exists(file) : $id\n";
    }

    # åե̾(ˡʤ)롣
    # ǥåեƬˤ쥳ɤˡֹ
##    my $path  = $self->{'DirName'};
##    my $fname = sprintf("%s%010d",
##			DefaultFnamePrefix,
##			++$self->{'IndexCount'});
##    my $fullname = join("/", $path, $fname);
    my($fname, $fullname) = $self->newCacheFname();
    my $cnt = 0;
    while(-e $fullname) {
	($fname, $fullname) = $self->newCacheFname();
	$cnt++;
	if($cnt > 10) {
	    die "***** cache file generate retry over $cnt *****\n";
	}
    }

    # 㥷ե񤭹ߥ⡼ɤǥץ󤹤롣
    my $fh = new FileHandle("> $fullname") || die "open failure($!): $fullname\n";

    # åե̾ѿ¸롣
    $self->{'CacheID'}     = $id;
    $self->{'CacheFile'}   = $fullname;
    $self->{'CacheHandle'} = $fh;
    $self->{'Index'}{$id}{'file'} = $fname;

##    # ǥåե˿åե̾ɲä롣
##    $self->addIndex($id, $fname);
}

###############################################################################
# ̾
#     write()
# 
#     åե˥ǡϤ
# 
#     $self : 󥹥󥹤Υե
#     $rec  : ϥǡ
# 
#     ʤ
# 
#     
# 
#
sub write {
    my $self = shift;
    my @rec  = @_;

    my $fh = $self->{'CacheHandle'};
    my $rc = print $fh @rec;
    unless($rc) {
	die "write failure($!) : [$rc] : " . $self->{'CacheFile'} . "\n";
    }
}

###############################################################################
# ̾
#     close()
# 
#     åե򥯥
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#     
# 
#
sub close {
    my $self  = shift;

    if(my $fh = $self->{'CacheHandle'}) {
	$fh->close;
    }
}

###############################################################################
# ̾
#     open()
# 
#     åե򥪡ץ󤹤롣
# 
#     $self : 󥹥󥹤Υե
#     $id   : åե뼱̻
# 
#     åեΥץ : 1
#     åե뤬¸ߤʤ     : 0
# 
#     
# 
#     åե뤬¸ߤĥץ󤬼Ԥϥץλ
#
sub open {
    my $self = shift;
    my $id   = shift;

    my $rc   = 0;
    # ꤵ줿IDб륭åե뤬¸ߤСΥե
    # ץ󤹤롣
    if(exists $self->{'Index'}{$id}) {
##	print STDERR $self->{'Index'}{$id}{'file'} . "\n";
	my $fname = join("/", $self->{'DirName'}, $self->{'Index'}{$id}{'file'});
	my $fh = new FileHandle($fname) || die "open failure($!) : $fname\n";
	$self->{'CacheHandle'} = $fh;
	$rc = 1;
    }

    return $rc;
}

###############################################################################
# ̾
#     exists()
# 
#     ꤵ줿IDб륭åե뤬¸ߤ뤫Ĵ٤
# 
#     $self : 󥹥󥹤Υե
#     $id   : åե뼱̻
# 
#     åե뤬¸ߤп򡢤ʤе֤
# 
#     
# 
#
sub exists {
    my $self  = shift;
    my $id    = shift;

    exists $self->{'Index'}{$id};
}

###############################################################################
# ̾
#     getlines()
# 
#     åեƤޤȤƼ롣
# 
#     $self : 󥹥󥹤Υե
#     $fm   : 쥳ɤγֹ(ץ)
#     $to   : 쥳ɤνλֹ(ץ)
# 
#     åեƤݻꥹȡʣǣ쥳ɡ
# 
#     $fmꤵƤʤСƤΥ쥳ɤ֤
#     $fmꤵƤСꤵ줿ֹޤǤΥ쥳ɤɤФ
#     $toޤǤΥ쥳ɤ֤
# 
#
sub getlines {
    my $self  = shift;
    my $fm    = shift;
    my $to    = shift;

##    my @rec = $fh->getlines;
    my @rec;

    # եϥɥեƬ˥ݥư롣
    my $fh = $self->{'CacheHandle'};
    seek($fh, 0, 0) ||
	die sprintf("seek failure($!) : %s\n", $self->{'CacheFile'});

    # $fm ꤵƤ硢ޤǤΥ쥳ɤɤФ
    # $to ޤǤΥ쥳ɤɤ߹
    if(defined $fm) {
	my $num = 0;
	while(my $line = $fh->getline) {
	    $num++;
	    if($fm <= $num) {
		push(@rec, $line);
		last if($num == $to);
	    }
	}
    }
    # $fm ꤵƤʤС쥳ɤɤ߹ࡣ
    else {
	@rec = $fh->getlines;
    }

    # ɤ߹쥳ɤ֤
    return @rec;
}

###############################################################################
# ̾
#     getline()
# 
#     åեƤ򣱥쥳ɤļ롣
# 
#     $self : 󥹥󥹤Υե
# 
#     åե(쥳ɡ
# 
#     
# 
#
sub getline {
    my $self  = shift;

    my $fh = $self->{'CacheHandle'};
    my $rec = $fh->getline;
    $rec;
}

###############################################################################
# ̾
#     purge()
# 
#     ꤵ줿åե롣
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#     ꤵ줿̻Ҥ˳򥤥ǥåθ奭å
#     ե롣
# 
#     
#
sub purge {
    my $self  = shift;
    my $id    = shift;

    # åե̾롣
    my $fname = join("/", $self->{'DirName'}, $self->{'Index'}{$id});

    # ǥå鳺롣
    delete $self->{'Index'}{$id};
    $self->{'Modified'}    = 1;   # ǥȥ饯ǥǥåեȿ
    
    # åե롣
    unlink $fname if(-e $fname);
}

###############################################################################
# ̾
#     newCacheFname()
# 
#     ˡʥåե̾
# 
#     $self : 󥹥󥹤Υե
# 
#     åե̾(1) ѥʤ
#     åե̾(2) ѥ
# 
#     
# 
#     
sub newCacheFname {
    my $self = shift;

    # åե̾(ˡʤ)롣
    my($fname, $fullname) = $self->getCacheFname(createUID());

    return($fname, $fullname);
}

###############################################################################
# ̾
#     getCacheFname()
# 
#     ꤵ줿ˡʸѤơåե̾
# 
#     $self : 󥹥󥹤Υե
# 
#     åե̾(1) ѥʤ
#     åե̾(2) ѥ
# 
#     
# 
#     
sub getCacheFname {
    my $self = shift;
    my $uid  = shift;

    # Ϳ줿(ˡ)ʸѤơ̿̾롼˽äե̾롣
    my $path  = $self->{'DirName'};
    my $fname = sprintf("%s_%s",
			$self->{'FnamePrefix'},   # ե̾ץե
			$uid);                    # ˡID
    my $fullname = join("/", $path, $fname);

    return($fname, $fullname);
}

###############################################################################
# ̾
#     createUID()
# 
#     åե̾ѤˡID
# 
#     $self : 󥹥󥹤Υե
# 
#     ˡID
# 
#     
# 
#     ॹפȥץIDȤȤ߹碌ƥˡID(ʸ)롣
# 
sub createUID {
    sprintf("%d-%05d", time, $$);
}

###############################################################################
# ̾
#     refSerialize()
# 
#     ϥåꥹȤΥե󥹤ʸŸ롣
# 
#     $var : ϥå⤷ϥꥹȤΥե
# 
#     Ÿʸ
# 
#     
# 
#     
sub refSerialize {
    my $str;
#
#  1. οĴ١ʤʤޤǰʲν򷫤֤
    while(scalar(@_)) {
#     1)򣱤ļФФ̤ͤͤǤʤСʸ
#       ", "ɲä롣
#     ʸ: ͤȤ֤ʸ
        my $var = shift @_;
        $str .= ', ' if(defined($str));
#
#     2)1)ǼФͤꥹȤؤΥե󥹤ʤСե󥹤Ÿ
#       ꥹȤȤܴؿƵŪ˸ƤӽФ
#       η̼äʸ"[", "]"ɲäʸʸ
#       ɲä롣
        # array ref
        if(ref $var eq 'ARRAY') {
            $str .= '[' . refSerialize(@$var) . ']';
        }
#
#     3)1)ǼФͤϥåؤΥե󥹤ʤСͤ缡
#       Ф"=>"Ƿ礷ʸ롣
#       λϥåͼΤե󥹤ˤʤäƤθơͤ
#       ȤܴؿƵŪ˸ƤӽФͤʸ˥åȤ롣
#       ͤȹ礻ʸ(ʣ)줾","Ƿ礷
#       "{", "}"ͿƷʸɲä롣
        # hash ref
        elsif(ref $var eq 'HASH') {
            my @substr;
            foreach my $k (sort keys  %$var) {
                my $v = $var->{$k};
                push(@substr, "'$k'=>" . refSerialize($v));
            }
            $str .= '{' . join(', ', @substr) . '}';
        }
#
#     4)嵭ʳξ硢äͤ"'"(󥰥륯)ղä
#       ʸʸɲä롣
        # not ref
        else {
            $str .= "'" . $var . "'";
        }
    }
#
#  2. ʸ꥿󤹤롣
    return($str);
}

###############################################################################
# ̾
#     getAddInfo()
# 
#     ǥåեˤղþ롣
# 
#     $self : 󥹥󥹤Υե
#     $id   : åեμ̻
# 
#     ղþ(ե󥹡ϿΥפ˰¸)
# 
#     
# 
#     
sub getAddInfo {
    my $self = shift;
    my $id   = shift;

    return $self->{'Index'}{$id}{'info'};
}


###############################################################################
1;#
###############################################################################
