#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;
use RECOG;
package main;

###############################################################################
# cluster_result$B%F!<%V%k$r:n@.$9$k(B

sub create_cluster_result {
  my $db = shift;
  my $tabID = shift;

  my $tabName = $main::TBL_DOMRESULT . "_" . $tabID;
  my $sql = "create table if not exists $tabName (
       clustid int(11),
       subclustid int(11),
       name mediumtext,
       primary key (clustid, subclustid))";

  $db->execute($sql);
}
###############################################################################
#
sub create_cluster_func_dbname {
  my $db = shift;
  my $tabID = shift;

  my $tabName = $main::TBL_DOMFUNC_DB . "_" . $tabID;
  my $sql = "create table if not exists $tabName (
            clustid int,
            subclustid int,
            dbname varchar(32),
            name varchar(24),
            primary key (clustid, subclustid, dbname))";
  $db->execute($sql);
}
###############################################################################
#
sub create_cluster_func_gene {
  my $db = shift;
  my $tabID = shift;

  my $tabName = $main::TBL_DOMFUNC_GENE . "_" . $tabID;
  my $sql = "create table if not exists $tabName (
            clustid int,
            subclustid int,
            name varchar(32),
            descr varchar(128),
            primary key (clustid, subclustid, name))";
  $db->execute($sql);
}
###############################################################################
#
sub create_cluster_tables_idx {
  my $db = shift;
  my $tabID = shift;

  my $sql = "create table if not exists $main::TBL_DOMINDEX (
            clusterID mediumtext,
            status int(11),
            cmd mediumtext,
            name mediumtext,
            cdate timestamp)";
  $db->execute($sql);
}
###############################################################################
#
sub loadData {
  my $db = shift;
  my $tabName = shift;
  my $file = shift;

  my $sql = "load data local infile \'$file\' REPLACE into table $tabName";

  $db->execute($sql);
}
###############################################################################
#
sub existsColumn {
  my $db = shift;
  my $tabName = shift;

  if($db->exist_table($tabname)) {
    my $sql = "select count(*) from $tabname";
    my $st = $db->execute($sql);
    my @num = $st->fetch();
    if($num[0] < 1) {
       return 0;
    } else {
      return 1;
    }
  }
  else {
    return 0;
  }
}

###############################################################################
1;#
###############################################################################