#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;
use RECOG;
use MBGD::DB;
use MBGD::Taxonomy;
use RECOG::MBGD::OutputDomClust3;
package main;
###############################################################################
# domclust$B$N<B9T7k2L$r!"@07A$7$F%U%!%$%k$K=PNO$9$k!#(B
sub convDomClustResLoad {
	my($db, $tabName, $fileDomclust) = @_;
	my($fh);

	$fh = new FileHandle("$fileDomclust") or die "open failure($!)";

	my $res={};
	my $outres={};
	my ($clust)=0;
	my ($subc) = 0;
	my ($outflag);
	while(my $line = $fh->getline()) {
		chomp($line);
		if($line =~ /^#/) { next;}
		if($line =~ /^\s/) { next;}

		if($line =~ /^Cluster\s*(\d+)/) {
			$clust = $1;
			$res->{$clust}={};
			$subc = 0;
			$outflag = 0;
			next;
		}

		if($line =~ /^SubCluster\s*(\d+)/) {
			$subc = $1;
			$res->{$clust}->{$subc}="";
			next;
		}

		if($line =~ /^OutGroup/) {
			$outres->{$clust}="";
			$outflag++;
			next;
		}

		if($line =~ /\S+:\S+/) {
			if(!$subc) {
				$subc = 1; # SubCluster$B$NI=5-$,$J$$$b$N$O(B1$B$H$9$k!#(B
			}

			if($outflag) {
				my $r = $outres->{$clust};
				if(length($r) > 1) {
					$outres->{$clust} = $r . " " . $line;
				}
				else {
					$outres->{$clust} = $line;
				}
 				next;
			} else {
				my $r = $res->{$clust}->{$subc};
				if(length($r) > 1) {
					$res->{$clust}->{$subc} = $r . " " . $line;
				}
				else {
					 $res->{$clust}->{$subc} = $line;
				}
				next;
			}
		}
	}

	# $B%O%C%7%e$K3JG<$7$?%G!<%?$r=g$K=PNO$9$k(B
	foreach my $i (sort{$a<=>$b} keys %{$res}) {
		# outgroup$B$,$"$k$+(B
		my $out;
		if(exists $outres->{$i}) {
			$out = $outres->{$i};
		}

		# SubCluster$B$N%=!<%H(B
		foreach my $s (sort{$a<=>$b} keys %{$res->{$i}}) {
			
			my $res = $res->{$i}->{$s};
			if(length($out) > 1) {
				$res = $res .  " Outgroup " . $out;
			} 
			my $sql = "insert into $tabName (clustid,subclustid,name) values (\'$i\',\'$s\',\'$res\')";
			$db->execute($sql);
		}
	}
}

sub updateRunningStatus {
    my($db) = shift;
    my($cid) = shift;
    my($pd) = shift;

    my $res;
    if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "update $main::TBL_DOMINDEX set status=$pd where clusterID=\'$cid\'";
        $db->execute($sql);
        $res = 1;
    } else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";
        $res = 0;
    }

    return $res;
}

###############################################################################
# domclust$B$N<B9T7k2L$rEPO?$9$k%F!<%V%k$r:n@.$7!"%G!<%?$rEPO?$9$k(B
sub createResultTable {
	my($db) = shift;
    my($tabID) = shift;
    my($fileDomclust) = shift;
    my($sql);

	# $B4{$KEPO?$5$l$F$$$J$$$+$r%A%'%C%/$9$k!#(B
	# $BEPO?$5$l$F$$$?>l9g!"=hM}$r2?$b$;$:$KJV$9!#(B
	if($db->exist_table($tabID)) {
		print STDERR "Already registered.";
		return ;
	}

	# $B:n6H%U%!%$%k$N%G!<%?$r(Bmysql$B$KEPO?$9$k$?$a$N%F!<%V%k$r:n@.$9$k!#(B
	my($tabName) = "cluster_result_$tabID";
    $sql = "create table if not exists $tabName (
       clustid int(11),
       subclustid int(11),
       name mediumtext,
       primary key (clustid, subclustid))";
    $db->execute($sql);

    &convDomClustResLoad ($db, $tabName, $fileDomclust);

    return;
}

###############################################################################
# domclust$B$N<B9T7k2L$,(Bmysql$B$KEPO?$5$l$F$$$k$+$r3NG'$9$k!#(B
sub existsResultColumn {
	my($db) = shift;
	my($id) = shift;
	my($tabname) = shift;

	if(!$tabname) {
		$tabname = $main::TBL_DOMRESULT;
	}
	
	$tabname = $tabname . "_" . $id;
	
	if($db->exist_table($tabname)) {
		my $sql = "select count(*) from $tabname";
		my $st = $db->execute($sql);
		my @num = $st->fetch();
		if($num[0] < 1) {
			return 0;
		} else {
			return 1;
		}
	}
	else {
		return 0;
	}
}

###############################################################################
# domclust$B$N<B9T7k2L$h$j!"(B
# $B%/%i%9%?!<$rBeI=$9$k(BMBGD$B$N%+%F%4%j!<$H0dEA;RL>$r(Bmysql$B$KEPO?$9$k!#(B
sub convDomClustFuncRes {
    my($fileDomclust, $fileTmp_db, $fileTmp_gene) = @_;
    my($fh);
    my($wh);
	my($whg);

    $fh = new FileHandle("$fileDomclust") or die "open failure($!)";
    $wh = new FileHandle("> $fileTmp_db") or die "open failure($!)";
	$whg = ew FileHandle("> $fileTmp_gene") or die "open failure($!)";

    my $before_cid;
    my @sps;
    while(my $line = $fh->getline()) {
        chomp;
        if($line=~/^#SCID/) {
		   if($line =~/CFunc\t(.*)/) {
			   my $sps = $1;
		       @sps = split/\t/, $sps;
		   }
	    }
        if($line=~/^#/) { next;}
		my ($cid,$cgene,$cfunc,$sid,$sgene,$sfunc,@gene) = split/\t/,$line;
        # $B?7$7$$(Bcluster id$B$rFI$_9~$s$@>l9g!"%/%i%9%?!<$NEPO?$r$9$k!JB3$$$F%5%V%/%i%9%?$NEPO?!K(B
		if($before_cid ne $cid) {
			# cid
			printf($wh "%d\t%d\t%s\t%s\n", $cid,0,'mbgd',$cfunc);
			printf($whg "%d\t%d\t%s\t%s\n", $cid,0,$cgene);
			$before_cid = $cid;
		}
		# sid
		printf($wh "%d\t%d\t%s\t%s\n", $cid,$sid,'mbgd',$sfunc);
		printf($whg "%d\t%d\t%s\t%s\n", $cid,$sid,$sgene);
	}
	$wh->close();
}

###############################################################################
# domclust$B$N<B9T7k2L$h$j!"(B
# $B%/%i%9%?!<$rBeI=$9$k(BMBGD$B$N%+%F%4%j!<$H0dEA;RL>$N%F!<%V%k$r:n@.$7!"(Bmysql$B$KEPO?$9$k!#(B
sub createFunctionTableAndLoad {
	my($db) = shift;
    my($tabID) = shift;
    my($fileDomclust) = shift;
    my($sql);

    # $B:n6H%U%!%$%k$K(Bdomclust$B$N<B9T7k2L$r(Bparse$B$7$?$b$N$r=PNO$9$k!#(B
    my($fileTmp_db) = "$main::DOMCLUST_TMP_DIR/tmp_clustfunc_dbname_$tabID.txt";
    my($fileTmp_gene) = "$main::DOMCLUST_TMP_DIR/tmp_clustfunc_gene_$tabID.txt";
    convDomClustFuncRes($fileDomclust, $fileTmp_db, $fileTmp_gene);

    # $B:n6H%U%!%$%k$N%G!<%?$r(Bmysql$B$KEPO?$9$k$?$a$N%F!<%V%k$r:n@.$9$k!#(B

    # dbname
    my($tabName_db) = "cluster_func_dbname_$tabID";
    $sql = "create table if not exists $tabName_db (
            clustid int,
            subclustid int,
            dbname varchar(32),
            name varchar(24),
            primary key (clustid, subclustid, dbname))";

    $db->execute($sql);

    # gene
    my($tabName_gene) = "cluster_func_gene_$tabID";
	$sql = "create table if not exists $tabName_gene (
            clustid int,
            subclustid int,
            name varchar(32),
            descr varchar(128),
            primary key (clustid, subclustid, name))";

    $db->execute($sql);

    # $B:n6H%U%!%$%k$N%G!<%?$r(Bmysql$B$KEPO?$9$k!#(B

    # dbname
    $sql = "load data local infile '$fileTmp_db' REPLACE into table $tabName_db";
    $db->execute($sql);

	# gene
    $sql = "load data local infile '$fileTmp_gene' REPLACE into table $tabName_gene";
    $db->execute($sql);

    # $B:n6H%U%!%$%k$r:o=|$9$k!#(B
    unlink($fileTmp_db);
	unlink($fileTmp_gene);

    return;
}

###############################################################################
# domclust$B$N<B9T7k2L$h$j!"(B
# $B%/%i%9%?!<$rBeI=$9$k(BMBGD$B$N%+%F%4%j!<$H0dEA;RL>$N%F!<%V%k$,EPO?$5$l$F$$$k$+$r3NG'$9$k(B
sub existsFuncColumn {
	my($db) = shift;
    my($id) = shift;
    my($tabname) = shift;

    if(!$tabname) {
        die "select tablename.\n";
    }

    $tabname = $tabname . "_" . $id;

    if($db->exist_table($tabname)) {
        my $sql = "select count(*) from $tabname";
        my $st = $db->execute($sql);
        my @num = $st->fetch();
        if($num[0] < 1) {
            return 0;
        } else {
            return 1;
        }
    }
    else {
        return 0;
    }
}

###############################################################################
# $BN>J}$N%F!<%V%k$h$j!"I,MW$J%+%i%`$r<hF@$9$k!#(B
# 
#t1.$B%/%i%9%?!<$r%+%&%s%H$7!"BP1~$9$k%/%i%9%?$N(Bgroup$B%G!<%?$rJ];}(B
#t2.$B%5%V%/%i%9%?$N0dEA;R(B
#t3.$B%5%V%/%i%9%?$N(Bfunc
#t4.$B%/%i%9%?$N0dEA;R(B
sub getOutputColumn {
	my $db = shift;
	my $clusterID = shift;

	my $tablegene = $main::TBL_DOMRESULT . "_" . $clusterID;
    my $tablefunc_gene = $main::TBL_DOMFUNC_GENE . "_" . $clusterID;
	my $tablefunc_db = $main::TBL_DOMFUNC_DB . "_" . $clusterID;

	my $sql = "select t1.clustid, t4.name, t5.name, t1.subclustid, t2.name, t3.name, t1.name from $tablegene t1 inner join ( $tablefunc_gene t2 inner join ( $tablefunc_db t3 inner join ( $tablefunc_gene t4 inner join $tablefunc_db t5 on t4.clustid=t5.clustid and t4.subclustid=0 and t5.subclustid=0) on t3.clustid=t5.clustid ) on t2.clustid=t3.clustid and t2.subclustid=t3.subclustid) on t1.clustid=t2.clustid and t1.subclustid=t2.subclustid";

	my $dbh = $db->execute($sql);

	return $dbh;

}

###############################################################################
# domclust$B$N<B9T7k2L$rEPO?$9$k%F!<%V%k$r:n@.$9$k(B
sub createStatusTable {
	my($db) = shift;
	
	# $B%F!<%V%k$,$"$k$+$r%A%'%C%/$9$k!#(B
	# $B:n@.$5$l$F$$$?>l9g!"=hM}$r2?$b$;$:$KJV$9!#(B
	if($db->exist_table($main::TBL_DOMINDEX)) {
		print STDERR "$main::TBL_DOMINDEX is already exist. next step.\n";
	} else {
		# $B:n6H%U%!%$%k$N%G!<%?$r(Bmysql$B$KEPO?$9$k$?$a$N%F!<%V%k$r:n@.$9$k!#(B
        my $sql = "create table if not exists $main::TBL_DOMINDEX (
       		clusterID mediumtext,
       		status int(11),
			cmd mediumtext,
       		name mediumtext,
			cdate timestamp)";

		$db->execute($sql);
	}
}

###############################################################################
# domclust$B$N<B9TCf(B status=1
sub insertStartStatus {
	my($db) = shift;
	my($id) = shift;
	my($cmd) = shift;
	
	# gene$B%F!<%V%k$K%"%/%;%9$7!"0dEA;R?t$r%+%&%s%H$9$k(B
	my $genedb = MBGD::DB->new($ENV{'MYSQL_DB'});
	my @species;
	if($cmd =~ /-SPEC=(\S+)/) {
		@species = split/,/, $1;
	}
	my $sps = "\'" . join("\',\'", @species) . "\'";
	my $sql = "select count(*) from gene where sp in ($sps)";
	my $st = $genedb->execute($sql);
	my $ngene = $st->fetch()->[0];

	my $ppid = getppid; # $B%9%F!<%?%9$K?F%W%m%;%9(BID$B$rEPO?$9$k(B
	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "insert into $main::TBL_DOMINDEX (clusterID,status,cmd,counter,ngene,cdate) values (\'$id\', $ppid, \'$cmd\', 1, $ngene, current_timestamp())";
		$db->execute($sql);
	} else {
		print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
		die;
	}
}

###############################################################################
# domclust$B$N<B9T=*N;(B status=2
sub updatendStatus {
	my($db) = shift;
    my($id) = shift;
	my($name) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set status=2, name=\'$name\' where clusterID=\'$id\'";
		$db->execute($sql);
	} else {
        print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
        die;
    }
}

###############################################################################
# $B%3%^%s%I$KBP1~$9$k(BclusterID$B$rJV$9(B
sub getTabid {
	my($db) = shift;
    my($cmd) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select clusterID from $main::TBL_DOMINDEX where cmd=\'$cmd\'";
		my $st = $db->execute($sql);
		my $res = $st->fetch();
		if($res) {
			return $res->[0];
		}
	}
}

###############################################################################
# $B%X%C%@!<>pJs$rJV$9(B
sub getHeaderInfo {
	my($db) = shift;
	my($clusterID) = shift;
	my($param_ref) = {};

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select name from $main::TBL_DOMINDEX where clusterID=\'$clusterID\'";
		my $st = $db->execute($sql);
		my $res = $st->fetch();
		if(!$res) {
            return ;
        }
		my $name = $res->[0];

		my @param = split/ /, $name;
		foreach my $p (@param) {
			my($key, $value) = split/=/,$p;
			my @values = split/,/,$value;
			if(scalar(@values) > 1) {
				$param_ref->{$key} = \@values;
			} elsif(($key eq 'outgroup') || ($key eq 'ingroup')) {
				$param_ref->{$key} = \@values;
			}
			else {
				$param_ref->{$key} = $value;
			}
		}
	}
	return $param_ref;
}

###############################################################################
# $B%9%F!<%?%9>pJs$rJV$9(B 
sub getStatus_fr_id {
	my($db) = shift;
	my($id) = shift;
	
    if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select status from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $st = $db->execute($sql);
		my $res = $st->fetch();
		if(!$res) {
			return ;
		} else {
			return $res->[0];
		}
	}
}

sub getStatus_fr_cmd {
	my($db) = shift;
	my($cmd) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select status from $main::TBL_DOMINDEX where cmd=\'$cmd\'";
		my $st = $db->execute($sql);
        my $res = $st->fetch();
        if(!$res) {
            return ;
        } else {
            return $res->[0];
        }
	}
}

###############################################################################
# domclust3.1$BMQ(B
#
###############################################################################
# $B=*N;%9%F!<%?%9$rEPO?$9$k(B
sub uploadFinishStatus {
    my($db) = shift;
    my($id) = shift;
    my($name) = shift;

    if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "update $main::TBL_DOMINDEX set status=-1, name=\'$name\' where clusterID=\'$id\'";
        $db->execute($sql);
    } else {
        print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
        die;
    }
}

###############################################################################
# $B%(%i!<%9%F!<%?%9$rEPO?$9$k(B
sub uploadErrorStatus {
	my($db) = shift;
    my($id) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set status=-99 where clusterID=\'$id\'";
		$db->execute($sql);
	} else {
        print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
        die;
    }
}

###############################################################################
# $B:F<B9T$N%9%F!<%?%9$KJQ99$9$k(B
sub uploadRetryStatus {
	my($db) = shift;
	my($id) = shift;
	
	my($cnt)=0;
	
	# exec$B$+$i:F<B9T$9$k$?$a!"%-%c%C%7%e%F!<%V%k$r:o=|$9$k(B
	&deleteCacheTable($db, $id);

	if($db->exist_table($main::TBL_DOMINDEX)) {
		# $B%+%&%s%?!<$+$i2?2s<B9T$5$l$?$+$r<hF@$9$k(B
		my $sql = "select counter from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $sth = $db->execute($sql);
		my $res = $sth->fetch();
        if($res) {
            $cnt = $res->[0];
        } else {
			print STDERR "column \'counter\' is not exists. clusterID is $id. $sql\n";
			die;
		}
		# $B%+%&%s%H%"%C%W$7$F<B9T%9%F!<%?%9$XJQ99$9$k(B
		$cnt++;
		$sql = "update $main::TBL_DOMINDEX set status=0, counter=$cnt where clusterID=\'$id\'";
		$db->execute($sql);
	}
	else {
		print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
        die;
	}
}

###############################################################################
# $B:F<B9T$N$?$a!"<B9T%3%^%s%I$+$i%*%W%7%g%s$r:FEPO?$9$k(B
sub idtoOpt {
	my($db) = shift;
	my($id) = shift;
	my %dc_opt;
	my $cmd;
	my @species;
	my @outgroup;
	my @option;

	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "select cmd from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $sth = $db->execute($sql);
        my $res = $sth->fetch();
		if($res) {
            $cmd  = $res->[0];
        }
		if(!$cmd) {
			print STDERR "column \'cmd\' is not exists. clusterID is $id.\n";
			die;
		}

		# $B%3%^%s%IJ8;zNs$N%*%W%7%g%s$r$R$m$&(B
		if($cmd =~ /-SPEC=(\S+)/) {
			@species = split/,/,$1;
		}
		if($cmd =~ /RECOG\/domclust (\-.*)/) {
			@option = split/ /,$1;
		}
		
		# $B%*%W%7%g%s$rJ,2r(B
		foreach my $op (@option) {
			if($op =~ /-Ooutgroup=(\S+)/) {
				@outgroup = split/,/,$1;
				$dc_opt{-O} = sprintf("outgroup=%s", join(',', @outgroup));
			}
			elsif($op =~ /(\-\w+)([\d\.]+)/) {
				my $k = $1;
				my $v = $2;

				# -S, -d, -H $B$,;XDj$5$l$?>l9g!"CM$,(B on $B$J$i%*%W%7%g%s;XDj(B
				#                                   off$B$J$iL5;XDj$H$9$k!#(B
				if($k eq '-S' || $k eq '-d' || $k eq '-H') {
					if($v eq 'on') {
						$dc_opt{$k} = '';
					}
				}
				# -R, -o $B;XDj$OL5;k$9$k(B
				elsif($k eq '-R' || $k eq '-o') {
					next;
				}
				# $B>e5-0J30$J$i!"CM$,;XDj$5$l$F$$$k>l9g$K8B$j!"$=$NCM$r;X<($9$k(B
				else {
					$dc_opt{$k} = $v if(defined $v && $v =~ /\S+/);
				}
			}
			else {
				die "invalid format.\n";
			}
		}
	}
	else {
		print STDERR "Table $main::DOMCLUST_DB is not exists.\n";
        die;
	}

	return (\@species, \%dc_opt);
}

###############################################################################
# retry$B$7$F$b(BOK$B$+$I$&$+$r%A%'%C%/$9$k(B.
sub canRetry {
	my($db) = shift;
	my($tabid) = shift;

	if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "select counter from $main::TBL_DOMINDEX where clusterID=\'$tabid\'";
        my $sth = $db->execute($sql);
        my $res = $sth->fetch();
        if($res) {
			my $cn = $res->[0];
			if($cn < $main::DOMCLUST_RETRY_COUNT) {
				return 1;
			}
		}
	}
	return 0;
}

###############################################################################
#
sub addRetryCountOver {
	my($db) = shift;
    my($cid) = shift;

	my $warn;
	if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "select warning from $main::TBL_DOMINDEX where clusterID=\'$cid\'";
        my $sth = $db->execute($sql);
        my $res = $sth->fetch();
        if($res) {
            $warn = $res->[0];
        }
		if($warn) {
			$warn .= "\n" . "Retry count over. Can not exec domclust.";
		} else {
			$warn .= "Retry count over. Can not exec domclust.";
		}
		
		$sql = "update $main::TBL_DOMINDEX set warning=\'$warn\', status=-99 where clusterID=\'$cid\'";
		$db->execute($sql);
		return 1;
    }
	return 0;
}

###############################################################################
# $B%-%c%C%7%e%F!<%V%k$r:o=|$9$k(B
sub deleteCacheTable {
    my($db) = shift;
    my($tabid) = shift;

    my $dname = $main::TBL_DOMRESULT . "_" . $tabid;
    if($db->exist_table($dname)) {
        my $sql = "drop table if exists $dname";
        $db->execute($sql);
    }

    $dname = $main::TBL_DOMFUNC_GENE . "_" . $tabid;
    if($db->exist_table($dname)) {
        my $sql = "drop table if exists $dname";
        $db->execute($sql);
    }

	$dname = $main::TBL_DOMFUNC_DB . "_" . $tabid;
	if($db->exist_table($dname)) {
		my $sql = "drop table if exists $dname";
		$db->execute($sql);
	}

	$dname = $main::TBL_DOMINDEX;
	if($db->exist_table($dname)) {
		my $sql = "delete from $dname where clusterID=\'$tabid\'";
		$db->execute($sql);
	}
}

# $B:o=|$9$k!#:o=|$K@.8y$7$?$i(B1$B$r!"<:GT$7$?$i(B0$B$rJV$9(B
sub doDelete {
	my($db) = shift;
	my($clusterID) = shift;
	my($in) = shift;
	my($out) = shift;
	
	if(!$clusterID || !$in) {
		return 0;
	}
	
	# ingroup$B$H(Boutgroup$B$,(Bdb$B$N%G!<%?$H0lCW$7$?$i:o=|$r<B9T$9$k(B
	my $info = &getHeaderInfo($db, $clusterID);
	if(!$info) { 
		return 0;
	}
	my $indb = join(',', @{$info->{'ingroup'}});
	my $outdb = join(',', @{$info->{'outgroup'}});
	if(&isSameSpecs($in,$indb) && &isSameSpecs($out,$outdb)) {
		&deleteCacheTable($db, $clusterID);
		return 1;
	} else {
		return 0;
	}
}

# $B@8J*<o$,0lCW$7$F$$$k$+$I$&$+$r3NG'$9$k(B
# $B0lCW$J$i(B1$B!"IT0lCW$J$i(B0$B$rJV$9(B
# $B@8J*<o$O!V(BA,B,C,$B!W$N$h$&$J7A<0$GJ];}$5$l$F$$$k$b$N$H$9$k(B
sub isSameSpecs {
	my($spA, $spB) = @_;
    
	my %hashA;
	my $counterA;
	foreach my $a (split/,/, $spA) {
		$hashA{$a}++;
		$counterA++;
	}

	my $counterB;
	foreach my $b (split/,/, $spB) {
		if(!exists $hashA{$b}) {
			return 0;
		}
		$counterB++;
	}
	
	if($counterA != $counterB) {
		return 0;
	}

	return 1;
}

###############################################################################
# domclust$B$N(Bwarning$B$rEPO?$9$k(B
sub uploadWarnings {
	my($db) = shift;
	my($cid) = shift;
	my($warfile) = shift;

	my $warn;
	my $fh = new FileHandle($warfile) || die "open failure($!): $warfile\n";
	while(my $line = $fh->getline) {
		$warn .= $line;
	}
	$fh->close;

	if(!$warn) { return; }
	if($db->exist_table($main::TBL_DOMINDEX)) {
		my $sql = "update $main::TBL_DOMINDEX set warning=\'$warn\' where clusterID=\'$cid\'";
        $db->execute($sql);
	}
} 

###############################################################################
# domclust$B7k2L$N(Bcluster$B?t$rEPO?$9$k(B
sub uploadNdomclust {
	my($db) = shift;
	my($cid) = shift;
	my($num) = shift;

	if($num > 0) { 
		if($db->exist_table($main::TBL_DOMINDEX)) {
			my $sql = "update $main::TBL_DOMINDEX set ncluster=$num where clusterID=\'$cid\'";
			$db->execute($sql);
		}
	}
}

###############################################################################
#
sub execDomClust {
     my($cmd) = shift;
     my($fileStdout) = shift;
     my($fileStderr) = shift;
     my($fileProgress) = shift;
 
 
     my($fhr) = new FileHandle("$cmd 2>&1 1>$fileStdout |");
     my($fhe) = new FileHandle(">$fileStderr");
     select($fhe); $| = 1;
     my($fhp) = new FileHandle(">$fileProgress");
     select($fhp); $| = 1;
 

TOP:
     while($_ = $fhr->getline()) {
         foreach my$pat (@RECOG::PAT_progress) {
             if (/^$pat/i) {
				 $fhp->print($_);
	   			 next TOP;
             }
         }
         $fhe->print($_);
     }
     $fhe->close();
     $fhp->close();
}

###############################################################################
# $B%/%i%9%?(BID$B$H%5%V%/%i%9%?(BID$B$h$j!"(Bcluster_result $B$N<B9T7k2L$r<hF@$9$k(B
# 
sub selectAllClusterResult {
	my $db = shift;
	my $tabID = shift;

	my $tabName = $main::TBL_DOMRESULT . "_" . $tabID; # $B%F!<%V%kL>(B
	my $sql = "select * from $tabName";
	my $dbh = $db->execute($sql);
	my @lines = $dbh->fetchall_arrayref();
	
	return @lines;
}

sub createCmdline {
	my $req = shift;

	my $hashreq={};
	my $sp_ref={};
	foreach my $opt (split/ /, $req) {
		my($key,$val) = split/=/, $opt;
		
		# $B5/F0%*%W%7%g%s$G$J$$%*%W%7%g%s(B
		if($key eq '-err' || $key eq '-out' || $key eq '-out_format' || $key eq '-output_type' || $key eq '-dbtype') {
			next;
		}

		# $B@8J*<o(B
		if($key eq '-ingroup' || $key eq '-outgroup') {
			$sp_ref->{$key} = $val;
			next;
		}

        # -S, -d, -H $B$,;XDj$5$l$?>l9g!"CM$,(B on $B$J$i%*%W%7%g%s;XDj(B
        #                                   off$B$J$iL5;XDj$H$9$k!#(B
        if($key eq '-S' || $key eq '-d' || $key eq '-H') {
            if($val eq 'on') {
                $hashreq->{$key} = '';
            }
        }

        # -R, -o $B;XDj$OL5;k$9$k(B
        elsif($key eq '-R' || $key eq '-o') {
			next;
        }

        # $B>e5-0J30$J$i!"CM$,;XDj$5$l$F$$$k>l9g$K8B$j!"$=$NCM$r;X<($9$k(B
        else {
            $hashreq->{$key} = $val if(defined $val && $val =~ /\S+/);
        }
    }
	
	# $B;XDj$5$l$?@8J*<o$r(B Taxonomy $B=g$KJB$SBX$($9$k(B
	my($ing, $outg, $species) = uniqSpecies($sp_ref);

	if($outg) {
    # outgroup$B;XDj%*%W%7%g%s(B
		$hashreq->{-O} = sprintf("outgroup=%s", join(',', @$outg));
	}
	
	# $B5/F0%*%W%7%g%s@_Dj(B
	my $cmd = sprintf("%s -tabout -SPEC=%s | ",
                       $main::PROG_MBGDSPEC,
					  join(",", @$species));

	$cmd .= "$main::PROG_DOMCLUST ";
	foreach my $opt (sort keys %{$hashreq}) {
		$cmd .= sprintf(" %s%s",$opt, $hashreq->{$opt});
    }

#    $cmd .= sprintf(" %s", $self->{'SimFile'})  if ($self->{'SimFile'});
#    $cmd .= sprintf(" %s", $self->{'GeneFile'}) if ($self->{'GeneFile'});
    $cmd .= " -v";
    $cmd .= " ";
}

# $B;XDj$5$l$?@8J*<o$r=EJ#$N$J$$!"(Btaxonomy$B=g$KJB$SBX$($9$k(B
sub uniqSpecies {
	my $opt_ref = shift;

	my $in_ref={};
	my $out_ref={};
	my $spec_ref={};
	my(@ing, @outg, @species);
    my $tax = MBGD::Taxonomy->new();

	foreach my $sp (split/,/,$opt_ref->{'-ingroup'}) {
		if(length($sp) > 0) {
	  		$in_ref->{$sp}++;
	   	}
	}

	if($opt_ref->{'-outgroup'}) {
		foreach my $sp (split/,/, $opt_ref->{'-outgroup'}) {
			# ingroup$B$KL5$$$b$N$N$_(B
			if(!$in_ref->{$sp}) {
				if(length($sp) > 0) {
					$out_ref->{$sp}++;
				}
			}
		}
		$spec_ref = { %{$in_ref} , %{$out_ref} };
		@outg = $tax->sortByTaxonomy(keys(%{$out_ref}));

	} else {
		$spec_ref = { %{$in_ref} };
	}

	@ing  = $tax->sortByTaxonomy(keys(%{$in_ref}));
	@species = $tax->sortByTaxonomy(keys(%{$spec_ref}));

	return (\@ing, \@outg, \@species);
}

###############################################################################
1;#
###############################################################################
 
