#!/usr/bin/perl -s
package RECOG::MBGD::ClusterTable::Writer::db;
###############################################################################
# .ANLN>N>NN
#     RECOG::MBGD::ClusterTable::Writer::db.pm
# .AN3N5NMNW
#     MBGD::ClusterTable.AN$N,NJN]N;N}N$N9N$NkN%NGN!N<N%N?N$NrN!N"N%N?N%NVN6NhN@NZN$NjN$NNN%NFN%N-N%N9N%NHN$NGN=NPNNNON$N9N$NkN!N#
# .AN@NbNLN@
#     .ANKN\N%NbN%N8N%NeN!N<N%NkN$NO MBGD::ClusterTable::Writer N$NNN%N5N%NVN%N/N%NiN%N9N$NHN$N7N$NFN<NBNANuN$N5N$NlN$NF
#     .AN$N$N$NkN$N,NKN\N%NbN%N8N%NeN!N<N%NkN$NrN%N@N%N$N%NlN%N/N%NHN$NKNMNQN$N$N$NkN$N3N$NHN$NONAN[NDNjN$N7N$NFN$N$N$NJN$N$N!N#
#     .AN>NeN0NLN%N/N%NiN%N9N$NG{ format => "db" } N$NHN;NXNDNjN$N7N$NFN%N$N%NsN%N9N%N?N%NsN%N9N$NrN@N8N@N.N$N9N$NkN$N3N$NHN$N,
#     .ANAN0NDNsN$NGN$N"N$NkN!N#
#     
# .AN%NaN%NsN%NPNJNQN?Nt
#     'FileHandle'
# .AN%NaN%N=N%NCN%NIN0NlNMNw
#     new()
#     write()
# .ANHNwN9NM
#
###############################################################################
use FileHandle;
use CGI qw/ :standard start_table end_table /;
use RECOG::MBGD::ClusterTable::Writer;

use MBGD;
use RECOG;
@ISA = ( 'RECOG::MBGD::ClusterTable::Writer' );

###############################################################################
# .ANLN>N>NN
#     new()
# .AN3N5NMNW
#     .AN%N3N%NsN%N9N%NHN%NiN%N/N%N?
# .AN0NzN?Nt
#     $that  : .AN%N/N%NiN%N9NLN>(N$NbN$N7N$N/N$NON%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9)
# .ANLNaNCNM
#     .AN?N7N5N,N%N$N%NsN%N9N%N?N%NsN%N9N$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .AN@NbNLN@
#
# .ANHNwN9NM
#
sub new {
    my $that = shift;
##    my %args  = @_;

    # $that .AN$N,N%NjN%NUN%N!N%NlN%NsN%N9N$NJN$NiN!N"N%NQN%NCN%N1N!N<N%N8NLN>N$NrN<NhNFN@N$N9N$NkN!N#
    my $class = ref($that) || $that;

    my $self = {};
    bless $self, $class;

    return $self;
}

###############################################################################
# $B%5%V%k!<%A%sL>(B
#     write()
# $B35MW(B
#     $B%/%i%9%?!<Kh$NBeI=0dEA;R$H%U%!%s%/%7%g%s$r(BDB$B$KEPO?$9$k(B
# $B0z?t(B
#     $self   :
#     $db     : $BEPO?$9$k(BDB$B%*%V%8%'%/%H(B 
#     $functb : $B%U%!%s%/%7%g%s$rEPO?$9$k%F!<%V%kL>(B
#     $genetb : $B0dEA;RL>$rEPO?$9$k%F!<%V%kL>(B
#     $tabl   : DomClust$B$N<B9T7k2L(B
#     $format : Domclust$B$N<B9T%?%$%W(B complete, boolean, count 
# $BLa$jCM(B
#     $B$J$7(B
#
sub write {
    my $self = shift;
	my $db = shift;
	my $functb = shift;
    my $genetb = shift;
    my $tabl = shift;

	# Table$B$N:n@.(B
	$self->createFuncTable($db, $functb); 
	$self->createGeneDescrTable($db, $genetb);
    foreach my $cid (sort {$a <=> $b} keys %$tabl) {
        my $c    = $tabl->{$cid};
		
		$self->insertFuncTable($db, $functb, $cid, 0, $c->{'function'});
		$self->insertGeneDescrTable($db, $genetb, $cid, 0, $c->{'genename'}, $c->{'product'});

        my $subc = $c->{'subcluster'};

        my $subno = scalar(keys %$subc);
        foreach my $sid (sort {$a <=> $b} keys %$subc) {
			my $subg = ($subno > 1 ? $subc->{$sid}{'genename'} : $c->{'genename'});
			my $subd = ($subno > 1 ? $subc->{$sid}{'product'} : $c->{'product'});
			my $sfunc = ($subno > 1 ? $subc->{$sid}{'function'} : $c->{'function'});

			$self->insertFuncTable($db, $functb, $cid, $sid, $sfunc);
			$self->insertGeneDescrTable($db, $genetb, $cid, $sid, $subg, $subd);
        }
    }
}

sub createFuncTable {
	my $self = shift;
	my $db = shift;
	my $tb_name = shift;

	my $sql = "create table if not exists $tb_name (
               clustid int,
            subclustid int,
            dbname varchar(32),
            name varchar(24),
            primary key (clustid, subclustid, dbname))";

	$db->execute($sql);
}

sub insertFuncTable {
	my $self = shift;
	my $db = shift;
	my $tab_name = shift;
 	my $cid = shift;
	my $subid = shift;
	my $name = shift;

	foreach my $d (keys%{$name}) {
		$vname = $name->{$d};
		$vname =~ s/'//;
		my $sql = "insert into $tab_name (clustid,subclustid,dbname,name) values (\'$cid\', \'$subid\',\'$d\',\'$vname\')";
		$db->execute($sql);
	}
}

sub insertGeneDescrTable {
	my $self = shift;
	my $db = shift;
	my $tab_name = shift;
    my $cid = shift;
    my $subid = shift;
    my $gene = shift;
	my $descr = shift;

	$descr =~ s/'/\\'/g;
	$gene =~ s/'//g;
	my $sql = "insert into $tab_name (clustid,subclustid,name,descr) values (\'$cid\', \'$subid\', \'$gene\',\'$descr\')";
	$db->execute($sql);
}

sub createGeneDescrTable {
	my $self = shift;
	my $db  = shift;
	my $tab_name = shift;

	my $sql = "create table if not exists $tab_name (
               clustid int,
            subclustid int,
            name varchar(24),
            descr varchar(128),
            primary key (clustid, subclustid))";

	$db->execute($sql);
}

##############################################################################
1; #
##############################################################################
