#!/usr/bin/perl -s
require 'MBGD_commonPath.pl';
package RECOG::MBGD::DomClust;
###############################################################################
# ̾
#     MBGD::DomClust.pm
# 
#     CGIεưꤷơDomClust¹Ԥ롣
# 
#     ܥ饹ϡDomClust::WithCache 쥯饹ȤΤǡ
#     Ϳ줿ʪ̾ץ˽äơdomclust ¹Ԥ롣
#     DomClustϥǡϡMBGDεǽѤưŪ˼Ƥ롣
# ѥåѿ
#     
# Сѿ
#     
# ᥽åɰ
#     new()
#     exec()
#     makeInputStream()
# 
#     ĤΥե require 뤳ȡ
#     MBGD_commonPath.pl
#
#     åʤDomClustѾǺǽ̤򥭥å夹
#       ɤΤǤϤʤ
#
#
###############################################################################
use File::Path;
#use DomClust::Table;
use RECOG;
use RECOG::DomClust::WithCache;
use RECOG::MBGD::ClusterTable;
use MBGD::DB;

@ISA = ( 'RECOG::DomClust::WithCache' );

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     %args  : domclustưץ
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that   = shift;
    my %args   = @_;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    $self = {};
    bless $self, $class;

    # ѡ饹δؿ_init()򥳡뤹
    $self->SUPER::_init(%args);

    # DomClust¹ԥե롣
    $self->setProgFname($main::CMD_domclust);
    $self;
}

###############################################################################
# ̾
#     exec()
# 
#     ꤵ줿ʪˤĤơMBGDǡDomClust¹Ԥ롣
# 
#     $self : 󥹥󥹤ؤΥե
#     @orgs : ʪ̾(ά)Υꥹ
# 
#     ʤ
# 
#
# 
#
sub exec {
    my $self = shift;
	my $db = shift;
    my @orgs = @_;

    # DomClust ¹ԥޥʸԽ
    my $cmnd = $self->makeInputStream(@orgs); # ʪΥۥ̼ȥ꡼
    $cmnd   .= $self->editStatement();
    print STDERR "DBG :: CMD :: $cmnd\n";

    # ѡ饹Υ᥽åɤ򥳡
    my $res = $self->SUPER::exec($db,$cmnd);
	
	return $res;
}

###############################################################################
# ̾
#     makeInputStream()
# 
#     ꤵ줿ʪˤĤơMBGDǡDomClust¹Ԥ롣
# 
#     $self : 󥹥󥹤ؤΥե
#     @orgs : ʪ̾(ά)Υꥹ
# 
#     DomClustϥǡ뤿˷礹ѥ
# 
#
# 
#
sub makeInputStream {
    my $self  = shift;
    my @orgs  = @_;

    #
    my(@opt_keys) = (
        '-di',
        '-EVAL',
        '-SCORE',
        '-IDENT',
        '-PAM',
        '-BESTHIT',
        '-RATIOCUT',
        '-defaulttab',
    );

    #
    my(%default_value) = (
        '-EVAL'    => 0.001,
        '-SCORE'   => 60,
    );

    my $refSelectOpt = $self->{'OptionSelect'};

    # ʪϿ롣
    $self->{'SPECS'} = join(",",@orgs);

    #
    my($opt) = '';
    foreach my$k (@opt_keys) {
        my($v) = $refSelectOpt->{"$k"};
        if (!defined($v)) {
            if (!exists($default_value{"$k"})) {
                next;
            }
            $v = $default_value{"$k"};
        }

        #
        $opt .= ' ' if ($opt ne '');
        $opt .= $k;
        if ($v ne '') {
            $opt .= "=$v";
        }
    }

    # DomClustϥե롣
	my $cmnd = sprintf("%s %s -tabout -SPEC=%s | ",
					   $main::CMD_select,
                       $opt,
					   join(",", @orgs));

    $cmnd;
}

###############################################################################
# ̾
#     getClusterTable()
# 
#     DomClust¹Է̤MBGD::ClusterTableΥ󥹥󥹤¸֤
# 
#     $self  : 󥹥󥹤Υե
#     $cno   : 饹ֹ(ֹ)
#     $count : 饹(꤬ʤСǽ饹ޤ)
#     $cmnd  : domclust¹ԥơȥ(ץ)
# 
#     饹ơ֥(ϥåΥե)
# 
#     ǥեȤνϷꤷꤵ줿饹ֹ椫顢ꤵ줿
#     ĿʬΥ饹֤
# 
#     ǡ¤ˤĤƤϡClusterTable饹β򻲾ȡ
#
sub getClusterTable {
    my $self  = shift;
    my $cno   = shift;
    my $count = shift;
    my $cmnd  = shift;
    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    $cno   = 1   unless(defined $cno);

    # ClusterTableΥ󥹥󥹤롣
    my $ctbl = new MBGD::ClusterTable();

    my $cid;                # Cluster ID
    my $sid;                # Subcluster ID
    my $group = 'ingroup';  # ingroup or outgroup

    my $ch = $self->{'Cache'};

    # 饹IDޤǥåפ
    while(my $line = $ch->getline()) {
		if($line =~ /^Cluster +(\d+)/) {
			$cid = $1;
			if($cno == $cid) {
				$count-- if(defined $count);
				last;
			}
		}
    }

    # Ƭ饹Ĥä˸¤ꡢǡơ֥
    if($cno == $cid) {
        my $hcid;
		while(my $line = $ch->getline()) {
			my($flag);
            if($line =~ /^HomCluster +(\d+)/) {
                $hcid = $1;
            }
			elsif($line =~ /^Cluster +(\d+)/) {
				$cid = $1;                 # 饹ID
				$group = 'ingroup';        # 롼פingroupǥեȤ

				$count-- if(defined $count);
				last if($count < 0);
			}
			elsif($line =~ /^SubCluster +(\d+)/) {
				$sid = $1;                 # ֥饹ID
			}
			elsif($line =~ /^OutGroup/) {
				$group = 'outgroup';       # 롼פoutgroupڤؤ
			}
			elsif($line =~ /^OuterGroup/) {
				$group = 'outgroup';       # 롼פoutgroupڤؤ
				$flag = 'outer';
			}
			elsif($line =~ /^\s*$/) {      # Ԥϥå
				next;
			}
			elsif($line =~ /^(([a-z0-9]+):\S+)\s+(\d+)\s+(\d+)/i) {
				my $orf = $1;              # ξ
				my $sp  = $2;
				my $fm  = $3;
				my $to  = $4;

        # ingroup/outgroup ˳Ҿʪ¸롣
        $ctbl->setGeneInfo($sp,
                   $orf,
						   {'gene' => $orf, 'from' => $fm, 'to' => $to, 'flag' => $flag},
                   $cid,  $hcid,
                   (defined $sid ? $sid : 1),
						   $group);
			}
		}
    }

    # ʪ̾ⷲʪ̾Ͽ롣
    $ctbl->setSpecies($self->getSpecies());
    $ctbl->setInGroup($self->getInGroup());
    $ctbl->setOutGroup($self->getOutGroup());

    # 饹ñ̡֥饹ñ̤ɽ̾ǽƥꤹ롣
##    $ctbl->setAdditionalGeneInfo();

    # å˷̤¸롣
    # ֥Ȥݤȥפ롣
##    my $cache = ...
##    $cache->write($self->dump());

    # ClusterTableΥ󥹥󥹤֤
    $ctbl;
}

###############################################################################
# ̾
#     getClusterTableOpt()
# 
#     DomClust¹Է̤MBGD::ClusterTableΥ󥹥󥹤¸֤
#     ¹Է̤ϻꤷץνȤ롣
# 
#     $self  : 󥹥󥹤Υե
#     $cno   : 饹ֹ(ֹ)
#     $count : 饹(꤬ʤСǽ饹ޤ)
#     $cmnd  : domclust¹ԥơȥ(ץ)
#     $insp  : ⷲ˻ꤷʪꥹȤΥե
#     $outsp : ˻ꤷʪꥹȤΥե
# 
#     饹ơ֥(ϥåΥե)
# 
#     ǥեȤνϷꤷꤵ줿饹ֹ椫顢ꤵ줿
#     ĿʬΥ饹֤
# 
#     ǡ¤ˤĤƤϡClusterTable饹β򻲾ȡ
#
sub getClusterTableOpt {
    my $self  = shift;
    my $cno   = shift;
    my $count = shift;
    my $cmnd  = shift;
    my $insp  = shift;
    my $outsp = shift;
	my $species = shift;

	my $countCluster;

    $cmnd = $self->{'CommandStr'} unless(defined $cmnd);

    $cno   = 1   unless(defined $cno);

    # ClusterTableΥ󥹥󥹤롣
    my $ctbl = new RECOG::MBGD::ClusterTable();

    # ʪ̾ⷲʪ̾Ͽ롣
    # ⷲ˳ʪ郎äƤϼ
    # ʳȤƽƤ뤿
    my @uinsp;
    foreach my $s (@$insp) {
      my $f = 0;
      foreach my $o (@$outsp) {
        if($s eq $o) {
          $f++;
          last;
        }
      }
      if($f==0) {
        push(@uinsp, $s);
      }
    }
    $ctbl->setSpecies(@$species);
    $ctbl->setInGroup(@uinsp);
    $ctbl->setOutGroup(@$outsp);
#    $ctbl->setSpecies($self->getSpecies());
#    $ctbl->setInGroup($self->getInGroup());
#    $ctbl->setOutGroup($self->getOutGroup());

    #
    my(%hash_out_group);
    foreach my$sp (@outsp) {
        my($lc_sp) = lc($sp);
        $hash_out_group{"$lc_sp"} = 1;
    }

    #
    my $cid;                # Cluster ID
    my $sid;                # Subcluster ID
    my $group = 'ingroup';  # ingroup or outgroup

    my $ch = $self->{'Cache'};

    # 饹IDޤǥåפ
    while(my $line = $ch->getline()) {
		if($line =~ /^Cluster +(\d+)/) {
			$cid = $1;
			if($cno == $cid) {
				$count-- if(defined $count);
				last;
			}
		}
    }

    # Ƭ饹Ĥä˸¤ꡢǡơ֥
    if($cno == $cid) {
	while(my $line = $ch->getline()) {
	my $flag;
        my $hcid;
        if($line =~ /^HomCluster +(\d+)/) {
            $hcid = $1;
        }
	    elsif($line =~ /^Cluster +(\d+)/) {
			$cid = $1;                 # 饹ID
			$group = 'ingroup';        # 롼פingroupǥեȤ

			$count-- if(defined $count);
			last if($count < 0);
			$countCluster++;
	    }
	    elsif($line =~ /^SubCluster +(\d+)/) {
			$sid = $1;                 # ֥饹ID
	    }
	    elsif($line =~ /^OutGroup/) {
			$group = 'outgroup';       # 롼פoutgroupڤؤ
	    }
	    elsif($line =~ /^OuterGroup/) {
			$group = 'outgroup';       # 롼פoutgroupڤؤ
			$flag = 'outer';
	    }
	    elsif($line =~ /^\s*$/) {      # Ԥϥå
			next;
	    }
	    elsif($line =~ /^(([a-z0-9]+):\S+)\s+(\d+)\s+(\d+)/i) {
			my $orf = $1;              # ξ
			my $sp  = $2;
			my $fm  = $3;
			my $to  = $4;

			# ingroup/outgroup ˳Ҿʪ¸롣
			$ctbl->setGeneInfo($sp,
				   $orf,
				   {'gene' => $orf, 'from' => $fm, 'to' => $to, 'flag' => $flag},
				   $cid, $hcid,
				   (defined $sid ? $sid : 1),
				   $group);
	        }
	    }
    }
	
	# ٤饹Ͽ
	$self->{'ClusterCount'} = $countCluster;


    # 饹ñ̡֥饹ñ̤ɽ̾ǽƥꤹ롣
##    $ctbl->setAdditionalGeneInfo();

    # å˷̤¸롣
    # ֥Ȥݤȥפ롣
##    my $cache = ...
##    $cache->write($self->dump());

    # ClusterTableΥ󥹥󥹤֤
    return $ctbl;
}

##############################################################################
1; #
##############################################################################
