#!/usr/local/bin/perl -s
#
#
#
#
#
###############################################################################
###############################################################################
require("MBGD_Conf.pl");
require("libMBGDGifOrgName.pl");

use GD;

###############################################################################
# Хѿ
###############################################################################
# ǥեȥѥ᡼
@IMG_SIZE   = (500, 400);	# XYΥԥ
@SEQ_CENTER = (250, 200);	# 󥹤濴
$RADIUS_SEQ_INNER  = 140;	# 󥹤¦Ⱦ
$RADIUS_SEQ_OUTER  = 160;	# 󥹤γ¦Ⱦ
$RADIUS_DISP_SCALE = 130;	# ɽ
$RADIUS_DISP_NAME  = 170;	# gene̾ɽ()

$SCALE_FONT   = gdSmallFont;         # ɽͤΥե
$SCALE_FONT_W = $SCALE_FONT->width;  # ɽͤΥեȤ  (pixel)
$SCALE_FONT_H = $SCALE_FONT->height; # ɽͤΥեȤι⤵(pixel)

$GENE_FONT    = gdSmallFont;         # gene̾Υե
$GENE_FONT_W  = $GENE_FONT->width;   # gene̾ΥեȤ  (pixel)
$GENE_FONT_H  = $GENE_FONT->height;  # gene̾ΥեȤι⤵(pixel)

$FONT_ALLOWED_OVLAP = 3;	# ʸνŤʤε(pixel)

# ľΥξ
$DIFF_ARC  = 0;
$START_ARC = 0;
$END_ARC   = 360;
# Υξ
$DIFF_ARC_LINEAR  = 2;
$START_ARC_LINEAR = 270;
$END_ARC_LINEAR   = $START_ARC_LINEAR - $DIFF_ARC_LINEAR;

#@GENE_NAMES = ();		# gene̾ɽ뤿θ

$PAI  = atan2(0, -1);		# Ф
###############################################################################
# ǥեȤ
sub main::Draw_setDefault
{
    $diff_arc  = $DIFF_ARC;
    $start_arc = $START_ARC;
    $end_arc   = $END_ARC;
}

# ΥΥ
sub main::Draw_setLinear
{
    $diff_arc  = $DIFF_ARC_LINEAR;
    $start_arc = $START_ARC_LINEAR;
    $end_arc   = $END_ARC_LINEAR;
}

# Υο(߷)
# input : ʪ̾, 󥹤Ĺ, gene̾ɽ(1:롢0:ʤ)
#         Gene
# return: ʤ
sub main::drawGenome
{
    my($OrgName, $SeqLen, $DispGeneName, @GeneSet) = @_;

    local(@GENE_NAMES) = ();		# ɽ򥯥ꥢ

    # ϰ֤ǥ
    @GeneSet = sort {${$a}[2] <=> ${$b}[2]} @GeneSet;

    # ᡼֥
    my $img = new GD::Image(@IMG_SIZE);

    my $black = $img->colorAllocate(  0,   0,   0);
    my $white = $img->colorAllocate(255, 255, 255);
    my $gray  = $img->colorAllocate(170, 170, 170);

    $img->fill(1, 1, $white);	                      # طʿ

    my($cx, $cy) = @SEQ_CENTER;	                          # 󥹤濴
    my($ri, $ro) = ($RADIUS_SEQ_INNER, $RADIUS_SEQ_OUTER);  # ߡߤȾ

    # genome򤢤魯Ťαߤ
#    if($OrgName eq 'bbu')
    unless($OrgName eq 'bbu')
    {
        $img->arc($cx, $cy, $ri * 2, $ri * 2, 0, 360, $black);
        $img->arc($cx, $cy, $ro * 2, $ro * 2, 0, 360, $black);
        $img->fill($cx, $cy, $gray);	                  # 濴ϥ졼
    }
    else
    {
         &Draw_setLinear();
#        my $diff_arc  = $DIFF_ARC_LINEAR;
#        my $start_arc = $START_ARC_LINEAR;
#        my $end_arc   = $END_ARC_LINEAR;
        $img->arc($cx, $cy, $ri * 2, $ri * 2, 0, 360, $black);
        $img->arc($cx, $cy, $ro * 2, $ro * 2, $start_arc, $end_arc, $black);
#        $img->arc($cx, $cy, $ro * 2, $ro * 2, 0, 360, $black);
        $img->fill($cx, $cy, $gray);	                  # 濴ϥ졼

        $img->line($cx, $cy - $ri, $cx, $cy - $ro, $black);
#       my $rad = $PAI * 2 * $diff_arc / 360;
        my $rad = $PAI * $diff_arc / 180;
        $img->line($cx - $ri * sin($rad),
		   $cy - $ri * cos($rad),
		   $cx - $ro * sin($rad),
		   $cy - $ro * cos($rad),
		   $black);
    }

    # ʪɽ
    #
#    &writeOrganism($img, 'Haemophilus influenzae', $cx, $cy, $black);
    &writeOrganism($img, $OrgName, $cx, $cy, $black);

    # ɽ
    # (6ʬǥɽ)
    &drawScale($img, $SeqLen, 6);


    # geneγΰ
    # 
    while(my $gene = shift(@GeneSet)) {
	
#	@gene = @{$gen};
#	my @gene = split(/[\s\t\n,]+/, $gen);
#print STDERR join(' ', @{$gene}),"<<<\n";
	&drawGene($img, $SeqLen, @{$gene}, $DispGeneName, *GENE_NAMES);
    }

#print STDERR join(' ', @GENE_NAMES),"<<\n";
    @temp = &adjustGeneName(@GENE_NAMES);
    @GENE_NAMES = @temp;

    # gene̾ɽ
    #
    while ( my $geneInfo = shift(@GENE_NAMES) ) {
	my($rad, $x, $y, $gene) = @{$geneInfo};
	my($x1, $y1, $x2, $y2);
	# ʸɽΰ
	if($rad <= $PAI)
	{
	    ($x1, $y1) = ($x,
			  $y - int($GENE_FONT_H / 2 + 0.5));
#	    ($x2, $y2) = ($x1 + length($name) * $font_w, $y1 + $font_h);
	    if($rad == 0)
	    {
		$y1 -= int($GENE_FONT_H / 2 + 0.5);
	    }
	    elsif($rad == $PAI)
	    {
		$y1 += int($GENE_FONT_H / 2 + 0.5);
	    }
	}
	else
	{
	    ($x2, $y2) = ($x,
			  $y + int($GENE_FONT_H / 2 + 0.5));
	    ($x1, $y1) = ($x2 - length($gene) * $GENE_FONT_W,
			  $y2 - $GENE_FONT_H);
	}

	$img->string($GENE_FONT, $x1, $y1, $gene, $black);
    }
    
#    print $img->gif;
    return($img);
}


# Υοޤˤ륯å֥ޥåפ
# (gene̾ɽ򥯥å֥ˤ)
# input : (Υ)ĹgeneΥꥹ(濴ѡfrom, to, gene̾)
# return: gene̾򥭡Ȥޥå׾ͤȤϢ
sub main::createMap
{
    my($len, @geneList) = @_;
    local(@GENE_NAMES) = ();		# ɽ򥯥ꥢ
    my $pai = atan2(0, -1);	# 
    my($i, $j);

    # ϰ֤ǥ
#    @geneList = sort {$ {$a}[1] <=> $ {$b}[1]} @geneList;
    @geneList = sort {$ {$a}[2] <=> $ {$b}[2]} @geneList;

    # gene̾Υ쥤Ȥ
    for($i = 0; $i < scalar(@geneList); $i++)
    {
#	my($gene, $from, $to) = split(/[\s,]+/, $geneList[$i]);
	my($orf, $gene, $from, $to) = @{$geneList[$i]};
	
	# gene̾θ¤ꡢϰ֤ξʤ0Ȥ
	$from = 0 if($from < 0);

	my $rad = 2 * $pai * (($from + $to) / 2) / $len;

	# gene̾Υ쥤Ȥꤹ
	&layoutGeneName($rad, $gene, $orf, *GENE_NAMES);
    }

    @temp = &adjustGeneName(@GENE_NAMES);
    @GENE_NAMES = @temp;

    # ޥå׾
    my %result =();		# ޥå׾(orf̾򥭡ȤϢ)
    for($i = 0; $i < scalar(@GENE_NAMES); $i++)
    {
	my($rad, $x, $y, $gene, $orf) = @{$GENE_NAMES[$i]};
	my @names = split(/[\s]+/, $gene);
	my @links = split(/[\s]+/, $orf);
	my($sx, $sy, $ex, $ey);
	if($rad <= $pai)
	{
	    $sx = $x;
	    $sy = $y - int($GENE_FONT_H / 2 + 0.5);
	    $ey = $sy + $GENE_FONT_H;
	    for($j = 0; $j < scalar(@names); $j++)
	    {
		$ex = $sx + $GENE_FONT_W * length($names[$j]);
#		$result{$names[$j]} =
		if($links[$j] ne $names[$j])
		{
		    $result{$links[$j]} =
			sprintf("AREA SHAPE=\"RECT\" COORDS=\"%d,%d,%d,%d\" onMouseOver=\"status='%s(%s)';return true\"",
				$sx, $sy, $ex, $ey, $links[$j], $names[$j]);
#			    $sx, $sy, $ex, $ey, $names[$j]);
		}
		else
		{
		    $result{$links[$j]} =
			sprintf("AREA SHAPE=\"RECT\" COORDS=\"%d,%d,%d,%d\" onMouseOver=\"status='%s';return true\"",
				$sx, $sy, $ex, $ey, $links[$j]);
		}
		$sx = $ex + $GENE_FONT_W;
	    }
	}
	else
	{
	    $ex = $x;
	    $ey = $y + int($GENE_FONT_H / 2 + 0.5);
	    $sy = $ey - $GENE_FONT_H;
	    for($j = scalar(@names) - 1; $j >= 0; $j--)
	    {
		$sx = $ex - $GENE_FONT_W * length($names[$j]);
#		$result{$names[$j]} =
		if($links[$j] ne $names[$j])
		{
		    $result{$links[$j]} =
			sprintf("AREA SHAPE=\"RECT\" COORDS=\"%d,%d,%d,%d\" onMouseOver=\"status='%s(%s)';return true\"",
				$sx, $sy, $ex, $ey, $links[$j], $names[$j]);
#			    $sx, $sy, $ex, $ey, $names[$j]);
		}
		else
		{
		    $result{$links[$j]} =
			sprintf("AREA SHAPE=\"RECT\" COORDS=\"%d,%d,%d,%d\" onMouseOver=\"status='%s';return true\"",
				$sx, $sy, $ex, $ey, $links[$j]);
		}
		$ex = $sx - $GENE_FONT_W;
	    }
	}
    }

    return(%result);
}

###############################################################################
# ʪ̾ɽ
# input : ᡼֥ȡʪ̾ɽ֤濴ɽ
# return: ʤ
sub writeOrganism
{
    my($img, $orgName, $cx, $cy, $color, $len) = @_;
    my($sx, $sy, $line);
    local(*GIF);

    my $fname = "${DIR_orgname}/${orgName}.gif";
    if ($orgName =~ /^ug\d+$/i) {
        $fname = "${DIR_orgname}/tmp_ug_$$.gif"
    }
    unless(-e $fname) {
        my($db) = new MBGD::DB();
        my($refGenome) = MBGD::Genome->get($db, $orgName);
        my($name) = join(" ", $refGenome->{'orgname'}, $refGenome->{'strain'});
        &MBGD_CreateOrgNameGif($name, $fname);
    }

    open(GIF, "< $fname") || die "$fname: cannot open.\n";
    my $gif = newFromGif GD::Image(GIF);
    close(GIF);

    my($gx, $gy) = $gif->getBounds();           # ᡼
    my $back = $gif->colorClosest(255,255,255);	# طʿ
    $gif->transparent($back);	                # Ʃ

    # ʪ̾ĥ
    my $dW = $RADIUS_SEQ_INNER * 2;
    my $dH = int($dW * $gy / $gx + 0.5);
    my($dx, $dy) = ($cx - int($dW / 2 + 0.5), $cy - int($dH / 2 + 0.5));

    $img->copyResized($gif, $dx, $dy, 0, 0, $dW, $dH, $gx, $gy);

	if ($color && $len) {
		# Ĺɽ
		$img->string(gdMediumBoldFont,
			 $cx - int(length($len) * gdMediumBoldFont->width / 2 + 0.5),
			 $dy + $gy,
			 $len,
			 $color);
	}

    #
    if ($orgName =~ /^ug\d+$/i) {
        unlink($fname);
    }

    return;
}


###############################################################################
# δֳ֤ñ̤
# input : Ĺ
# return: ñ(K, M, G), ()
sub scale
{
    my ($len, $num) = @_;
    my @result;			         # ()
    my @u = ('', 'K', 'M', 'G', 'T');    # ñ

    # ɽñ̤
    my($i, $q);
    for($q = $len, $i = -1; $q > 0; $q = int($q / 1000))
    {
	$i++;
	print STDERR "q = $q$u[$i]\n" if($DEBUG);
    }

    push(@result, $u[$i]);
    $unit = 1000**$i;

    my $x = $len / $num;
    for($i = 0; $i < $num; $i++)
    {
	my $y = $x * $i;
	printf STDERR (" %f", $y / $unit) if($DEBUG);
#	push(@result, sprintf("%.1f", $y / $unit));
	push(@result, sprintf("%.2f", $y / $unit));
    }
    print STDERR "\n", join(" ", @result), "\n" if($DEBUG);

    return(@result);
}


###############################################################################
# 
# input : ᡼֥ȡĹ
# return: ñ(K, M, G), ()
sub drawScale
{
    my($img, $len, $num) = @_;

    my @result = &scale($len, $num);
    my $unit = shift(@result);	# ñ(K,M,G)
    my $pai  = atan2(0, -1);	# Ф
				# ߤ濴ɸߡߤȾ
    my($cx, $cy, $ro, $ri) =
	(@SEQ_CENTER, $RADIUS_SEQ_OUTER, $RADIUS_SEQ_INNER);
    $ro =  $ri;                 # ɽϰϤ꾮ʱߤ˼
#    $ri -= 10;                  # ɽϰϤ꾮ʱߤ˼
    $ri = $RADIUS_DISP_SCALE;	# ɽϰϤ꾮ʱߤ˼

    my($i);
    for($i = 0; $i < $num; $i++)
    {
	my $rad = 2 * $pai * ($i / $num);
	my $ox = $cx + int($ro * sin($rad));
	my $oy = $cy - int($ro * cos($rad));
	my $ix = $cx + int($ri * sin($rad));
	my $iy = $cy - int($ri * cos($rad));

	$img->line($ox, $oy, $ix, $iy, $black);

	# ɽ
	my $str = sprintf("%s%s", $result[$i], $unit);

	my $off_x = 0;		# ɽ֤Υեå(X)
	my $off_y = 0;		# ɽ֤Υեå(Y)
	if($ix == $cx)
	{
	    $off_x = int($SCALE_FONT_W * length($str) / 2) * (-1);
	}
	elsif($ix > $cx)
	{
	    $off_x = $SCALE_FONT_W * length($str) * (-1);
	}

	if($iy == $cy)
	{
	    $off_y = int($SCALE_FONT_H / 2) * (-1);
	}
	elsif($iy > $cy)
	{
	    $off_y = $SCALE_FONT_H * (-1);
	}

#	print STDERR "string($SCALE_FONT, $ix + $off_x, $iy + $off_y, $str, black);\n";
#	$img->string($SCALE_FONT, $ix + $off_x, $iy + $off_y, $str, $black);
	$img->string(gdSmallFont, $ix + $off_x, $iy + $off_y, $str, $black);
    }
}


###############################################################################
# gene˳ΰ
# input : ᡼֥,Ĺ,gene̾,orf̾,ϰ,ɽ(R,G,B)
#         gene̾ɽ(1:, 0:ʤ)
# return: ʤ
sub drawGene
{
    my ($img, $len, $orf, $gene, $from, $to, $colar_R, $color_G, $colar_B,
	$dispName) = @_;
    my $color;
    if(defined($COLORS{"${colar_R}_${color_G}_${colar_B}"}))
    {
	$color = $COLORS{"${colar_R}_${color_G}_${colar_B}"};
    }
    else
    {
	$color = $img->colorAllocate($colar_R, $color_G, $colar_B);
	$COLORS{"${colar_R}_${color_G}_${colar_B}"} = $color;
    }

    my ($cx, $cy) = @SEQ_CENTER;	                     # 󥹤濴
    my ($ri, $ro) = ($RADIUS_SEQ_INNER + 1,                  # ߤȾ
		     $RADIUS_SEQ_OUTER - 1);                 # ߤȾ

    # geneΰ
    my $pai = atan2(0, -1);	                             # Ф
    my $rad;
#    print STDERR " = $pai, FROM = $from, LEN = $len\n" if(DEBUG);
#    &Draw_setLinear();
    $rad    = 2 * $pai * ($from / $len);
    my $rate = (360 - $diff_arc) / 360;
    my $ox1 = $cx + int($ro * sin($rad * $rate) + 0.5);
    my $oy1 = $cy - int($ro * cos($rad * $rate) + 0.5);
    my $ix1 = $cx + int($ri * sin($rad * $rate) + 0.5);
    my $iy1 = $cy - int($ri * cos($rad * $rate) + 0.5);

    $rad    = 2 * $pai * ($to / $len);
    my $ox2 = $cx + int($ro * sin($rad * $rate) + 0.5);
    my $oy2 = $cy - int($ro * cos($rad * $rate) + 0.5);
    my $ix2 = $cx + int($ri * sin($rad * $rate) + 0.5);
    my $iy2 = $cy - int($ri * cos($rad * $rate) + 0.5);

#    print STDERR "polyg->addPt($ix1, $iy1);\n" if($main::PTEST);
#    print STDERR "polyg->addPt($ox1, $oy1);\n" if($main::PTEST);
#    print STDERR "polyg->addPt($ox2, $oy2);\n" if($main::PTEST);
#    print STDERR "polyg->addPt($ix2, $iy2);\n" if($main::PTEST);
    if($ix1 == $ix2 && $iy1 == $iy1 && $ox1 == $ox2 && $oy1 == $oy1)
    {
	$img->line($ix1, $iy1, $ox1, $oy1, $color);
    }
    else
    {
	$polyg = new GD::Polygon;
	$polyg->addPt($ix1, $iy1);	# 
	$polyg->addPt($ox1, $oy1);	# 
	$polyg->addPt($ox2, $oy2);
	$polyg->addPt($ix2, $iy2);
	$img->filledPolygon($polyg, $color);
    }
#    $img->fill(int(($ox1 + $ox2)/2), int(($oy1 + $oy2)/2), $color);

#    print STDERR "drawgenename = $dispName\n";
    return unless($dispName);

    # gene̾ɽ
    # 

    # gene̾θ¤ꡢϰ֤ξʤ0Ȥ
    $from = 0 if($from < 0);

    # geneΰ֤򼨤ľ
    my $roo = $RADIUS_DISP_NAME;
    $rad = 2 * $pai * (($from + $to) / 2) / $len;
    my $rate = (360 - $diff_arc) / 360;
    my $x1 = $cx + int($ro * sin($rad * $rate) + 0.5);
    my $y1 = $cy - int($ro * cos($rad * $rate) + 0.5);
    my $x2 = $cx + int($roo * sin($rad * $rate) + 0.5);
    my $y2 = $cy - int($roo * cos($rad * $rate) + 0.5);
    $img->line($x1, $y1, $x2, $y2, $black);

    # gene̾Υ쥤Ȥꤹ
    &layoutGeneName($rad, $gene, $orf, *GENE_NAMES);
    return;
}


# gene̾ɽ֤ꤹ
# input : geneΰ(濴:radian)gene̾orf̾
sub layoutGeneName
{
    local($rad, $gene, $orf, *GENE_NAMES) = @_;
    my($cx, $cy) = @SEQ_CENTER;
    my $font_w = $GENE_FONT_W;	# gdSmallFont->width;
    my $font_h = $GENE_FONT_H;	# gdSmallFont->height;
#    my $off = int(sqrt($font_w**2 + $font_h**2) + 0.5);
    my $off = int($font_h / 2);
    my $ro  = $RADIUS_DISP_NAME + $off;        # gene̾ɽ߼Ⱦ
#    my $ro  = $RADIUS_DISP_NAME;               # gene̾ɽ߼Ⱦ

    my $rate = (360 - $diff_arc) / 360;
    # 
    my $x = $cx + int(sin($rad * $rate) * $ro + 0.5);
    my $y = $cy - int(cos($rad * $rate) * $ro + 0.5);

#    print STDERR join("\t", $x, $y, $gene, $x1, $y1, $x2, $y2), "\n"
#	if($DEBUG);

#    &adjustGeneName($rad, $x, $y, $gene, $orf, *GENE_NAMES);
#    push(@GENE_NAMES, join("\t", $rad, $x, $y, $gene, $orf));
    push(@GENE_NAMES, [$rad, $x, $y, $gene, $orf]);
}


# gene̾ɽ֤Ĵ᤹
### input : 濴(radian), ɽ(x,y), gene̾, orf̾
# input : Gene̾ɽꥹ(Geneγϰ֤ǥȤ줤)
# return: ʤ
sub adjustGeneName
{
    local(@GeneNames) = @_;

    my(@geneSet_1, @geneSet_2, @geneSet_3, @geneSet_4);
    my(@result, @result_1, @result_2, @result_3);
    my $phase = 0;
    my($i);

    # ɽ(濴)4ʬह
    for($i = 0; $i < scalar(@GeneNames); $i++)
    {
	my($rad, $x, $y, $gene, $orf) = @{$GeneNames[$i]};
	print STDERR "--> $rad, $x, $y, $gene, $orf -->\n" if($TEST);
	# 0  3 ޤǤϰ
	if($rad >= 0 && $rad <= $PAI / 2)
	{
	    push(@geneSet_1, $GeneNames[$i]);
	    $phase = 1;
	}
	# 3  6 ޤǤϰ
	elsif($rad > $PAI / 2 && $rad <= $PAI)
	{
	    @geneSet_1 = &putGeneName( 1, -1, @geneSet_1) if($phase == 1);
	    $phase = 2;
	    if(scalar(@geneSet_1) &&
#	       &isGeneOverlap(1, $geneSet_1[$#geneSet_1], $GeneNames[$i]))
	       &isGeneOverlap($geneSet_1[$#geneSet_1], $GeneNames[$i]))
	    {
		my($p_rad, $p_x, $p_y, $p_gene, $p_orf) = @{pop(@geneSet_1)};
		$p_gene .= " $gene";
		$p_orf  .= " $orf";
		push(@geneSet_1, [$p_rad, $p_x, $p_y, $p_gene, $p_orf]);
	    }
	    else
	    {
		unshift(@geneSet_2, $GeneNames[$i]);
	    }
	}
	# 6  9 ޤǤϰ
	elsif($rad > $PAI && $rad <= $PAI * 3 / 2)
	{
	    @geneSet_2 = &putGeneName(-1, 1, @geneSet_2) if($phase == 2);
	    $phase = 3;
	    push(@geneSet_3, $GeneNames[$i]);
	}
	# 9  12 ޤǤϰ
	else
	{
	    @geneSet_3 = &putGeneName(-1, -1, @geneSet_3) if($phase == 3);
	    $phase = 4;
	    if(scalar(@geneSet_3) &&
#	       &isGeneOverlap(-1, $geneSet_3[$#geneSet_3], $GeneNames[$i]))
	       &isGeneOverlap($geneSet_3[$#geneSet_3], $GeneNames[$i]))
	    {
		my($p_rad, $p_x, $p_y, $p_gene, $p_orf) = @{pop(@geneSet_3)};
		$p_gene = "$gene $p_gene";
		$p_orf  = "$orf $p_orf";
		push(@geneSet_3, [$p_rad, $p_x, $p_y, $p_gene, $p_orf]);
	    }
	    else
	    {
		unshift(@geneSet_4, $GeneNames[$i]);
	    }
	}
    }

    @result_1 = &putGeneName( 1, -1, @geneSet_1);
    @result_2 = &putGeneName(-1,  1, @geneSet_2);
    @result_3 = &putGeneName(-1, -1, @geneSet_3);
    @result_4 = &putGeneName( 1,  1, @geneSet_4);

    @result = (@result_1, @result_2, @result_3, @result_4); 

    if($TEST) {
        for($i = 0; $i < scalar(@result); $i++) {
            print STDERR join("\t", @{$result[$i]}), "\n";
        }
    }

    return(@result);
}


# Gene̾Ťʤʤ褦֤
# input : Gene̾Ťʤä̾¤٤(1 or -1)
#         Gene̾Ťʤäΰưˡ
#         (Gene̾ư=-1Gene̾ư=1)
#         GeneGene˥ꥹ
# output: ָΥꥹ
sub putGeneName
{
    my($dir, $mov, @geneSet) = @_;
    my @result;
#    my($cx, $cy) = @SEQ_CENTER;	        # 󥹤򤢤魯ߤ濴
    my $font_w   = $GENE_FONT_W;	# gdSmallFont->width;
    my $font_h   = $GENE_FONT_H;	# gdSmallFont->height;
    my $lim_ov   = $FONT_ALLOWED_OVLAP;	# ʸνŤʤε(pixel)

    while(scalar(@geneSet))
    {
	my $info = shift(@geneSet);
	if(scalar(@result) == 0)
	{
	    push(@result, $info);
	}
	else
	{
	    # ľgeneΰ֤ӤŤʤ뤫ɤå
	    my($p_rad, $p_x, $p_y, $p_gene, $p_orf) = @{$result[$#result]};
	    my($n_rad, $n_x, $n_y, $n_gene, $n_orf) = @{$info};

	    print STDERR join("\t", @{$result[$#result]}), "\n" if($TEST);
	    print STDERR join("\t", @{$info}), "\n"             if($TEST);
	    print STDERR "$n_x < $p_x + ($dir * length($p_gene) * $font_w))\n"
		if($TEST);

	    # yɸκեȤι⤵̤濴ѤǦФ٤Ǥʤ
#	    if(abs($n_y - $p_y) < $font_h - $lim_ov &&
#	       sin($n_rad) * sin($p_rad) > 0        &&
#	       $dir * $n_x < $dir * ($p_x + ($dir * length($p_gene) * $font_w)))
#	    if(isGeneOverlap($dir, $result[$#result], $info))
	    if(isGeneOverlap($result[$#result], $info))
	    {
		# Ťʤä硢ɲ
		pop(@result);
		if($dir > 0)
		{
		    print STDERR "-- 1 --\n" if($TEST);
		    $p_gene .= " $n_gene";
		    $p_orf  .= " $n_orf";
		}
		else
		{
		    print STDERR "-- 2 --\n" if($TEST);
		    $p_gene = "$n_gene $p_gene";
		    $p_orf  = "$n_orf $p_orf";
		}
		# ɽ֤η
		if($mov == -1)
		{
		    push(@result, [$p_rad, $p_x, $p_y, $p_gene, $p_orf]);
		}
		else
		{
		    push(@result, [$n_rad, $n_x, $n_y, $p_gene, $p_orf]);
		}
	    }
	    else
	    {
		print STDERR "-- 3 --\n" if($TEST);
		# Ťʤʤä餽ΤޤޤͤǼ
		push(@result, $info);
	    }
	}
    }
    return(@result);
}


# Gene̾ɽݡ줬Ťʤ뤫Ƚ̤
# input : Gene̾Ťʤä̾¤٤(1 or -1)
#         GeneΥե(1)GeneΥե(2)
# output: 1 = ŤʤäƤ롢0 = ŤʤäƤʤ
sub isGeneOverlap
{
#    my($dir, $p_info, $n_info) = @_;
    my($p_info, $n_info) = @_;
    my($p_rad, $p_x, $p_y, $p_gene, $p_orf) = @{$p_info};
    my($n_rad, $n_x, $n_y, $n_gene, $n_orf) = @{$n_info};
#    my($cx, $cy) = @SEQ_CENTER;	        # 󥹤򤢤魯ߤ濴
    my $font_w   = $GENE_FONT_W;	# gdSmallFont->width;
    my $font_h   = $GENE_FONT_H;	# gdSmallFont->height;
    my $lim_ov   = $FONT_ALLOWED_OVLAP;	# ʸνŤʤε(pixel)

    return(0) if(sin($n_rad) < 0 && sin($p_rad) >= 0);

    my $sig;			# Gene̾¤٤
    if($n_rad >= 0)
    {
	$sig = 1;
    }
    else
    {
	$sig = -1;
    }

#    print STDERR "if(abs($n_y - $p_y) < $font_h - $lim_ov &&\n";
    if(abs($n_y - $p_y) < $font_h - $lim_ov &&
       $sig * $n_x < $sig * ($p_x + ($sig * length($p_gene) * $font_w)))
    {
	return(1);
    }

    return(0);
}


###############################################################################
