#!/usr/bin/perl -s

###############################################################################
#
###############################################################################
use GD;

use MBGD;
use MBGD::FuncCat;
use MBGD::FunctionCategory;
use MBGD::ClustTab::DB;

##############################################################################
# Υο޴Ϣ (GIF᡼)
@MBGD_WHOLE_IMG_SIZE    = (600, 480);  # ᡼
@MBGD_WHOLE_IMG_CENTER  = (300, 240);  # ߤ濴ɸ
$MBGD_WHOLE_IMG_INNER_R = 140;         # ߤȾ
$MBGD_WHOLE_IMG_OUTER_R = 196;         # ߤȾ

$MBGD_WHOLE_IMG_WIDTH   = 10;          # ߼()
$MBGD_WHOLE_IMG_LINEAR_ARC = 350;      # Υξ濴

##############################################################################
# Υʬ޴Ϣ (GIF᡼)
@MBGD_REGION_IMG_SIZE  = (750, 200);           # ᡼
@MBGD_REGION_IMG_SEQ   = (  0,  85, 750, 115); # (rectangle)ΰ
$MBGD_REGION_IMG_SEQ_WIDTH = 5;                # Υ(Ĥκ)
@MBGD_REGION_IMG_SCALE = (  0,  90, 750, 110); # ɽ 

$MBGD_REGION_IMG_GENOME_COLOR    = "0_200_70";    # ΥΥǥեȥ顼
$MBGD_REGION_IMG_GENE_COLOR      = "180_255_255"; # ҤΥǥեȥ顼(1)
$MBGD_REGION_IMG_GENE_COLOR_LINK = "0_255_255";   # ҤΥǥեȥ顼(2)

$MBGD_REGION_IMG_GENE_LINE_COLOR      = "0_0_0";
$MBGD_REGION_IMG_GENE_NO_LINE_COLOR      = "200_200_200";

$MBGD_REGION_IMG_GENE_HEIGHT     = 10;         # ޾ΰҤι⤵
$MBGD_REGION_IMG_GENE_OFFSET     = 3;          # 󥹤ȤεΥ

@MBGD_REGION_IMG_GENE_COLOR_LIST = (
				    [ 255,   0,   0 ],
				    [   0, 255,   0 ],
				    [   0,   0, 255 ],
				    [ 255, 150, 255 ],
				    [ 255, 155,   0 ],
				    [ 230, 255,   0 ],
				    [  30, 150, 180 ],
##				    [ 204, 128,   0 ],
				    [ 204, 204, 230 ],
				    [ 155, 100, 255 ],
				    [ 130,   0, 130 ],
				    [   0, 128,  50 ],	# added by uchiyama
				    [ 153,   0,  50 ],	# added by uchiyama
				    [  50,   0, 150 ]
		      );

@MBGD_REGION_IMG_GENE_TILE_COLOR_LIST = (
		    [ 255, 200,   0 ] # 1    ()
		   ,[   0, 255,   0 ] # 2    ()
		   ,[   0, 128,  70 ] # 3    ()
		   ,[   0, 150, 255 ] # 4    ()
		   ,[   0,   0, 200 ] # 5    ()
		   ,[ 250, 250, 250 ] # 7    ()
		   ,[   0,   0,   0 ] # 6    ()
		   ,[ 255,   0,   0 ] # 0    ()
####		    [ 255,   0,   0 ], # 0    ()
####		    [ 255, 200,   0 ], # 1    ()
####		    [   0, 255,   0 ], # 2    ()
####		    [   0, 128,  70 ], # 3
####		    [   0, 150, 255 ], # 4    ()
####		    [   0,   0, 200 ], # 5    ()
####		    [   0,   0,   0 ], # 6    ()
####		    [ 250, 250, 250 ]  # 7    (?)
		      );

###############################################################################
# ꤵ줿ޥɤ˽GD饤֥Ȥäƥ᡼
# input : ޥɥꥹ
# return: ᡼֥
#
# ޥɡ󥿥å
#
#   ᡼ (ɬܡޥɥꥹȤƬꤹ)
#     ImageSize width height
#
#   ͳѷ
#     rect x1 y1 x2 y2 color ʹcomment
#
#   ľ
#     line x1 y1 x2 y2 color ʹcomment
#
#   ɤ
#     fill x y color comment
#
#   ʸ
#     string font x y "text" color ʹcomment
#
sub MBGDImg_Draw {
    my(@cmnd_list) = @_;
    my($im);
    my($cmnd, @token);
    my($imgWidth, $imgHeight);
    my($Background);
    my(@Tiles);

    push(@Tiles, &MBGDImg_MakeMonoColorTiles(@MBGD_REGION_IMG_GENE_COLOR_LIST));
    push(@Tiles, &MBGDImg_MakePatternTiles(@MBGD_REGION_IMG_GENE_TILE_COLOR_LIST));
    $NUM_TILE_PATTERNS = scalar(@Tiles);

    while(scalar(@cmnd_list)) {
        $cmnd = shift(@cmnd_list);
        next if($cmnd =~ /^\s*$/);
        if($cmnd =~ /^\s*ImageSize\s+(\d+)[\s,]+(\d+)\s*/) {
            ($imgWidth, $imgHeight) = ($1, $2);
            if($imgWidth == 0 || $imgHeight == 0) {
                die "Invalid image size !!";
            }
            last;
        }
        else {
            print STDERR "Invalid command list !!\n";
        }
    }

    $im = new GD::Image($imgWidth, $imgHeight);

    $COLOR{'black'}     = $im->colorAllocate(  0,   0,   0);
    $COLOR{'white'}     = $im->colorAllocate(255, 255, 255);
#    $COLOR{'red'}       = $im->colorAllocate(255,   0,   0);
#    $COLOR{'green'}     = $im->colorAllocate(  0, 255,   0);
#    $COLOR{'blue'}      = $im->colorAllocate(  0,   0, 255);
#    $COLOR{'yellow'}    = $im->colorAllocate(255, 255,   0);
#    $COLOR{'orange'}    = $im->colorAllocate(255,  80,   0);
#    $COLOR{'cyan'}      = $im->colorAllocate(  0, 255, 255);
#    $COLOR{'darkGreen'} = $im->colorAllocate(  0, 200,  70);

    $COLOR{$MBGD_REGION_IMG_GENOME_COLOR} =
            $im->colorAllocate(split( /_/, $MBGD_REGION_IMG_GENOME_COLOR));
    $COLOR{$MBGD_REGION_IMG_GENE_COLOR}   =
            $im->colorAllocate(split( /_/, $MBGD_REGION_IMG_GENE_COLOR));

    while(scalar(@cmnd_list)) {
        $cmnd = shift(@cmnd_list);
        next if($cmnd =~ /^\s*$/ || $cmnd =~ /ImageSize/);

        $cmnd =~ s/^\s+//g;
        @token = split(/[\s\n\t,]+/, $cmnd);
        if ($token[0] eq "line") {
            $im->line($token[1], $token[2], $token[3], $token[4],
			&colorAlloc($token[5], $im));
        } elsif ($token[0] eq "rect") {
            $cmnd =~ /rect\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s*/;
            my($x1, $y1, $x2, $y2, $colorID) = ($1, $2, $3, $4, $5);
            if($5 =~ /\d+_\d+_\d+/) {
                $im->rectangle( $x1, $y1, $x2, $y2, &colorAlloc($colorID,$im));
            } else {
                $im->setTile($Tiles[&getTileIdx($colorID)]);
                $im->rectangle($x1, $y1, $x2, $y2, gdTiled);
            }
        } elsif ( $token[0] eq "fill" ) {
            if($token[3] =~ /\d+_\d+_\d+/ || $token[3] !~ /^[0-9]+$/) {
my($c) = &colorAlloc($token[3],$im);
#                $im->fill($token[1], $token[2], &colorAlloc($token[3],$im));
                $im->fill($token[1], $token[2], $c);
            } else {
                $im->setTile($Tiles[&getTileIdx($token[3])]);
                $im->fill($token[1], $token[2], gdTiled);
            }
        } elsif ( $token[0] eq "polygon" ) {
	    my($x,$y);
	    my($poly) = GD::Polygon->new;
	    $numv = $token[1];
	    for ($i = 0; $i < $numv; $i++) {
		$x = $token[2 + $i * 2];
		$y = $token[2 + $i * 2 + 1];
		$poly->addPt($x, $y);
	    }
	    $im->filledPolygon($poly, &colorAlloc($token[$#token], $im));
        } elsif ($token[0] eq "string") {
            $cmnd =~ /^string\s+(\S+)\s+(\d+)\s+(\d+)\s+\"(.+)\"\s+(\S+)\s*/;
#print STDERR "cmnd: $cmnd; $1,$2,$3,$5\n";
	    my $color = &colorAlloc($5,$im);
            eval "\$im->string($1, $2, $3, \"$4\", \$color)";
        } elsif ($token[0] eq "Background") {
            $im->fill( 1, 1, &colorAlloc($token[1],$im));
	    $Background = $token[1];
        } elsif ($token[0] eq "color") {
	     &colorAlloc($token[1],$im);
        } elsif ($token[0] eq "nop") {
            # no operation
        } else {
            print STDERR "Invalid command: $cmnd\n";
        }
    }

    return $im;
}
sub colorAlloc {
	my($colname, $im) = @_;
	if (! $COLOR{$colname}) {
		if ($colname =~ /^(\d+)_(\d+)_(\d+)/) {
			$COLOR{$colname} = $im->colorAllocate( $1, $2, $3 );
		}
	}
	return $COLOR{$colname};
}
sub getTileIdx {
	my($colorID) = @_;
	my $colnum = scalar(@MBGD_REGION_IMG_GENE_COLOR_LIST);
	my $tilenum = $NUM_TILE_PATTERNS - $colnum;

	if ($colorID < ($NUM_TILE_PATTERNS)) {
		return $colorID;
	} else {
	        return $colnum + ( ($colorID - $colnum) % $tilenum );
	}
}

###############################################################################
#
sub _calcDrawPos {
    my($refArgs) = shift;
    my($ref) = {};

    #
    my($regStart)    = $refArgs->{'regStart'};
    my($regEnd)      = $refArgs->{'regEnd'};
    my($ImgWidth)    = $refArgs->{'ImgWidth'};
    my($RegWidth)    = $refArgs->{'RegWidth'};
    my($from)        = $refArgs->{'from'};
    my($to)          = $refArgs->{'to'};
    my($strand)      = $refArgs->{'strand'};
    my($prt_name)    = $refArgs->{'prt_name'};
    my($font_width)  = $refArgs->{'font_width'};
    my($font_height) = $refArgs->{'font_height'};
    my($char_offset) = $refArgs->{'char_offset'};

    $from = $regStart  if($from < $regStart);
    $to   = $regEnd    if($to   > $regEnd  );

    $ref->{'x0'} =
    $ref->{'x1'} = int(($from - $regStart) * $ImgWidth / $RegWidth);
    $ref->{'x2'} = int(($to   - $regStart) * $ImgWidth / $RegWidth);

    # ϰϳξ硢
    $ref->{'x1'} = 0         if ($ref->{'x1'} < 0);
    $ref->{'x1'} = $ImgWidth if ($ImgWidth < $ref->{'x1'});
    $ref->{'x2'} = 0         if ($ref->{'x2'} < 0);
    $ref->{'x2'} = $ImgWidth if ($ImgWidth < $ref->{'x2'});

    if($strand eq "+") {
        $ref->{'y2'}  = $MBGD_REGION_IMG_SEQ[1] - $MBGD_REGION_IMG_GENE_OFFSET;
        $ref->{'y1'}  = $ref->{'y2'} - $MBGD_REGION_IMG_GENE_HEIGHT;
        $ref->{'y0'}  = $ref->{'y1'} - $font_height - $char_offset;
        $ref->{'end'} = $ref->{'x0'} + (length($prt_name) + 1) * $font_width;
    }
    else {
        $ref->{'y1'}  = $MBGD_REGION_IMG_SEQ[3] + $MBGD_REGION_IMG_GENE_OFFSET;
        $ref->{'y2'}  = $ref->{'y1'} + $MBGD_REGION_IMG_GENE_HEIGHT;
        $ref->{'y0'}  = $ref->{'y2'} + $char_offset;
        $ref->{'end'} = $ref->{'x0'} + (length($prt_name) + 1) * $font_width;
    }

    return $ref;
}

###############################################################################
# ꡼ΰҤΥ쥤ȤꤷѥޥɥꥹȤ
# input :
# result: ޥɥꥹ(MBGD_Draw)
#
sub MBGDImg_Layout {
    my($Organism, $ChrId, $ContigId, $RegCenter, $RegWidth, $opt) = @_;
    my(@list);
    my($i, $j);
    my($RegStart, $RegEnd);
    my($GeneName, $Reverse, $NoOrfName) = ($opt->{GeneName}, $opt->{Reverse}, $opt->{NoOrfName});
    my(%GeneColor);

    $RegStart = $RegCenter - int($RegWidth / 2);
    $RegEnd   = $RegStart  + $RegWidth;

    if ($opt->{MODE} eq 'funccat') {
		%GeneColor = getFuncColorsByFuncDb($Organism, $ChrId, $ContigId, $RegStart, $RegEnd, $opt->{'FUNCCAT_TYPE'});
    }

    my($font_width, $font_height) = (gdMediumBoldFont->width,
                                     gdMediumBoldFont->height);

#
    my($ImgWidth, $ImgHeight) = @MBGD_REGION_IMG_SIZE;
    push(@list, "fill 1 1 white");

    	## drawing the scale bars (representing the chromosome)
    push(@list, sprintf("rect %d %d %d %d %s",
            $MBGD_REGION_IMG_SEQ[0],
            $MBGD_REGION_IMG_SEQ[1],
            $MBGD_REGION_IMG_SEQ[2],
            $MBGD_REGION_IMG_SEQ[1] + $MBGD_REGION_IMG_SEQ_WIDTH,
            $MBGD_REGION_IMG_GENOME_COLOR));
    push(@list, sprintf("rect %d %d %d %d %s",
            $MBGD_REGION_IMG_SEQ[0],
            $MBGD_REGION_IMG_SEQ[3],
            $MBGD_REGION_IMG_SEQ[2],
            $MBGD_REGION_IMG_SEQ[3] - $MBGD_REGION_IMG_SEQ_WIDTH,
            $MBGD_REGION_IMG_GENOME_COLOR));
    push(@list, sprintf("fill %d %d %s",
            $MBGD_REGION_IMG_SEQ[0] + 1,
            $MBGD_REGION_IMG_SEQ[1] + 1,
            $MBGD_REGION_IMG_GENOME_COLOR));
    push(@list, sprintf("fill %d %d %s",
            $MBGD_REGION_IMG_SEQ[0] + 1,
            $MBGD_REGION_IMG_SEQ[3] - 1,
            $MBGD_REGION_IMG_GENOME_COLOR));

	### get genes within the region
    my(@genes);

if ($ChrId || $ContigId) {
    @genes  = &subMBGDImg_get_genes($Organism, $ChrId, $ContigId, $RegStart, $RegEnd, $opt)
} elsif ($opt->{CenterGene}) {
    ## no chromosome/contig id
    @genes = &subMBGDImg_get_genes_nochrom("$Organism:$opt->{CenterGene}");
}

    my($regStart, $regEnd);
    my($sclStart, $sclgEnd);    # ѤΥ꡼󳫻ϡλ

    if($Reverse < 0) {
	## Turn the chromosome upside down.
	## Direction of each gene should be reversed.
        my(@new_genes);
        my(@tmp) = @genes;
        while(scalar(@tmp)) {
            $line =  shift(@tmp);
            my($strand, $from, $to, $gene_name, $prt_name, $geneType, $geneLocation) = split(/\t/, $line);
            $strand =~ tr/-+/+-/;
            $from   *= -1;
            $to     *= -1;
            my($newGene) = sprintf(join("\t", "%s", "%d", "%d", "%s", "%s", "%s", "%s"),
                     $strand,
                     $to,
                     $from,
                     $gene_name,
                     $prt_name, $geneType, $geneLocation);
            push(@new_genes, $newGene);
        }
        @genes = reverse @new_genes;
        ($regStart, $regEnd) = ($RegEnd * (-1), $RegStart * (-1));
        ($sclStart, $sclEnd) = ($RegEnd, $RegStart);
    } else {
        ($regStart, $regEnd) = ($RegStart, $RegEnd);
        ($sclStart, $sclEnd) = ($RegStart, $RegEnd);
    }

    # Gene 
    my$linecolor = $MBGD_REGION_IMG_GENE_NO_LINE_COLOR;
    if ($RegWidth < 20000) {
        # Gene ζڤ꤬ʬפ褦ˡGene Ȥ褹
        $linecolor = $MBGD_REGION_IMG_GENE_LINE_COLOR;
    }

    #
    my($refDrawPosArgs) = {};
    $refDrawPosArgs->{'regStart'}    = $regStart;
    $refDrawPosArgs->{'regEnd'}      = $regEnd;
    $refDrawPosArgs->{'ImgWidth'}    = $ImgWidth;
    $refDrawPosArgs->{'RegWidth'}    = $RegWidth;
    $refDrawPosArgs->{'font_width'}  = $font_width;
    $refDrawPosArgs->{'font_height'} = $font_height;
    $refDrawPosArgs->{'char_offset'} = (1);              # ORFORF̾Ȥδֳ
    my(@GeneLayout, @NameList);
    my($cmdDraw);
    my($x0, $y0, $x1, $y1, $x2, $y2, $end, $lineno);
    my(@fwd_line, @rev_line);
    for($i = 0; $i < scalar(@genes); $i++) {
        my($strand, $from, $to, $gene_name, $prt_name, $geneType, $geneLocation) = split(/\t/, $genes[$i]);
        if ($prt_name eq '') {
           $prt_name = $gene_name;
        }
        $from = $regStart  if($from < $regStart);
        $to   = $regEnd    if($to   > $regEnd  );

        # ֤򻻽
        $refDrawPosArgs->{'strand'}   = $strand;
        $refDrawPosArgs->{'prt_name'} = $prt_name;
        $refDrawPosArgs->{'from'}     = $from;
        $refDrawPosArgs->{'to'}       = $to;
        my($refPos) = _calcDrawPos($refDrawPosArgs);

        # gene Τ褻å֥ˤ뤿Υޥ
        $cmdDraw = sprintf("nop %4d %4d %4d %4d %s %s %s", 
                      $refPos->{'x1'}, $refPos->{'y1'}, $refPos->{'x2'}, $refPos->{'y2'},
                      $MBGD_REGION_IMG_GENE_LINE_COLOR,
                      $gene_name, $prt_name);
        push(@GeneLayout, $cmdDraw);
        if ($refPos->{'x1'} + 1 < $refPos->{'x2'} && $refPos->{'y1'} + 1 < $refPos->{'y2'}) {
print STDERR "rr>$refPos->{x1},$refPos->{x2},$refPos->{y1},$refPos->{y2}\n";
            if ($geneType =~ /rna/i) { # RNA ǡ
                if ($refPos->{'x1'} < 0) {
                    $refPos->{'x1'} = 0;
                }
                if ($ImgWidth - 1 <= $refPos->{'x1'}) {
                    $refPos->{'x1'} = $ImgWidth - 1;
                }
                if ($refPos->{'x2'} < 0) {
                    $refPos->{'x2'} = 0;
                }
                if ($ImgWidth - 1 <= $refPos->{'x2'}) {
                    $refPos->{'x2'} = $ImgWidth - 1;
                }
                $cmdDraw = sprintf("rect %4d %4d %4d %4d %s %s %s", 
                                   $refPos->{'x1'}, $refPos->{'y1'},
                                   $refPos->{'x2'}, $refPos->{'y2'},
                                   $MBGD_REGION_IMG_GENE_LINE_COLOR,
                                   '', '');
                push(@GeneLayout, $cmdDraw);

                my($fillx) = int(($refPos->{'x1'} + $refPos->{'x2'}) / 2);
                my($filly) = int(($refPos->{'y1'} + $refPos->{'y2'}) / 2);
                $gcol = '0_0_128'; # RNA ǡ迧
                $cmdDraw =  sprintf("fill %4d %4d %s %s",
                                          $fillx, $filly, 
                                          $gcol,
                                          $gene_name);
                push(@GeneLayout, $cmdDraw);
            }
            else {
                #
                $gcol = $MBGD_REGION_IMG_GENE_COLOR;
                if ($GeneColor{$gene_name}) {
                    $gcol = $GeneColor{$gene_name};
                }

                # Exon 褹
                my($refLocation) = MBGD::Gene::parseLocation({}, $geneLocation);
                foreach my$refExon (@{$refLocation->{'EXON'}}) {
                    # ֤򻻽
                    $refDrawPosArgs->{'from'} = $refExon->{'FROM'};
                    $refDrawPosArgs->{'to'}   = $refExon->{'TO'};
                    if($Reverse < 0) {
                        $refDrawPosArgs->{'from'} *= -1;
                        $refDrawPosArgs->{'to'}   *= -1;
                    }
                    my($refPosExon) = _calcDrawPos($refDrawPosArgs);

                    # ϰȤ
                    if ($refPosExon->{'x1'} < 0) {
                        $refPosExon->{'x1'} = 0;
                    }
                    if ($ImgWidth <= $refPosExon->{'x2'}) {
                        $refPosExon->{'x2'} = $ImgWidth - 1;
                    }

                    if ((($refPosExon->{'x1'} < 0) && ($refPosExon->{'x2'} < 0)) ||
                        (($ImgWidth <= $refPosExon->{'x1'}) && ($ImgWidth <= $refPosExon->{'x2'}))) {
                        # ϰϳ
                    }
                    else {
                        # ȤȤơ$gene_name  $prt_name ϤƤ롣
                        # /htbin/MBGD_region_html.pl ˤơGene Ȥ褹ݤѤƤ
                        $cmdDraw = sprintf("rect %4d %4d %4d %4d %s %s %s",
                                            $refPosExon->{'x1'}, $refPosExon->{'y1'},
                                            $refPosExon->{'x2'}, $refPosExon->{'y2'},
                                            $MBGD_REGION_IMG_GENE_LINE_COLOR,
                                            $gene_name, $prt_name);
                        push(@GeneLayout, $cmdDraw);
                        if (1 < abs($refPosExon->{'x1'} - $refPosExon->{'x2'})) {
                            my($fillx) = int(($refPosExon->{'x1'} + $refPosExon->{'x2'}) / 2);
                            if ($ImgWidth <= $fillx) {
                                $fillx = $ImgWidth - 1;
                            }
                            $cmdDraw = sprintf("fill %4d %4d %s %s",
                                                      $fillx, $refPosExon->{'y1'} + 1,
                                                      $gcol,
                                                      $gene_name);
                            push(@GeneLayout, $cmdDraw);
                        }
                    }
                }

                # INTRON 褹
                my($refLocation) = MBGD::Gene::parseLocation({}, $geneLocation);
                foreach my$refIntron (@{$refLocation->{'INTRON'}}) {
                    # ֤򻻽
                    $refDrawPosArgs->{'from'} = $refIntron->{'FROM'};
                    $refDrawPosArgs->{'to'}   = $refIntron->{'TO'};
                    if($Reverse < 0) {
                        $refDrawPosArgs->{'from'} *= -1;
                        $refDrawPosArgs->{'to'}   *= -1;
                    }
                    my($refPosIntron) = _calcDrawPos($refDrawPosArgs);

                    # ϰȤ
                    if ($refPosIntron->{'x1'} < 0) {
                        $refPosIntron->{'x1'} = 0;
                    }
                    if ($ImgWidth <= $refPosIntron->{'x2'}) {
                        $refPosIntron->{'x2'} = $ImgWidth - 1;
                    }

                    if (($refPosIntron->{'x2'} < 0) || ($ImgWidth <= $refPosIntron->{'x1'})) {
                        # ϰϳ
                    }
                    else {
                        my($iy) = ($refPosIntron->{'y1'} + $refPosIntron->{'y2'}) / 2;
                        $cmdDraw = sprintf("line %4d %4d %4d %4d %s %s %s", 
                                            $refPosIntron->{'x1'}, $iy,
                                            $refPosIntron->{'x2'}, $iy,
                                            $MBGD_REGION_IMG_GENE_LINE_COLOR,
                                            '', '');
                        push(@GeneLayout, $cmdDraw);
                    }
                }
            }
        }

        if(! $GeneName || $gene_name =~ /^$GeneName$/i) {
            # ̾Τ
            push(@NameList,
             sprintf("string gdMediumBoldFont %4d %4d \"%s\" %s %s %d %s",
                 $refPos->{'x0'}, $refPos->{'y0'}, $prt_name, "black", $strand, $refPos->{'end'},
                 $gene_name));
        }
    }

    my($cmnd, $font, $st_x, $st_y, $ed_x, $name, $color, $line);
    my(@fwd_line, @rev_line, $j);
    my($min_y, $max_y);
    my(@NewNameList);
    while(scalar(@NameList) > 0) {
        $entry = shift(@NameList);
	($cmnd,$font,$st_x,$st_y,$name,$color,$strand,$ed_x,$comment)
			= split(/\s+/,$entry);
	$name =~ s/\"//g;

        if($strand eq "+") {
            for($j = 0; $fwd_line[$j] > $st_x; $j++){}
            $fwd_line[$j] = $ed_x;
            $line = $j;

            $st_y -= $font_height * $line;
            $min_y = $st_y if($min_y > $st_y);
        }
        else {
            for($j = 0; $rev_line[$j] > $st_x; $j++) {
            }

            $rev_line[$j] = $ed_x;
            $line =  $j;

            $st_y += $font_height * $line;
            $max_y = $st_y + $font_height if($max_y < $st_y + $font_height);
        }

        unless($NoOrfName) {
            push(@NewNameList, "$cmnd $font $st_x $st_y \"$name\" $color $comment");
        }
    }

    push(@list, @GeneLayout, @NewNameList);

#print STDERR "@{MBGD_REGION_IMG_SCALE}<<<<<<\n";

    ($x1, $y1, $x2, $y2) = @MBGD_REGION_IMG_SCALE;

print STDERR "$x1,$y1, $x2, $y2\n";
    if($y2 - $y1 >= 20) {    # ɽ󤬶ɽʤ
    push(@list,
         &subMBGDImg_plot_scale($Organism, $ChrId, $ContigId, $sclStart, $sclEnd,
                    $x1, $y1, $x2, $y2));
    }
    $MBGD_REGION_IMG_SIZE[1] = $y2 + 20 if($MBGD_REGION_IMG_SIZE[1] < $y2);
    unshift(@list, join(" ", "ImageSize", @MBGD_REGION_IMG_SIZE));

    @list;
}
##temporary??

sub getFuncColors {
	my ($Organism, $chrid, $contigid, $RegStart, $RegEnd, $clusttab) = @_;
	my $clusttab = 'all' if (! $clusttab);
	my @out = MBGD::ClustTab::DB::getSortedClusterSimple($clusttab,
		$Organism, $chrid, $contigid,
		{region=>"$RegStart:$RegEnd"});
	my(%GeneColor);
	foreach my $g (@out) {
		my $funccat = $g->{funccat};
		my $color;
		if (! $FuncColor[$funccat]) {
			my (@dec);
			my $fcol = &MBGD::FuncCat::get_func_color_from_id($funccat);
			for (my $i = 0; $i < 6; $i+=2) {
				push(@dec, hex substr($fcol, $i, 2));
			}
			$FuncColor[$funccat] = join('_', @dec);
		}
		$GeneColor{$g->{name}} = $FuncColor[$funccat];
	}
	%GeneColor;
}

sub getFuncColorsByFuncDb {
	my ($sp, $chrid, $contigid, $RegStart, $RegEnd, $funcDb) = @_;
	my $clusttab = 'all';

	my @out = MBGD::ClustTab::DB::getSortedClusterSimple($clusttab,
		$Organism, $chrid, $contigid,
		{region=>"$RegStart:$RegEnd"});

    #
    my($objFuncCat) = new MBGD::FunctionCategory($funcDb);
	my(%GeneColor);
    my($opt) = {'fromdb' => 1};
	foreach my $g (@out) {
        my($name) = $g->{'name'};
 		my $color;
        my($refFuncList) = $objFuncCat->getFunctionListBySporf("$sp:$name", $opt);
        my($refFunc) = $refFuncList->[0];
        my($funccat) = $refFunc->{'LEVEL'};
		if (! exists($FuncColor{"$funccat"})) {
			my (@dec);
            my($fcol) = $objFuncCat->getFunctionColorByLevel($funccat);
			for (my $i = 0; $i < 6; $i+=2) {
				push(@dec, hex substr($fcol, $i, 2));
			}
			$FuncColor{"$funccat"} = join('_', @dec);
		}
		$GeneColor{"$name"} = $FuncColor{"$funccat"};
	}
	%GeneColor;
}

sub MBGDImg_AddColor {
    my(@commands) = @_;
    my( $first_line ) = shift( @commands );

    unshift( @commands, "color 255_0_0\n" );

    if (1 < $Dom_num) {
	# the central gene has more than one domain
        my(@domLine);
        foreach $drawCmd (@commands) {
            if ($drawCmd =~ /^\s*rect\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+\d+_\d+_\d+\s+($GeneName\s.*)\s*(\S+)/i) {
                ($x0, $y0, $x1, $y1, $comment, $prtname) = ($1, $2, $3, $4, $5, $6);
                $drawCmd =~ s/\d+_\d+_\d+/0_0_0/;
                for($ii = 1; $ii < $Dom_num; $ii++) {
                    # draw frame with black
                    push(@domLine,
                    sprintf("line %d %d %d %d 0_0_0 $comment",
                             $x0 + ($x1 - $x0) / $Dom_num * $ii, $y0,
                             $x0 + ($x1 - $x0) / $Dom_num * $ii, $y1));
                }
            }
        }
        push(@commands, @domLine);
    }

    if ($MODE eq 'funccat') {
        foreach $gc (@GeneColor) {
		my( $gene,$color ) = split( /:/, $gc );
		for (my $i = 0; $i < @commands; $i++) {
			$commands[$i] =~ s/^(\s*(fill|rect)\s.+\s)\S+(\s+$gene\s*)$/$1 $color $3/i;
		}
		unshift( @commands, "color $color\n" );
	}
    } elsif( scalar( @GeneColor )) {
	my %GeneColorHash;
        foreach $gc (@GeneColor) {
		my( $gene,$color,$dom,$from,$to ) = split( /:/, $gc );
		push(@{$GeneColorHash{$gene}}, $gc);
	}

	foreach $gene (keys %GeneColorHash) {
		my($rectx0, $rectx1, $rectx1, $recty1);
		my(@domLine,$drawCmdNew);
                while ($drawCmd = shift @commands) {
                    if ($drawCmd =~ /^rect.*\s${gene}.*$/) {
                        ($dmy,$rectx0,$recty0,$rectx1,$recty1,
				$rectcolor,$comment) = split(/\s+/,$drawCmd);

			foreach $gdata (@{$GeneColorHash{$gene}}) {
				my( $g0, $color, $dom, $from,$to )
					= split( /:/, $gdata );
				$to = 1 if (! $to);

			## AHO!! : 40 < $recty0 means gene_direction < 0 
			##       renumbering domain number
				if (40 < $recty0) {
					my $tmpfrom = $from;
					$from = 1 - $to; $to = 1 - $tmpfrom;
				}

			## determine the domain region to be colored
				my($x0, $y0, $x1, $y1);
				$x0 = int($rectx0 + ($rectx1 - $rectx0) * $from);
				$y0 = $recty0;
				$x1 = int($rectx0 + ($rectx1 - $rectx0) * $to);
				$y1 = $recty1;
#print STDERR ">rect $x0, $y0, $x1, $y1, $color, $comment [$from,$to]\n";
				$drawCmdNew = sprintf("rect %d %d %d %d %s %s", $x0, $y0, $x1, $y1, $color, $comment);
		    		push(@domLine, $drawCmdNew);
			}
		    	push(@domLine, $drawCmd); ## draw border lines
		    } elsif ($drawCmd =~ /^fill\s+(\d+)\s+(\d+)\s+(\S+)\s+(${gene})$/i) {
			$fillx0    = $1;
			$filly0    = $2;
			$fillcolor = $3;
			$comment   = $4;
			foreach $gdata (@{$GeneColorHash{$gene}}) {
				my( $g0, $color, $dom, $from,$to ) = split( /:/, $gdata );


				$to = 1 if (! $to);

				if (40 < $recty0) {
					my $tmpfrom = $from;
					$from = 1 - $to; $to = 1 - $tmpfrom;
				}

				if (int(($rectx1-$rectx0) * ($to-$from)) < 1){
					next;
				}

				my($x0, $y0, $x1, $y1);
				$x0 = int($rectx0 + ($rectx1 - $rectx0) * $to);
#print STDERR "($rectx1 - $rectx0) * ($to - $from) = ";
#print STDERR " ", ($rectx1 - $rectx0) * ($to - $from), " $gene\n";
				$x0--;
				$y0 = $recty0 +1;

#print STDERR ">fill $x0, $y0, $color, $comment  $from,$to\n";
				$drawCmdNew = sprintf("fill %d %d %s %s", $x0, $y0, $color, $comment);
		    		push(@domLine, $drawCmdNew);
				unshift( @domLine, "color $color\n" );
			}
		    } else {
			push(@domLine, $drawCmd);
			next;
		    }
		}
		@commands = @domLine;
	}
    }
    unshift( @commands, $first_line );
}



###############################################################################
#  ֥롼 
###############################################################################

###############################################################################
# GetAllGeneInReg ޥɤνϷ̤ѴȤ̤֤
# input : Organism Sequence-ID, ꡼γϡλ
# result: ȺѤη (Ϲܤ ȥ(+/-)ϡλ̾)
sub subMBGDImg_get_genes {
    my( $org, $chrid, $contigid, $start, $end, $options ) = @_;
    my( @result ) = ();
    my( @list );

    # get chrSeqLen
    my($infoChr);
    if ($chrid) {
        ($infoChr) = MBGD::Chromosome->find( " sp='$org' and id='$chrid' " );
    }
    elsif ($contigid) {
        ($infoChr) = MBGD::Contig->find( " sp='$org' and id='$contigid' " );
    }
    if ($infoChr) {
    	$ChromLen = $infoChr->{'seq_length'};
    }

    my(@geneInfoList);
    if ($start <= 0) {
    ## around the 0 bp point
        $res = &MBGD_GetAllGeneInReg($chrid, $contigid, $ChromLen + $start, $ChromLen, $options);
        push(@list, @{$res->{'INFO'}});

        $res = &MBGD_GetAllGeneInReg($chrid, $contigid, 0, $end, $options);
        push(@list, @{$res->{'INFO'}});
    } elsif ($ChromLen < $end) {
        $res = &MBGD_GetAllGeneInReg($chrid, $contigid, $start, $ChromLen, $options);
        push(@list, @{$res->{'INFO'}});

        $res = &MBGD_GetAllGeneInReg($chrid, $contigid, 0, $end - $ChromLen, $options);
        push(@list, @{$res->{'INFO'}});
    } else {
        $res = &MBGD_GetAllGeneInReg($chrid, $contigid, $start, $end, $options);
        push(@list, @{$res->{'INFO'}});
    }

    my( $rec, $gene, $seq_id, $g_start, $g_end, $prt_name );
    my( $strand );
    foreach $ent (@list) {
        $gene     = $ent->{'name'};
        $strand   = '+';
        if ($ent->{'dir'} < 0) {
            $strand   = '-';
        }
        $g_start  = $ent->{'from1'};
        $g_end    = $ent->{'to1'};
        $prt_name = $ent->{'gene'};

        if($g_start > $end) {
            $g_start -= $ChromLen + 1;
            $g_end   -= $ChromLen + 1;
        }
        elsif($g_end < $start) {
            $g_start += $ChromLen + 1;
            $g_end   += $ChromLen + 1;
        }
        if (!$ent->{'location'}) {
            $ent->{'location'} = join('..', $ent->{'from1'}, $ent->{'to1'});
            if ($ent->{'dir'} < 0) {
                $ent->{'location'} = 'complement(' . $ent->{'location'} . ')';
            }
        }
        push(@result, sprintf(join("\t", "%s", "%9d", "%9d", "%s", "%s", "%s", "%s"),
                  $strand,
                  $g_start,
                  $g_end,
                  $gene, $prt_name,
                  $ent->{'type'},
                  $ent->{'location'}));
    }

    @result;
}
sub subMBGDImg_get_genes_nochrom {
	my(@genes) = @_;
	my(@result);
	foreach my $g (@genes) {
		my($ginfo) = MBGD::Gene->get($g);
		if (! $ginfo->{location}) {
			$ginfo->{location} = "$ginfo->{from1}..$ginfo->{to1}";
			if ($ginfo->{dir} < 0) {
				$ginfo->{location} = "complement($ginfo->{location})";
			}
		}
	        push(@result, sprintf(join("\t", "%s", "%9d", "%9d", "%s", "%s", "%s", "%s"),
			$ginfo->{dir} > 0 ? '+' : '-',
			$ginfo->{from1}, $ginfo->{to1}, $ginfo->{name}, $ginfo->{gene}, $ginfo->{type}, $ginfo->{location}));
	}
	@result;
}

###############################################################################
# Region-MapΥϤ
# input : ᡼֥ȡ󥹥, ɽ륷󥹤γϡλ
#         ֡ɽΰ(rectangle x1,y1,x2,y2)
sub subMBGDImg_plot_scale {
    my( $Org, $ChrId, $ContigId, $from, $to, @ImgRegion ) = @_;
    my( $width );
    my( $unit );
    my( $start );
    my( $space_h ) = ( 2 );    # ֤Υڡ(pixel)
    my( $font_width, $font_height ) = ( gdMediumBoldFont->width,
                                           gdMediumBoldFont->height );
    my( $x0, $y0, $x1, $y1, $x2, $y2 );
    my( $diff_y );
    my( @result );
    my( $ChromLen );
    my( $strand );

    if($from < $to) {
        $width = $to - $from;
        $strand = 1;
    }
    else {
        $width = $from - $to;
        $strand = -1;
    }

    my($infoChr);
    if ($ChrId) {
        ($infoChr) = MBGD::Chromosome->find( " sp='$Org' and id='$ChrId' " );
    }
    elsif ($ContigId) {
        ($infoChr) = MBGD::Contig->find( " sp='$Org' and id='$ContigId' " );
    }
    if ($infoChr) {
	    $ChromLen = $infoChr->length;
    }

    # ñ̤
    $unit = 10 ** int(log($width) / log(10));

    if( $width / $unit <= 6 ) {
        $unit /= 2;
        if( $width / $unit <= 5 ) {
            $sub_unit = $unit / 5;
        }
        else {
            $sub_unit = $unit;
        }
    }
    else {
        $sub_unit = $unit;
    }

    if($strand < 0) {
        $sub_unit *= -1;
        $unit     *= -1;
    }

    if( $from == 0 ) {
        $from = 1;
    }
    elsif( $from < 0 ) {
        $from += $ChromLen + 1;
    }

    $from -= $ChromLen if($from > $ChromLen);
    if($strand >= 0) {
        $start = int( $from / abs($sub_unit) + 1 ) * abs($sub_unit);
    }
    else {
        $start = int( $from / abs($sub_unit) ) * abs($sub_unit);
    }

    my( $x1, $y1, $x2, $y2 ) = @ImgRegion;
    my( $img_width );
    my( $x0, $y0 );
    my( $pos );
    my( $line_len );

    $line_len = int(( $y2 - $y1 - $font_height ) / 2 );

    $img_width  =  $ImgRegion[2];
    $img_offset = 0;

    #
    my($cmdDraw);
    my($loopnum, $MAX_LOOP) = (0, 2000);

    for( $pos = $start; $x1 < $img_width; $pos += $sub_unit ) {
        if( $pos > $ChromLen ) {
            $img_offset = $img_width * ( $ChromLen - $from ) / $width;
            $from  = 0;
            $pos   = 0;
        }
        elsif( $pos < 0 ) {
            my($offset);
            $offset = $from;
            $from   = int($ChromLen / $sub_unit) * $sub_unit;
            $pos    = $from;
            $offset += $ChromLen - $from;
            $img_offset = $img_width * ( $offset ) / $width;
        }
        $x1 = $x2 = $img_width * abs($pos - $from)/ $width + $img_offset;

	last if (++$loopnum > $MAX_LOOP); #to avoid infinite loop

        next if( $x1 == 0 );

        $x0 =  $x1 - $font_width / 2;
        $x0 -= $font_width if( $pos < 0 );
        $y0 =  $y1 + $line_len + $space_h;
        $cmdDraw = sprintf( "line %d %d %d %d %s",
                                $x1, $y1,
                                $x2, $y1 + $line_len,
                                "blue" );
        push(@result, $cmdDraw);
        $cmdDraw = sprintf( "line %d %d %d %d %s",
                                $x1, $y2 - $line_len,
                                $x2, $y2,
                                "blue" );
        push(@result, $cmdDraw);
        unless( $pos % abs($unit) ) {
            $x0 = int( $x0 + 0.5 );
            $y0 = int( $y0 + 0.5 );
            $vpos = $pos;
            $vpos = 1 if( $vpos == 0 );
            $cmdDraw = "string gdMediumBoldFont $x0 $y0 \"$vpos\" black";
            push(@result, $cmdDraw);
        }
    }

    my($i, %prev_end);
    for($i = 0, $prev{'end'} = 0; $i < scalar( @result ); $i++) {
        if($result[$i] =~ /^\s*string\s+\S+\s+(\d+)\s+\d+\s\"(\d+)\"\s/) {
            if($prev{'end'} > $1) {
                $result[$prev{'index'}] = "";
            }
            $prev{'end'}   = $1 + (length("$2") + 1) * gdMediumBoldFont->width;
            $prev{'index'} = $i;
        }
    }

    @result;
}

###############################################################################
# ɽΥꥹȤꡢͥ륪֥ȤΥꥹȤ֤
# input  : Ѥ뿧Υꥹ(r,g,b(0-255)Υꥹ)
# return : 륪֥ȤΥꥹ
sub MBGDImg_MakePatternTiles {
    my(@colorList) = @_;

    my($numColor) = scalar(@colorList);
    my($tile);
    my(@temps, @tiles);
    my($i, $j);
    my($color_1, $color_2);

    for($i = 0; $i < $numColor; $i++) {
        for($j = $0; $j < $numColor; $j++) {
	    next if ($i == $j);
	    ## shaded left-top -> right-bottom
            $tile = new GD::Image(5, 5);
            $color_1 = $tile->colorAllocate(@{$colorList[$i]});
            $color_2 = $tile->colorAllocate(@{$colorList[$j]});
            $tile->filledRectangle(0, 0, 5, 5, $color_1);
            $tile->line(0, 0, 4, 4, $color_2);
#	    $temps[$i]->[$j]->[0] = $tile;
            push(@temps, $tile);

	    ## shaded right-top -> left-bottom
            $tile = new GD::Image(5, 5);
            $color_1 = $tile->colorAllocate(@{$colorList[$i]});
            $color_2 = $tile->colorAllocate(@{$colorList[$j]});
            $tile->filledRectangle(0, 0, 4, 4, $color_1);
            $tile->line(0, 2, 2, 0, $color_2);
            $tile->line(0, 3, 2, 1, $color_2);
#            $tile->line(1, 3, 3, 1, $color_2);
#	    $temps[$i]->[$j]->[1] = $tile;
            push(@temps, $tile);

	    ## cross
            $tile = new GD::Image(5, 5);
            $color_1 = $tile->colorAllocate(@{$colorList[$i]});
            $color_2 = $tile->colorAllocate(@{$colorList[$j]});
            $tile->filledRectangle(0, 0, 4, 4, $color_1);
            $tile->line(0, 0, 4, 4, $color_2);
            $tile->line(0, 4, 4, 0, $color_2);
#	    $temps[$i]->[$j]->[0] = $tile;
            push(@temps, $tile);

	    ## lattice pattern
            $tile = new GD::Image(4, 4);
            $color_1 = $tile->colorAllocate(@{$colorList[$i]});
            $color_2 = $tile->colorAllocate(@{$colorList[$j]});
            $tile->filledRectangle(0, 0, 4, 4, $color_1);
            $tile->line(2, 0, 2, 4, $color_2);
            $tile->line(0, 2, 4, 2, $color_2);
#	    $temps[$i]->[$j]->[2] = $tile;
     	    push(@temps, $tile);
	}

#            $tile = new GD::Image(4, 4);
#            $color_2 = $tile->colorAllocate(@{$colorList[$i]});
#            $color_1 = $tile->colorAllocate(@{$colorList[$j]});
#            $tile->filledRectangle(0, 0, 4, 4, $color_1);
#            $tile->line(2, 0, 2, 4, $color_2);
#            $tile->line(0, 2, 4, 2, $color_2);
#            push(@temps, $tile);
#        }
    }
    srand 1;
    my(@temp2);
    for ($i = 0; $i < @temps; $i++) {
	    push(@temp2, rand);
    }
    @temps = @temps[ sort {$temp2[$a]<=>$temp2[$b]} (0..$#temp2) ];
    return @temps;

##    my($numPattern) = (3);
##    my($k);
###    my(@offset);
###    for($i = $numColor - 1, $j = 0; $i > 0; $i--) {
###        push(@offset, $j);
###        $j += $i * $numPattern;
###    }
##
##    for($i = 0; $i < $numColor; $i++) {
##        for($j = 0; $j < $numPattern; $j++) {
###            for($k = 0; $k < $numColor -1 - $i; $k++) {
##            for($k = 0; $k < $numColor-1; $k++) {
##$ii = ($i+$k) % $numColor;
##print STDERR "ii>$ii\n";
##
##
##print STDERR "ERR Tile $i,$j,$k,$ii=>$temps[$k]->[$ii]->[$j]\n" if (! $temps[$k]->[$ii]->[$j]);
##            push(@tiles, $temps[$k]->[$ii]->[$j]);
###                 $temps[$i * $numPattern + $offset[$k] + ($j + $k) % $numPattern]);
##            }
##        }
##    }
##
##    return(@tiles);
}

###############################################################################
# ɽΥꥹȤꡢñ쿧륪֥ȤΥꥹȤ֤
# input  : Ѥ뿧Υꥹ(r,g,b(0-255)Υꥹ)
# return : 륪֥ȤΥꥹ
sub MBGDImg_MakeMonoColorTiles {
    my(@colorList) = @_;

    my($numColor) = scalar(@colorList);
    my($tile);
    my(@tiles);
    my($i);
    my($color_1);

    for($i = 0; $i < $numColor; $i++) {
        $tile = new GD::Image(5, 5);
        $color_1 = $tile->colorAllocate(@{$colorList[$i]});
        $tile->filledRectangle(0, 0, 5, 5, $color_1);
        
        push(@tiles, $tile);
    }

    return(@tiles);
}

##############################################################################
1;
##############################################################################
