#!/usr/bin/perl -s
use strict;
use FileHandle;

###############################################################################
#
sub upd_MBGD_commonPath {
    my($file) = shift;

    #
    my($file_bak) = "$file.bak";
    rename("$file", "$file_bak");

    #
    my($fhr) = FileHandle->new("$file_bak");
    my($fhw) = FileHandle->new(">$file");
    while(my$line = $fhr->getline()) {
        if ($line =~ /^1\;/) {
            $fhw->print('require "MBGD_commonDefs.pl";', "\n");
        }
        $fhw->print($line);
    }
    $fhw->close();
    $fhr->close();

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($file) = "$ENV{'RECOG_HOME'}/perllib/MBGD_commonPath.pl";
    if (! -e $file) {
        print STDERR "ERROR :: Can not found $file\n";
        exit(-1);
    }

    upd_MBGD_commonPath($file);
}
