#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;
use RECOG;

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -dbname=DBNAME -tabid=TABID -spec=SPEC -cmd=CMD fileDomClustResults\n";
}

###############################################################################
#
sub writeDomClustRes {
    my($filename) = shift;
    my($refDomClust) = shift;

    my($fh) = new FileHandle(">$filename") || return 0;
    foreach my$refClust (@{$refDomClust->{'CLUST'}}) {
        # clustid, subclustid, sp, name, spname, dom, from1, to1
        my($clusterNo) = $refClust->{'ID'};
        my($hom_clusterNo) = $refClust->{'HOM_CLUSTER'};
        foreach my$subClusterNo (sort(keys(%{$refClust->{'CLUST_RES'}}))) {
            foreach my$ent (@{$refClust->{'CLUST_RES'}->{"$subClusterNo"}}) {
                $fh->print(join("\t", $hom_clusterNo,
                                      $clusterNo,
                                      $subClusterNo,
                                      $ent->{'sp'},
                                      $ent->{'name'},
                                      $ent->{'spname'},
                                      $ent->{'dom'},
                                      $ent->{'from1'},
                                      $ent->{'to1'},
                                      $ent->{'outer_flag'},
		), "\n");
            }
        }
    }
    $fh->close();

    return 1;
}

###############################################################################
#
sub createTablesAndLoad {
    my($db) = shift;
    my($refDomClust) = shift;
    my($sql);

    #
    my($tabID) = $refDomClust->{'ID'};
    my($spec) = $refDomClust->{'SPEC'};
    my($cmd) = $refDomClust->{'CMD'};

    #
    my($fileTmp) = "$main::DOMCLUST_TMP_DIR/tmp_clust_$$.txt";
    writeDomClustRes($fileTmp, $refDomClust);

    #
    $sql = "drop table if exists cluster_$tabID";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "create table cluster_$tabID ("     # cluster_domclust_cache_
         . "homclustid  int default null,"
         . "clustid     int,"
         . "subclustid  int,"
         . "sp          char($main::SIZE_SP) not null,"
         . "name        char($main::SIZE_NAME ) not null,"
         . "spname      char($main::SIZE_SPNAME) not null,"
         . "dom         smallint not null,"
         . "from1       int,"
         . "to1         int,"
         . "outer_flag  int,"
         . "primary key (spname, dom, clustid),"
         . "key (sp, name, dom))";
#         . "primary key (spname, dom),"
#         . "unique key (sp, name, dom))";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "load data local infile '$fileTmp' REPLACE into table cluster_$tabID";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "create index clust_id_idx_$tabID on cluster_$tabID (clustid)";
    print STDERR "SQL :: $sql\n";
    $db->execute($sql);

    #
    $sql = "create index clust2_id_idx_$tabID on cluster_$tabID (clustid,subclustid)";
    print STDERR "SQL :: $sql\n";
    $db->execute($sql);

    #
#    unlink($fileTmp);

    return;
}

###############################################################################
#
sub parseResDomClust {
    my($filename) = shift;

    #
    my($refDomClust) = {};
    $refDomClust->{'CLUST'} = [];
    my($refClust);
    my($subClusterNo, $outer_flag);

    #
    my($fh) = new FileHandle("$filename") || return 0;
    my($line);
    my($hom_cluster) = '';
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /^HomCluster\s+(\d+)$/i) {
            $hom_cluster = $1;
        }
        elsif ($line =~ /^cluster\s+(\d+)$/i) {
            $refClust = {};
            $refClust->{'ID'} = $1;
            $refClust->{'HOM_CLUSTER'} = $hom_cluster;
            $subClusterNo = 1;
            push(@{$refDomClust->{'CLUST'}}, $refClust);
	    $outer_flag = 0;
        }
        elsif ($line =~ /^SubCluster\s+(\d+)$/i) {
            $subClusterNo = $1;
            $refClust->{'CLUST_RES'}->{"$subClusterNo"} = [];
        }
        elsif ($line =~ /^OutGroup/i) {
            $subClusterNo = 0;
	    if (!  $refClust->{'CLUST_RES'}->{"$subClusterNo"}) {
            	$refClust->{'CLUST_RES'}->{"$subClusterNo"} = [];
	    }
	    $outer_flag = 0;
        }
        elsif ($line =~ /^OuterGroup/i) {
            $subClusterNo = 0;
	    if (!  $refClust->{'CLUST_RES'}->{"$subClusterNo"}) {
	        $refClust->{'CLUST_RES'}->{"$subClusterNo"} = [];
	    }
	    $outer_flag = 1;
	}
        elsif ($line =~ /^([^\:]+)\:(\S+)\s+(\d+)\s+(\d+)$/) {
            my($sp) = $1;
            my($name) = $2;
            my($from1) = $3;
            my($to1) = $4;

            #
            my($dom) = 0;
            if ($name =~ /([^\(]+)\((\d+)\)/) {
                $name = $1;
                $dom =  $2;
            }
            my($spname) = "$sp:$name";

            #
            my($ent) = {};
            $ent->{'sp'}     = $sp;
            $ent->{'name'}   = $name;
            $ent->{'spname'} = $spname;
            $ent->{'dom'}    = $dom;
            $ent->{'from1'}  = $from1;
            $ent->{'to1'}    = $to1;
            $ent->{'outer_flag'}  = $outer_flag;
            push(@{$refClust->{'CLUST_RES'}->{"$subClusterNo"}}, $ent);
        }
    }
    $fh->close();

    return $refDomClust;
}



###############################################################################
if ($0 eq __FILE__) {

    if (!$main::dbname || !$main::tabid || !$main::spec || !$main::cmd) {
        printUsage();
        exit(0);
    }

    my($file) = shift(@ARGV);
    if (! -e $file) {
        printUsage();
        exit(0);
    }

    my($refDomClust) = parseResDomClust($file);
    $refDomClust->{'ID'}   = $main::tabid;
    $refDomClust->{'SPEC'} = $main::spec;
    $refDomClust->{'CMD'}  = $main::cmd;

    my($db) = new MBGD::DB($main::dbname);
    createTablesAndLoad($db, $refDomClust);
}

###############################################################################
1;#
###############################################################################
