#!/usr/bin/perl -s
use strict;
use Getopt::Long;
use FileHandle;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -TABID=table_id [-DBNAME=db_name] file_domclust_tree\n";

    return;
}

###############################################################################
#
sub get_table_name {
    my($table_id) = shift;

    my($table_name) = 'clustdump_' . $table_id;

    return $table_name;
}

###############################################################################
#
sub select_domclust_dump {
    my($db) = shift;
    my($table_id) = shift;
    my($filename) = shift;

    # progress
    my($maxThisPhase) = 50;

    #
    my($fh) = FileHandle->new(">$filename") || die("Can not open $filename($!)");

    #
    my($tab) = get_table_name($table_id);
    if (!$db->exist_table($tab)) {
        exit(-1);
    }

    #
    my($opt) = {};
    $opt->{'order'} = "line_no";
    my($refRes) = $db->select_fetch($tab, $opt);
    my($total) = $refRes->{'ROWS'};
    my($i) = 0;
    foreach my$ref (@{$refRes->{'INFO'}}) {
        $fh->print($ref->{'dump'}, "\n");
        if ($i % 10000 == 0) {
            print STDERR join("\t", 'Retrieving', int($i / $total * $maxThisPhase), $i) . "\n";
        }
        $i++;
    }
    print STDERR join("\t", 'Retrieving', $maxThisPhase) . "\n";

    $fh->close();

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($db_name) = $main::DBNAME_MBGD;
    if (defined($main::DBNAME)) {
        $db_name = $main::DBNAME;
    }
    if (!defined($main::TABID)) {
        printUsage();
        exit(-1);
    }
    if (!defined($main::FILE)) {
        printUsage();
        exit(-1);
    }

    my($db) = MBGD::DB->new($db_name);

    select_domclust_dump($db, $main::TABID, $main::FILE);

    exit(0);
}

1;#
