#!/usr/bin/perl -s
use strict;
use Getopt::Long;
use IO::File;
use RECOG::DomClustCommon;

###############################################################################
#
sub printCluster {
    my($cluster_ref) = shift;
    my($sub_cluster_type_ref) = { 'I' => 'SubCluster',
                                  'O' => 'OutGroup',
                                  'OO' => 'OuterGroup',
                                  'o' => undef,  ## ignored outgroup
                                };

    #
    if ($cluster_ref->{'HOM_CLUSTER'}) {
        my($homclust_id) = $cluster_ref->{'HOM_CLUSTER'};
        print 'HomCluster ', $homclust_id;
        print "\n";
    }

    #
    my($clust_id) = $cluster_ref->{'CLUSTER_ID'};
    print 'Cluster ', $clust_id;
    print "\n";

    #
    foreach my$io (sort {$a cmp $b} keys(%{$cluster_ref->{'SUB_CLUSTER'}})) {
	next if (! $sub_cluster_type_ref->{$io});
        my($sub_cluster_io_ref) = $cluster_ref->{'SUB_CLUSTER'}->{"$io"};
        foreach my$sub_cluster_id (sort { $a <=> $b } keys(%{$sub_cluster_io_ref})) {
            print join(q{ }, $sub_cluster_type_ref->{"$io"}, $sub_cluster_id), "\n";

            #
            my($sub_cluster_ref) = $sub_cluster_io_ref->{"$sub_cluster_id"};
            foreach my$ent_ref (@{$sub_cluster_ref}) {
                print join(q{ }, $ent_ref->{'NAME'},
                                 $ent_ref->{'FROM1'},
                                 $ent_ref->{'TO1'}), "\n";
            }
            print "\n";
        }
    }

    return;
}

###############################################################################
#
sub parse_domclust_out {
    my($filename) = shift;
    my($clust_id);
    my($cluster_ref);

    #
    my($fh) = IO::File->new($filename, "r") || die("Can not open $filename($!)");
    my($hom_cluster) = '';
    while(my$line=$fh->getline()) {
        $line =~ s/[\r\n]*$//;

        if ($line =~ /HomCluster\s+(\d+)/) {
            $hom_cluster = $1;
        }
        elsif ($line =~ /Cluster\s+(\d+)/) {
            $clust_id = $1;
            if (defined($cluster_ref)) {
                printCluster($cluster_ref);
            }

            $cluster_ref = {};
            $cluster_ref->{'HOM_CLUSTER'} = $hom_cluster;
            $cluster_ref->{'CLUSTER_ID'}  = $clust_id;
            $cluster_ref->{'SUB_CLUSTER'} = {};
            $cluster_ref->{'SUB_CLUSTER'}->{'I'} = {};
            $cluster_ref->{'SUB_CLUSTER'}->{'O'} = {};
        }
        elsif ($line =~ /\-\s+(\w\S+)\s+(\d+)\s+(\d+)\s*\[?([IOo]*)(\d*)\]?/) {
            my($ent_ref) = {};
            my($name)         = $ent_ref->{'NAME'}         = $1;
            my($from1)        = $ent_ref->{'FROM1'}        = $2;
            my($to1)          = $ent_ref->{'TO1'}          = $3;
            my($io)           = $ent_ref->{'IO'}           = $4 || 'I';
            my($sub_clust_id) = $ent_ref->{'SUB_CLUST_ID'} = $5 || 1;
#print STDERR "READ  :: $line\n";
#print STDERR "PARSE :: ", join('::', $name, $from1, $to1, $io, $sub_clust_id), "\n";
            if (!exists($cluster_ref->{'SUB_CLUSTER'}->{"$io"}->{"$sub_clust_id"})) {
                $cluster_ref->{'SUB_CLUSTER'}->{"$io"}->{"$sub_clust_id"} = [];
            }
            push(@{$cluster_ref->{'SUB_CLUSTER'}->{"$io"}->{"$sub_clust_id"}}, $ent_ref);
	}
#        elsif ($line =~ /^#\s*Additional outgroup:\s*(\S+)\s+(\d+)\s+(\d+)/) {
#	    my($name, $from, $to) = ($1, $2, $3);
#	    my($ent_ref) = {NAME=>$name, FROM1=>$from, TO1=>$to};
#            push(@{$cluster_ref->{'SUB_CLUSTER'}->{"O"}->{"1"}}, $ent_ref);
#	}
        else {
        }

    }
    $fh->close();

    if (defined($cluster_ref)) {
        printCluster($cluster_ref);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    foreach my$file (@ARGV) {
        parse_domclust_out($file);
    }
}

1;#
