#!/usr/bin/perl -s

use MBGD;
use MBGD::FunctionCategory;
require 'libMBGDDBM.pl';
require 'MBGD_Conf.pl';
require "MBGD_common.pl";
require 'libMBGDaxes.pl';

$SPEC = shift if (! $SPEC);
@SPEC = split(/,/, $SPEC);

if ($Hit) {
	foreach $h0 ( split(/,/, $Hit) ) {
		next if ($Hit0{$h0});
		push(@Hit0, $h0);
		$Hit0{$h0} = 1;
	}
}

$DEFAULTOP = 'AND' if (! $DEFAULTOP);

$OP{'AND'} = '&&';
$OP{'OR'} = '||';
$OP{'NOT'} = '!';
@VARNAMES = ('GENE', 'ORF', 'PRODUCT', 'AASEQ', 'CATEGORY', 'PROSITE');
foreach $var (@VARNAMES) {
	$VAR{"$var="} = "\$$var=~";
}


while ($Qstring = shift @ARGV) {

	if ($Qstring =~ /^AASEQ/) {
		*Query = *PatQuery;
	} elsif ($Qstring =~ /FUNCTION_CATEGORY/) {
		*Query = *FuncCatQuery;
	} elsif ($Qstring =~ /CATEGORY/) {
		*Query = *CatQuery;
	} elsif ($Qstring =~ /PROSITE/) {
		*Query = *ProsQuery;
	} else {
		*Query = *TitQuery;
	}

	
	$Qstring =~ s/#/\"/g;
	
	$Qstring =~ s/\//\\\//g;
	push(@String, ($Qstring =~ /\"([^\"]*)\"/g));
	$Qstring =~ s/\"([^\"]*)\"/STRING/g;
	
	$Qstring =~ s/([\(\)])/ \1 /g;
	
	foreach $var (@VARNAMES) {
		$Qstring =~ s/$var[ ]*=/$var= /g;
	}
	
	### print "$Qstring\n";
	
	$STATUS = 'string';
	
	foreach $a (split(/\s+/, $Qstring)) {
		next if ($a =~ /^$/);
		if ($a eq 'STRING') {
			&status_check('STRING');
			$a = shift @String;
			$Query .= " /$a/i ";
		} elsif ($a eq '(') {
			&status_check('BEGIN');
			$Query .= " $a ";
		} elsif ($a eq ')') {
			&status_check('END');
			$Query .= " $a ";
		} elsif ($OP{$a}) {
			&status_check('OP');
			$Query .= " $OP{$a} ";
		} elsif ($VAR{$a}) {
			&status_check('VAR');
			$Query .= " $VAR{$a} ";
		} else {
			&status_check('STRING');
			$Query .= " /$a/i ";
		}
	}
}
if (! $Query && $Hit) {
	foreach $h (@Hit0) {
		print &get_title0($h);
		next if ($Hit0{$h});
	}
	exit 0;
}

foreach $sp (@SPEC) {
    my($filename);
	$fn = 0;
	if ($PatQuery) {
		$filename = "$DIR_database/bldb/$sp";
		$Hit[$fn++] = &search_seq("$filename", $PatQuery);
	}
	if ($CatQuery) {
        $filename = "$DIR_database/class/$sp.cl";
		$Hit[$fn++] = &search_category("$filename", $CatQuery);
	}
	if ($FuncCatQuery) {
		$Hit[$fn++] = &search_function_category($FuncCatQuery);
	}
	if ($ProsQuery) {
        my($filename2);
		$filename  = "$DIR_database/motif/prosite.tit";
        $filename2 = "$DIR_database/motif/$sp.pr";
		$Hit[$fn++] = &search_prosite("$filename", "$filename2", $ProsQuery);
	}
	if ($TitQuery) {
		$filename = "$DIR_database/sptit/sptit.$sp";
		$Hit[$fn++] = &search_title("$filename", $TitQuery);
	}

	## $Hit points to an array
	$HitA = shift @Hit;
	undef $HitR;
	while ($Hit1 = shift @Hit) {
	        $HitR = &AndOr('', $HitA, 'OR');
       		$HitR = &AndOr($HitR, $Hit1, 'AND');
	}
	if ($HitR) {
		@{$HitA} = keys (%{$HitR});
	}

	$HitR = &AndOr(\%Hit0, $HitA, $OP);

        foreach $h (keys %{$HitR}) {
                print &get_title0($h);
        }

}
exit 0;

###############################################################################
#
sub search_seq {
	local($file, $PatQuery) = @_;
	local(@Hit);

	open(TIT, $file) || die "$0: Can't open $file\n";
eval q[
	while (<TIT>) {
		chop;
		if (/^>[ ]*([^ ]+)/) {
			if ($AASEQ) {
				if ( ] . $PatQuery . q[ ) {
					push(@Hit, "$sp:$name");
				}
			}
			$name = $1;
			$AASEQ = '';
		} else {
			$AASEQ .= $_;
			$AASEQ =~ s/\s//g;
		}
	}
	if ( ] . $PatQuery . q[ ) {
		push(@Hit, "$sp:$name");
	}
];
	\@Hit;
}
sub get_title0 {
	my($name) = @_;
	my $g = MBGD::Gene->get($name);
	"$name\t$g->{gene}\t$g->{descr}\n";
}

###############################################################################
# sptit ե뤫ǤϤʤ DB ǡ򸡺
sub search_title {
	local($file, $Query) = @_;
	local(@Hit);
    my($sp);
    my($res);

    #
    ($sp) = ($file =~ /sptit\.(\S+)$/);

    #
    $res = &main::MBGD_GetAllGeneInfo($MYSQL_DB, $sp);
eval q[
    foreach $info (@{$res->{'INFO'}}) {
        $_ = join("\t", $info->{'sporf'}, $info->{'gene'}, $info->{'descr'});
        $ORF     = $info->{'sporf'};
        $GENE    = $GENE . " " . $info->{'gene'};
        $PRODUCT = $info->{'descr'};
		if ( ] . $Query . q[) {
			push(@Hit, $ORF);
		}
    }
];

=cut

    #
	open(TIT, $file) || die "$0: Can't oepn $file\n";
eval q[
	while (<TIT>) {
		($ORF, $GENE, @PRODUCT) = split;
		$GENE =~ s/[\\[\\]]//g;
		$GENE = "$ORF $GENE";
		$PRODUCT = join(' ', @PRODUCT);
		if ( ] . $Query . q[) {
			push(@Hit, $ORF);
		}
	}
];
	close(TIT);
=cut

	\@Hit;
}

###############################################################################
#
sub search_category {
	local($file, $CatQuery) = @_;
	local($CatID, %CatHit, @Hit);
	open(TIT, $file) || die "$0: Can't oepn $file\n";

	if ($CatQuery =~ /=~ *\/\^{0,1}([0-9\.]+)\//) {
		$keyid = $1;
		$CatQuery = "\$CatID =~ /^${keyid}\\./ || \$CatID eq '${keyid}'";
	}
eval q[
	while (<TIT>) {
		($CatID) = split;
		$CATEGORY = $_;
		if ( ] . $CatQuery . q[) {
			$CatHit{$CatID} = 1;
		}
	}
];
	close(TIT);
	open(TIT, "${file}ass") || die "$0: Can't oepn $file\n";
	while (<TIT>) {
		($CatID, $ORF) = split;
		push(@Hit, "$sp:$ORF") if ($CatHit{$CatID});
		
	}
	close(TIT);
	\@Hit;
}

###############################################################################
#
sub search_function_category {
    my($CatQuery) = shift;

    my($fdb, $lev) = ($CatQuery =~ m#/([a-z]+)\:([0-9\.]+)/#i);
    my($objFuncCat) = new MBGD::FunctionCategory(lc($fdb));
    $objFuncCat->setOrig(1);

    my($opt) = {};
    $opt->{'LIKE'} = 1;
    my($refHit) = $objFuncCat->getOrfListByLevel($sp, $lev, $opt);

    return $refHit;
}

###############################################################################
#
sub search_prosite {
	local($prostit, $file, $ProsQuery) = @_;
	local($ProsID, %ProsHit, @Hit);
	local($sp,$orf);
	open(TIT, $prostit) || die "$0: Can't oepn $file\n";

eval q[
	while (<TIT>) {
		($ProsID) = split;
		$PROSITE = $_;
		if ( ] . $ProsQuery . q[) {
			$ProsHit{$ProsID} = 1;
		}
	}
];
	close(TIT);
	open(TIT, "$file") || die "$0: Can't oepn $file\n";
	while (<TIT>) {
		($sp,$orf,$from,$to,$prosname,$ProsID) = split(/:/);
		push(@Hit, "$sp:$orf") if ($ProsHit{$ProsID});
		
	}
	close(TIT);
	\@Hit;
}

###############################################################################
#
sub Parse_Query {
	local(@query) = @_;
	local($status);
	foreach $q (@query) {
		if ($q eq 'AND' || $q eq '&') {
			$status = 'and';
			$EV .= "&&";
		} elsif ($q eq 'OR' || $q eq '|') {
			$status = 'or';
			$EV .= "||";
		} else {
			$EV .= '&&' if ($EV && $status eq 'word');
			if ($q eq '(' || $q eq ')') {
				$status = 'pare';
				$EV .= $q;
			} else {
				$EV .= "/$q/ ";
				$status = 'word';
			}
		}
	}
	print "$EV\n";
}

###############################################################################
#
sub status_check {
	local($status) = @_;
	if ($status eq 'STRING') {
		if ($STATUS eq 'STRING' || $STATUS eq 'END') {
			$Query .= " $OP{$DEFAULTOP} ";
		}
	} elsif ($status eq 'OP') {
		if ($STATUS eq 'BEGIN') {
			die "Syntax error $STATUS->$status\n";
		}
	} elsif ($status eq 'START') {
		if ($STATUS eq 'STRING' || $STATUS eq 'END') {
			$Query .= " $OP{$DEFAULTOP} ";
		}
	} elsif ($status eq 'END') {
		if ($STATUS eq 'OP' || $STATUS eq 'VAR') {
			die "Syntax error $STATUS->$status\n";
		}
	} elsif ($status eq 'VAR') {
		if ($STATUS eq 'STRING' || $STATUS eq 'END') {
			$Query .= " $OP{$DEFAULTOP} ";
		}
	}
	$STATUS = $status;
}

###############################################################################
#   $Orig : ϥåΥե
#   $Add  : Υե
#   #OP   : And-Or 
#
sub AndOr {
    local($Orig, $Add, $OP) = @_;
    local(%Out, @Orig_ar);
    local($h,$sp,$orf);

    if ($OP eq 'OR' && $Orig) {
        @Orig_ar =  keys %{$Orig};
    }

    foreach $h (@{$Add}, @Orig_ar) {
        ($sp,$orf) = split(/:/,$h);$orf=~tr/a-z/A-Z/;$h="$sp:$orf";
        next if ($Out{$h});
        next if (($OP eq 'AND') && (! $Orig->{$h}));
# print STDERR &get_title($h);
        $Out{$h} = 1;
    }
    \%Out;
}

###############################################################################
# MBGD_GetAllGeneInfo : MBGD ϿƤ ORF/Gene name Ф븡
#     DBMS ǤϡǡιʤߤϹԤʤ
#     ץ¦ǡPerl  eval ȤȤˤʹʤߤǽȤ
sub 'MBGD_GetAllGeneInfo {
    my($dbname, @specList) = @_;
    my($refRes);
    my($genename);

    # оݤʪ
    my($sp);
    my($spList);
    foreach $sp (@specList) {
        $sp = "'$sp'";
    }
    $spList = join(',', @specList);

    # ̳Ǽΰ
    $refRes = {};
    $refRes->{'MAXROWS'} = 0;
    $refRes->{'ROWS'}    = 0;
    $refRes->{'INFO'}    = {};

    # MySQL  DB Ȥä
    my($db);
    my($sth);

    # DB ³
    $db = MBGD::DB->new($dbname);

    # 
    my($colms, $tables, $whereCond, $orderCond, $limitCond);
    $colms      = "concat(sp, ':', name), gene, descr";
    $tables     = "gene";
    $whereCond  = "sp in ($spList)";
    $orderCond  = "sp, name";
    $limitCond  = "";

    # ǡ
    my($sql);
    $sql = "select $colms from $tables";
    $sql = "$sql where $whereCond"    if ($whereCond ne '');
    $sql = "$sql order by $orderCond" if ($orderCond ne '');
    $sql = "$sql limit $limitCond"    if ($limitCond ne '');

    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # ̼
    my($rows);
    my($i);
    my($sporf, $gene, $descr);
    $rows = $sth->rows;
    $refRes->{'MAXROWS'} = $rows;
    $refRes->{'ROWS'} = $rows;
    $refRes->{'INFO'} = [];
    for($i = 0; $i < $rows; $i++) {
        ($sporf, $gene, $descr) = $sth->fetchrow_array;

        my($info) = {};
        $info->{'sporf'} = $sporf;
        $info->{'gene'}  = $gene;
        $info->{'descr'} = $descr;
        push(@{$refRes->{'INFO'}}, $info);
    }

    # λ
    $sth->finish;

    return $refRes;
}

1;
