#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -dbname=DBNAME -tabid=TABID -spec=SPEC -cmd=CMD fileDomClustResults\n";
}

###############################################################################
#
sub writeDomClustRes {
    my($filename) = shift;
    my($refDomClust) = shift;

    my($fh) = new FileHandle(">$filename") || return 0;
    foreach my$refClust (@{$refDomClust->{'CLUST'}}) {
        # clustid, subclustid, sp, name, spname, dom, from1, to1
        my($clusterNo) = $refClust->{'ID'};
        foreach my$subClusterNo (sort(keys(%{$refClust->{'CLUST_RES'}}))) {
            foreach my$ent (@{$refClust->{'CLUST_RES'}->{"$subClusterNo"}}) {
                $fh->print(join("\t", $clusterNo,
                                      $subClusterNo,
                                      $ent->{'sp'},
                                      $ent->{'name'},
                                      $ent->{'spname'},
                                      $ent->{'dom'},
                                      $ent->{'from1'},
                                      $ent->{'to1'}), "\n");
            }
        }
    }
    $fh->close();

    return 1;
}

###############################################################################
#
sub createTablesAndLoad {
    my($db) = shift;
    my($refDomClust) = shift;
    my($sql);

    #
    my($tabID) = $refDomClust->{'ID'};
    my($spec) = $refDomClust->{'SPEC'};
    my($cmd) = $refDomClust->{'CMD'};

    #
    my($fileTmp) = "$ENV{'MBGD_HOME'}/work/tmp_clust_$$.txt";
    writeDomClustRes($fileTmp, $refDomClust);

    #
	$sql = "create table if not exists cluster_tables
			(spec text, cmd text,
			tabid char(12) not null,
			cdate timestamp,
			primary key(tabid))";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "replace into cluster_tables 
			(spec, cmd, tabid, cdate)
			values
			('$spec', '$cmd', '$tabID', null)";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "drop table if exists cluster_$tabID";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "create table cluster_$tabID (
			clustid int,
			subclustid int,
			sp char($main::SIZE_SP) not null,
			name char($main::SIZE_NAME) not null,
			spname char($main::SIZE_SPNAME) not null,
			dom smallint not null,
			from1 int,
			to1 int,
			primary key (spname, dom),
			unique key (sp, name, dom))";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "load data local infile '$fileTmp' REPLACE into table cluster_$tabID";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "create index clust_id_idx_$tabID on cluster_$tabID (clustid)";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    $sql = "create index clust2_id_idx_$tabID on cluster_$tabID (clustid,subclustid)";
	print STDERR "SQL :: $sql\n";
	$db->execute($sql);

    #
    unlink($fileTmp);

    return;
}

###############################################################################
#
sub parseResDomClust {
    my($filename) = shift;

    #
    my($refDomClust) = {};
    $refDomClust->{'CLUST'} = [];
    my($refClust);
    my($subClusterNo);

    #
    my($fh) = new FileHandle("$filename") || return 0;
    my($line);
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /^cluster\s+(\d+)$/i) {
            $refClust = {};
            $refClust->{'ID'} = $1;
            $subClusterNo = 1;
            push(@{$refDomClust->{'CLUST'}}, $refClust);
        }
        elsif ($line =~ /^SubCluster\s+(\d+)$/i) {
            $subClusterNo = $1;
            $refClust->{'CLUST_RES'}->{"$subClusterNo"} = [];
        }
        elsif ($line =~ /^OutGroup$/i) {
            $subClusterNo = 0;
            $refClust->{'CLUST_RES'}->{"$subClusterNo"} = [];
        }
        elsif ($line =~ /^([^\:]+)\:(\S+)\s+(\d+)\s+(\d+)$/) {
            my($sp) = $1;
            my($name) = $2;
            my($from1) = $3;
            my($to1) = $4;

            #
            my($dom) = 1;
            if ($name =~ /([^\(]+)\((\d+)\)/) {
                $name = $1;
                $dom =  $2;
            }
            my($spname) = "$sp:$name";

            #
            my($ent) = {};
            $ent->{'sp'}     = $sp;
            $ent->{'name'}   = $name;
            $ent->{'spname'} = $spname;
            $ent->{'dom'}    = $dom;
            $ent->{'from1'}  = $from1;
            $ent->{'to1'}    = $to1;
            push(@{$refClust->{'CLUST_RES'}->{"$subClusterNo"}}, $ent);
        }
    }
    $fh->close();

    return $refDomClust;
}



###############################################################################
if ($0 eq __FILE__) {

    if (!$main::dbname || !$main::tabid || !$main::spec || !$main::cmd) {
        printUsage();
        exit(0);
    }

    my($file) = shift(@ARGV);
    if (! -e $file) {
        printUsage();
        exit(0);
    }

    my($refDomClust) = parseResDomClust($file);
    $refDomClust->{'ID'}   = $main::tabid;
    $refDomClust->{'SPEC'} = $main::spec;
    $refDomClust->{'CMD'}  = $main::cmd;

    my($db) = new MBGD::DB($main::dbname);
    createTablesAndLoad($db, $refDomClust);
}

###############################################################################
1;#
###############################################################################
