#!/usr/bin/perl -s

use MBGD;
use MBGD::WWW;
require "MBGD_common.pl";

$www = MBGD::WWW->new;

$WWWROOT = $ENV{'WWWROOT'};

$| = 1;

$dpres = "$DIR_mbgdhome/bldp/blastdpres";

$tmpfile = "$DIR_tmp/clusttmp.$$";
if ($main::DIR) {
    $dpres = $main::DIR;
}

if (@ARGV == 0) {
    while (<STDIN>) {
        chop;
        $ent = $_;
        $ENT{$ent} = 1;
        ($sp,$id) = split(/:/,$ent);
        $FND{$sp} = 1;
        push(@{$SPENT{$sp}}, $id);
    }
}
else {
    foreach $ent (@ARGV) {
        $ENT{$ent} = 1;
        ($sp,$id) = split(/:/,$ent);
        $FND{$sp} = 1;
        push(@{$SPENT{$sp}}, $id);
    }
}

$selcmd = "$CMD_select -SPEC=" . join(',', keys %FND) . " -GENES=" . join(',',keys %ENT) . " -GetParam=$paramfile -paracheck -FILTER -tabout";
if ($ENV{'MYSQL_DB'}) {
    $selcmd .= " -dbname=$ENV{'MYSQL_DB'}";
}

# domclust ¹
$cmd = "$selcmd | $CMD_tee $tmpfile | $CMD_domclust stdin $OPT";
print STDERR "$cmd\n";
print STDERR ">Start\n";
system("$cmd");
print STDERR "OK\n";

$flag = 0;
if ($SHOW_ALLDIST) {
    print "###############\n";
    open(TMP, $tmpfile) || die "Can't open $tmpfile\n";
    while (<TMP>) {
	if (/^\/\//) {
		$flag = 1;
	}
	if ($flag) {
		print;
	}
    }
}

unlink($tmpfile);

