#!/usr/bin/perl -s
#

use MBGD;
use MBGD::WWW;
use MBGD::Contig;
use MBGD::FuncCat;
use DBXref;
use MBGD::FunctionCategory;

require "MBGD_Conf.pl";

require "libMBGDaxes.pl";
require "emergency.pl";

#require "libMBGDFuncCat.pl";
#require "libMBGDUserInfo.pl";
#use CGI;
#require "MBGD_common.pl";

$| = 1;

$WWW = MBGD::WWW->new;

###############################################################################
%Args = $WWW->cgiGetArgs;
if (! $Args{$spec} && $Args{"name"} =~ /:/) {
	($Organism, $GeneName) = split(/:/, $Args{"name"});
} else {
	$Organism = $Args{"spec"};
	$GeneName = $Args{"name"};
}

$tabid = $WWW->uInfo->currentTableID;
if (!$Args{'tabid'}) {
	$Args{'tabid'} = $tabid;
} elsif (! $tabid) {
	$WWW->uInfo->saveTableIDs($tabid);
}

# Хѿ
$Path_htbin       = $MBGD_PATH_HTBIN;

#
$db = MBGD::DB->new($ENV{'MYSQL_DB'});

if ( (!$Organism || ! $GeneName) && $Args{'protid'}) {
	$ProtID = $Args{'protid'};
	if ($ProtID !~ /\.\d+/) {
		## no version 
		$query = "protid like '$ProtID.%'";
	} else {
		$query = "protid='$ProtID'";
	}
	($geneInfo) = MBGD::Gene->find($db, $query);
	if (! $geneInfo) {
		my($opt);
		$opt = {'tablename' => 'gene'};
		($geneInfo) = MBGD::Gene->find($db, "protid='$ProtID'", $opt);
	}
	$Organism = $geneInfo->{'sp'};
	$GeneName = $geneInfo->{'name'};
}

# get genome info
($genomeInfo) = MBGD::Genome->get($db, ["$Organism"]);

$WWW->setOptions(title=>"Gene Information [$Organism:$GeneName]");

# get gene info
($geneInfo) = MBGD::Gene->get($db, ["$Organism:$GeneName"]);
if (! $geneInfo) {
	my($opt);
	$opt = {'tablename' => 'gene'};
	($geneInfo) = MBGD::Gene->get($db, ["$Organism:$GeneName"], $opt);
}

# get chromosome info
if ($geneInfo->{'chrid'}) {
    ($chrInfo) = MBGD::Chromosome->fetch($geneInfo->{'chrid'});
}
elsif ($geneInfo->{'contigid'}) {
    ($chrInfo) = MBGD::Contig->fetch($geneInfo->{'contigid'});
}

$GI = $geneInfo->{'gi'}; $GI =~ s/GI://;
$ProtID = $geneInfo->{'protid'};
@prot_acc = DBXref::NCBI_Gene::gene2acc($geneInfo->{'geneid'});
foreach $acc (@prot_acc) {
	if ($acc =~ /^[PQ]\d+/) {
		$UniProtID = $acc;
		$UniProtID =~ s/\.[0-9]+//;
	} elsif ($acc =~ /^[NXZAY]P_/) {
		$RefSeqProtID = $acc;
	} else {
		$InsdProtID = $acc;
	}
}
($UniProtID) = DBXref::UniProt::embl2uniprot($InsdProtID) if (! $UniProtID);
if ($UniProtID) {
	$UniProtGetURL = "uniprot/${UniProtID}";
} elsif ($InsdProtID) {
	$UniProtGetURL = "cgi-bin/get-entries?DR=${InsdProtID}";
}


$WWW->start_html('-style' => {src=>['/css/mbgd.css', '/css/mbgd_button.css']});

print "<CENTER> <H1> Gene Information </H1> </CENTER>\n";

print "<TABLE border=\"0\" cellpadding=\"4\">\n";

## Name
print "<TR><TH align=\"left\">Name</TH><TD>$geneInfo->{'name'}</TD></TR>\n";

## GeneName
unless($geneInfo->{'gene'} eq '') {
    print "<TR><TH align=\"left\">GeneName</TH><TD>$geneInfo->{'gene'}</TD></TR>\n";
}

## Description
unless($geneInfo->{'descr'} eq '') {
    print "<TR><TH align=\"left\">Description</TH><TD>$geneInfo->{'descr'}</TD></TR>\n";
}

# Function Category
$objFuncCatMbgd = new MBGD::FunctionCategory('mbgd');
$objFuncCatCog  = new MBGD::FunctionCategory('cog');
$objFuncCatKegg = new MBGD::FunctionCategory('kegg');
$objFuncCatTigr = new MBGD::FunctionCategory('tigr');

#$opt = {'fromdb' => 1};
#$funcNameMbgd = $objFuncCatMbgd->getFunctionFullnameBySporf($Args{"name"}, $opt);
#$funcNameCog  = $objFuncCatCog->getFunctionFullnameBySporf($Args{"name"}, $opt);
#$funcNameKegg = $objFuncCatKegg->getFunctionFullnameBySporf($Args{"name"}, $opt);
#$funcNameTigr = $objFuncCatTigr->getFunctionFullnameBySporf($Args{"name"}, $opt);

## Organism
print "<TR><TH align=\"left\">Organism</TH><TD>$genomeInfo->{'orgname'} ";
unless($genomeInfo->{'strain'} eq '') {
    print " $genomeInfo->{'strain'}";
}
print "</TD></TR>\n";

## Position
print "<TR><TH align=\"left\"> Position </TH>";
print "<TD>$geneInfo->{'from1'} - $geneInfo->{'to1'}";
#$stdSequence = $chrInfo->{'name'};
if ($chrInfo) {
	$stdSequence = $chrInfo->get_name();
	print " ( $stdSequence ) " if($stdSequence ne "");
}
print "</TR>\n";

## GI
print "<TR><TH align=\"left\"> GI </TH>";
print "<TD>$geneInfo->{'gi'}" if ($geneInfo->{'gi'});
print "</TR>\n";

##
print "</TABLE>\n";


##if (1 < $DomainMx) {
##    print "<TR VALIGN=TOP>\n";
##    print "<TD><H4> Domain </H4><TD>";
##    print "<TD> $DomainNo  ( $DomainMx )";
##print "<FORM METHOD=\"POST\" ACTION=\"/htbin/cluster\">\n";
##print "<INPUT TYPE=\"submit\" NAME=\"DOMCLUST\" VALUE=\"show DOMAIN\">\n";
###print "<INPUT TYPE=\"hidden\" NAME=\"connect\" VALUE=\"nearest\">\n";
##print "<INPUT TYPE=\"hidden\" NAME=\"show_domclust\" VALUE=\"$Organism:$GeneName\">\n";
##print "<INPUT TYPE=\"hidden\" NAME=\"species\" VALUE=\"$Species\">\n";
##print "<INPUT TYPE=\"hidden\" NAME=\"motif\" VALUE=\"$Motif\">\n";
##print "<INPUT TYPE=\"hidden\" NAME=\"class\" VALUE=\"$Class\">\n";
##print "<INPUT TYPE=\"hidden\" NAME=\"description\" VALUE=\"$Descript\">\n";
##print "</FORM>\n";
##    print "</TR>\n";
##}

$From = $geneInfo->{'from1'};
$To   = $geneInfo->{'to1'};
$Position = int(($From + $To + 1) / 2);
($From, $To) = ($To, $From) if($From > $To);
$Width = $To - $From + 1;

## Buttons
print <<"EOB";
<HR>
<script>
function updRegionMap(name) {
    var doc = this.document;
    var func_db = doc.f_gene_info.func_db.value;
    var url = 'RECOG_region_map_html.pl?name=' + name
            + '&func_db=' + func_db;
	var win = open(url, 'appendix');

    return false;
}

</script>
<form name="f_gene_info">
<TABLE border=0 cellpadding=5><TR align=center>
<TR>
<TH>Go to:
<TD class="button">
<A HREF="SeqSearch.pl?
	orfname=$Organism:$GeneName&showall=on&ovlpcheck=on&tabid=$Args{'tabid'}" TARGET="_top">
	Homolog list</A>

<TD class="button">
<A HREF="/htbin/RECOG/list_cluster_gene.cgi?spname=$Organism:$GeneName&tabid=$Args{'tabid'}" TARGET="_top">
	Orthologous Cluster </A>

<TD class="button">
<A HREF="RECOG_region_html.pl?spec=$Organism&genename=$GeneName&lines=2&tabid=$Args{'tabid'}" TARGET="_top">
	Wide Region Map</A>
</TABLE>

<TABLE border=0 cellpadding=5><TR align=center>
<TR align=center>
<TH>Display:
<TD class="button">
<A HREF="RECOG_region_map_html.pl?name=$Organism:$GeneName"
	TARGET="appendix"> Region Map </A>

<TD class=button>
<A HREF="RECOG_seqreg_html.pl?name=$Organism:$GeneName&displayMode=Motif&tabid=$Args{tabid}"
	TARGET="appendix"> Domains </A>

<TD class=button>
<A HREF="RECOG_funccat_html.pl?name=$Organism:$GeneName"
	TARGET="appendix"> Function Category </A>

<TD class=button>
<A HREF="getGeneSequence.pl?name=$Organism:$GeneName&type=nucleotide"
	TARGET="appendix"> NT seq </A>

<TD class=button>
<A HREF="getGeneSequence.pl?name=$Organism:$GeneName&type=protein"
	TARGET="appendix"> AA seq </A>

</TABLE>

<TABLE border=0 cellpadding=5><TR align=center>
<TR>
<TH> External Links:
<TD class="button">
<A HREF="http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&val=$ProtID" TARGET="_top">NCBI</A>
<TD class="button">

<A HREF="http://www.expasy.org/${UniProtGetURL}" TARGET="_top">UniProt</A>

<TD class="button">
<A HREF="http://www.genome.ad.jp/dbget-bin/www_bget?${Organism}:${GeneName}" TARGET="_top">KEGG</A>
<TD class="button">
<A HREF="http://gib.genes.nig.ac.jp/common/data.php?kegg=$Organism&prot=$InsdProtID" TARGET="_top"> GIB </A>
<TD class="button">
<A HREF="http://spock.genes.nig.ac.jp/~genome/cgi-bin/mas.pl.cgi?protein_id=$InsdProtID" TARGET="_top">GTOP</A>
<TD class="button">
<A HREF="http://www.tigr.org/tigr-scripts/CMR2/GenePage.spl?type=protein_id&acc=$InsdProtID" TARGET="_top">TIGR-CMR</A>
</TABLE>

</form>
EOB

print "</BODY>\n";
print "</HTML>\n";

exit;

###############################################################################
1;#
###############################################################################
