#!/usr/bin/perl -s

###############################################################################

use GD;
use MBGD::WWW;
use MBGD::Contig;
require 'MBGD_Conf.pl';
require "libMBGDImg.pl";
require "libMBGDImgMap.pl";
require "libMBGDaxes.pl";
require "emergency.pl";

#use POSIX "sys_wait_h";
#use CGI;
#use UserInfo;
##require "libHTML.pl";
##require "libMBGDHomolParam.pl";
##require "libMBGDUserInfo.pl";
#require "MBGD_common.pl";

$| = 1;

$Path_htbin = "$MBGD_PATH_HTBIN";

$WWW = MBGD::WWW->new(title=>"Genome Region Map");

#
$db = MBGD::DB->new($ENV{'MYSQL_DB'});

#
($db) = MBGD::DB->new($ENV{'MYSQL_DB'});

if(defined($ENV{'REQUEST_METHOD'})) {
    my($cgi) = $WWW->cgi;

    @Org_stdName = $cgi->param('org_std_name'); # Organism and Standart Name

    $fid       = $cgi->param('fid');                # file ID
    $tabID       = $cgi->param('tabid');            # table ID
    $ClustID       = $cgi->param('clustid');        # cluster ID
    $Organism  = $cgi->param('organism');           # Organism Name
    $GeneName  = $cgi->param('genename');           #
##    $MaxDom    = $cgi->param('maxdom');             #
    $Width     = $cgi->param('width');              #
    $Zoom      = $cgi->param('zoom');               #
    $Zoom      = 1 if($Zoom == 0);            #
    $DispMode  = $cgi->param('DispMode');           #
    $PrevMode  = $cgi->param('PrevMode');           #
    $dbgMode   = $cgi->param('debug');
    $add_spname = $cgi->param('add_spname');
    if (my $orfname = $cgi->param('orfname')) {
#	($Organism, $GeneName, $MaxDom) = split(/:/, $orfname);
	($Organism, $GeneName) = split(/:/, $orfname);
    }

    if (! $tabID && $fid) {
    	($tabID)   = ($fid =~ /(\d+)/);           # cluster table ID
    }
    if (! $tabID) {
	$tabID = 'default';
    }
    if (! $Width) {
	$Width = 20000;		# default width
    }

    if(defined($cgi->param('left.x'))) {
        $RegWidth = $Width;
        $Offset   = int($RegWidth / 2) * (-1);
    }
    elsif(defined($cgi->param('right.x'))) {
        $RegWidth = $Width;
        $Offset   = int($RegWidth / 2);
    }
    elsif($DispMode ne $PrevMode) {
        $RegWidth = $Width;
    }
    else {
        $Offset   = 0;
        $RegWidth = int($Width / $Zoom + 0.5);
    }

    $Base   = $cgi->param('baseOffset');
    $Base  += $Offset;

#    $uid   = $cgi->cookie('uid');
#    %Param = &getUserParam($uid);

#    %Param = $WWW->uInfo->getHomolParamHash();
#    $PVAL  = $Param{'pval'};
#    $SCORE = $Param{'score'};
#    $IDENT = $Param{'ident'};
#    $OVLP  = $Param{'ovlp'};
#    $PAM  = $Param{'pam'};
}
else {
    $Organism = shift( @ARGV );
    $GeneName = shift( @ARGV );
    $RegWidth = 20000 unless( defined( $RegWidth ));
    $Path_htbin = "";
}


#
if($DispMode eq 'multi_noname') {
    @MBGD_REGION_IMG_SIZE    = (750, 50);         #
    @MBGD_REGION_IMG_SEQ     = (0, 25, 750, 25);  #
    @MBGD_REGION_IMG_SCALE   = (0, 25, 750, 25);  #
    $MBGD_REGION_IMG_SEQ_WIDTH    = 1;            #
    $MBGD_REGION_IMG_GENOME_COLOR = "0_0_0";      #
    $noOrfName                = 1;                #
}
else {
    $DispMode = 'multi';
    @MBGD_REGION_IMG_SIZE    = (750, 80);         #
    @MBGD_REGION_IMG_SEQ     = (0, 40, 750, 40);  #
    @MBGD_REGION_IMG_SCALE   = (0, 40, 750, 40);  #
    $MBGD_REGION_IMG_SEQ_WIDTH    = 1;            #
    $MBGD_REGION_IMG_GENOME_COLOR = "0_0_0";      #
    $noOrfName                = 0;                #
}


for( $i = 0; $i < scalar( @Org_stdName ); $i++ ) {
    $SaveOrgStdName .= sprintf( "<INPUT TYPE=\"hidden\" NAME=org_std_name VALUE=%s>\n", $Org_stdName[$i] );
}

### Output HTML
$WWW->start_html;
$WWW->page_header(center=>1, hrank=>'H1');

if ($ClustID) {
    my(%default_spec_hash);
    if ($tabID =~ /^addspec$/i) {
        my(@default_spec_list) = main::MBGD_SpecTableGetDefaultSpecies();
        foreach my$sp (@default_spec_list) {
            $default_spec_hash{"$sp"} = 1;
        }
    }

	$ClustID =~ s/^[A-Z]//;
	my $ent = &getGeneByClustID( $tabID, [$ClustID]) ;
	foreach $g (@{$ent}) {
        my($sp, $name) = split(/\:/, $g->{spname});
        if (($tabID =~ /^addspec$/i) && (!exists($default_spec_hash{"$sp"}))) {
            next;
        }
		push(@DispName, $g->{spname} );
	}
    if (($tabID =~ /^addspec$/i) && ($add_spname ne '')) {
        foreach my$spname (split(/\,/, $add_spname)) {
            push(@DispName, $spname);
        }
    }
} elsif (@Org_stdName) {
	@DispName = ("$Organism:$GeneName", @Org_stdName);
} else {
	my $clist = &searchClusterIdByGenes( $tabID, ["$Organism:$GeneName"] );
	foreach $cl (@{$clist}) {
		my $ent = &getGeneByClustID( $tabID, [$cl->{clustid}]) ;
		foreach $g (@{$ent}) {
			push(@DispName, $g->{spname} );
		}
	}
}

%GeneColor = &get_gene_colors( $RegWidth, $Base, @DispName );

print "<FORM METHOD=POST ACTION=\"${Path_htbin}RECOG/RECOG_multi_region_html.pl\">\n";

#
print "<TABLE Border=0>\n";

@DispName = &sort_genenames(@DispName);   # sort by taxonomic order
$PrevOrg = "";

#
for($i = 0; $i < scalar( @DispName ); $i++) {
#	( $org_name, $std_name, $maxDom ) = split( /:/, $DispName[$i] );
	( $org_name, $std_name) = split( /:/, $DispName[$i] );

	($genome) = MBGD::Genome->get("$org_name");
	$stdOrganism  = $genome->{'orgname'};
	$stdOrganism .= " $genome->{strain}" if ($genome->{strain});

	($gene) = MBGD::Gene->get( "$org_name:$std_name" );
	my $chrid = $gene->{'chrid'};
	my $contigid = $gene->{'contigid'};

#	if (!$chrid && !$contigid) {
#		print STDERR "Chromosome not found (skipped): $org_name:$std_name\n";
#		next;
#	}
	my($chrom, $chrLen, $stdSequence);

    if ($chrid) {
        ($chrom) = MBGD::Chromosome->fetch($chrid);
    } elsif ($contigid) {
        ($chrom) = MBGD::Contig->fetch($contigid);
    }
    if ($chrom) {
	$stdSequence = $chrom->get_name();
	$chrLen      = $chrom->length;
    }


        $orgOffset = $Base;
        $PrevOrg  = $org_name;
        $colors   = join( "+", @{$GeneColor{"$org_name:$std_name"}} );

        &CreateImgSection($stdOrganism, $stdSequence,
                      $org_name, $chrid, $contigid, $chrLen,
                      $std_name, $RegWidth, $colors,
                      $orgOffset, $noOrfName);
}

#
$MoveLeft  = int($RegWidth / 2) * (-1);
$MoveRight = int($RegWidth / 2);
print <<"EOD";

<TR><TH><TD><TD Align=center>
<INPUT NAME="left"  TYPE="image" SRC="/image/blue_prev.gif">
<INPUT NAME="right" TYPE="image" SRC="/image/blue_next.gif">
</TABLE>

<INPUT TYPE=hidden NAME=tabid      VALUE=$tabID>
<INPUT TYPE=hidden NAME=clustid      VALUE=$ClustID>
<INPUT TYPE=hidden NAME=organism VALUE=$Organism>
<INPUT TYPE=hidden NAME=width    VALUE=$RegWidth>
<INPUT TYPE=hidden NAME=genename VALUE=$GeneName>

$SaveOrgStdName

<INPUT TYPE="hidden" NAME="baseOffset" VALUE=$Base>
<TABLE BORDER=0>
<TR><TD>
 Change Scale
<SELECT NAME="zoom">
<OPTION          VALUE="0.01"> x1/100
<OPTION          VALUE="0.1" > x1/10
<OPTION          VALUE="0.2" > x1/5
<OPTION SELECTED VALUE="0.5" > x1/2
<!--- <OPTION          VALUE="1"   > x1 --->
<OPTION          VALUE="2"   > x2
<OPTION          VALUE="5"   > x5
<OPTION          VALUE="10"  > x10
<OPTION          VALUE="100" > x100
</SELECT>
EOD

$isMulti  = "SELECTED" if($DispMode eq 'multi');
$isNoname = "SELECTED" if($DispMode eq 'multi_noname');
print "<TD>\n";
print "Display ORF Name";
print "<SELECT NAME=\"DispMode\">\n";
print "<OPTION $isMulti  VALUE=\"multi\"       > Yes\n";
print "<OPTION $isNoname VALUE=\"multi_noname\"> No \n";
print "</SELECT>\n";
print "<INPUT TYPE=\"hidden\" NAME=\"PrevMode\" VALUE=\"$DispMode\">\n";

###############################################################################
my $AllVariables;
my $key;
foreach $key (keys %Args) {
    unless(ref $Args{$key} eq 'ARRAY') {
        $AllVariables .=
        sprintf("<INPUT TYPE=\"hidden\" NAME=\"%s\" VALUE=\"%s\">\n",
        $key, $Args{$key});
    }
    else {
        my @tmp = @{$Args{$key}};
        while(scalar(@tmp)) {
            $AllVariables .=
            sprintf("<INPUT TYPE=\"hidden\" NAME=\"%s\" VALUE=\"%s\">\n",
            $key, shift(@tmp));
        }
    }
}
###############################################################################

print <<"EOD";
<TD>
<INPUT TYPE="submit" VALUE="Exec">
</TABLE>
</FORM>
EOD

#print "</BODY></HTML>\n";
$WWW->page_footer;
$WWW->end_html;

exit;

###############################################################################
#
#
sub CreateImgSection {
    my($StdOrganism, $StdSequence, $Organism, $ChrId, $ContigId, $Length,
          $GeneName, $RegWidth, $Colors, $Offset,
          $NoOrfName) = @_;
    my($Reverse);
    my($RegStart, $RegEnd, $Point);
    my($Pattern, @drawCmnds, @ImageMap);
    my($x1, $y1, $x2, $y2, $font, $color, $gene, $comment);
    my(@GeneInfo, @Position, $From, $To);
    my($work_gene, $work_orf);

    @drawCmnds = ();
    @ImageMap  = ();

    my($opt);
    my($infoGene) = MBGD::Gene->get($db, ["$Organism:$GeneName"], $opt);
    $From = $infoGene->{'from1'};
    $To   = $infoGene->{'to1'};
#    if($From < $To) {
    if($infoGene->{dir} > 0) {
        $Reverse = 0;
        $Dir = 1;
#    	$Point   = int(( $From + $To + 1 ) / 2 ) + $Offset;
    }
    else {
#       $Reverse = 1;
        $Reverse = -1;
        $Dir = -1;
#        $Point   = int(( $From + $To + 1 ) / 2 ) - $Offset;
    }
    $Point   = int(( $From + $To + 1 ) / 2 ) + $Offset * $Dir;

if (! $ChrId && ! $ContigId && $Length==0) {
	$Length = ($To - $From + 1);
}

    $RegStart = $Point - int( $RegWidth / 2 );
    $RegEnd   = $RegStart + $RegWidth;
    if( $RegEnd <= 0 ) {
        $RegStart += $Length + 1;
        $RegEnd   += $Length + 1;
        $Point    += $Length + 1;
    }
    elsif( $RegStart >= $Length ) {
        $RegStart -= $Length;
        $RegEnd   -= $Length;
        $Point    -= $Length;
    }

    #
    my(%map_opt);
    $libMBGDImgMap::cgi_gene_info = 'RECOG/RECOG_gene_info_frame.pl';
    $map_opt{CenterGene}=$GeneName if (! $ChrId || ! $ContigId);
    $ImageMap = &create_clickable_map($Organism, $ChrId, $ContigId, $Point,$RegWidth, $Reverse,%map_opt);

    print "<TR><TH><TD vAlign=Top nowrap>\n";
    print "<FONT SIZE=3>";
    print "<I><B> $StdOrganism </B></I><br>\n";
    print "</FONT>\n";
    print "<center>$StdSequence</center>";
    print "<FONT SIZE=2><CENTER>\n";
    if($Reverse) {
        print "($RegEnd - $RegStart)\n";
        print "<BR>[Reverse]\n" if($DispMode ne 'multi_noname');
    }
    else {
        print "($RegStart - $RegEnd)\n";
    }
    print "</CENTER></FONT>\n";

    print "<TD>";

    #
    my(@colorList) = split(/\+/, $Colors);
    my($color) = "";
    my($c);
    foreach $c (@colorList) {
        $color .= "&" if ($color ne '');
        $color .= "color=$c";
    }

    print <<"EOD";
<MAP NAME="REGION_MAP_$ {Organism}_$ {GeneName}">
$ImageMap
</MAP>
<CENTER>
<IMG SRC="${Path_htbin}RECOG/RECOG_region_image.pl?spec=$Organism&chrid=$ChrId&contigid=$ContigId&pos=$Point&width=$RegWidth&dir=$Dir&name=$GeneName&dom=$MaxDom&mode=$DispMode&$color" USEMAP="#REGION_MAP_${Organism}_${GeneName}" BORDER=0 WIDTH="$MBGD_REGION_IMG_SIZE[0]" HEIGHT="$MBGD_REGION_IMG_SIZE[1]">
</CENTER>
EOD

}

###############################################################################
#
sub get_genes {
    my( $org, $chrid, $contigid, $from, $to ) = @_;
    my( @result );
    my($res);
    my($ent);

    $res = &MBGD_GetAllGeneInReg($chrid, $contigid, $from, $to);

    foreach $ent (@{$res->{'INFO'}}) {
        push( @result, "$org\:$ent->{'name'}" );
    }

    return @result;
}

##############################################################################e
#
sub get_region_around_gene {
    my( $Organism, $GeneName, $RegWidth, $Offset ) = @_;

    my( $Length, @GeneInfo, @Position, $Point, $From, $To );
    my( $RegStart, $RegEnd );
    my( @Result );
    my($sequence);

    my($opt) = {};
#    $opt->{'depth'} = 2;
    my($gene) = MBGD::Gene->get($db, ["$Organism:$GeneName"], $opt);
    my($chrid) = $gene->{'chrid'};
    my($contigid) = $gene->{'contigid'};
if (!$chrid && !$contigid) {
	print STDERR "Chromosome not found (skipped): $Organism:$GeneName $chrid\n";
	return ("$Organism:$GeneName");
}

#if ($chrid==314){
#$chrid=1409;
#}
    my($chrom);
    if ($chrid) {
        ($chrom) = MBGD::Chromosome->fetch($db, $chrid);
    }
    elsif ($contigid) {
        ($chrom) = MBGD::Contig->fetch($db, $contigid);
    }
    $Length = $chrom->{'seq_length'};

    $From = $gene->{'from1'};
    $To   = $gene->{'to1'};
    if($From < $To) {
        $Point    = int(( $From + $To + 1 ) / 2 ) + $Offset;
    }
    else {
        $Point    = int(( $From + $To + 1 ) / 2 ) - $Offset;
    }
    $RegStart = $Point - int( $RegWidth / 2 );
    $RegEnd   = $RegStart + $RegWidth;
    if( $RegEnd <= 0 ) {
        $RegStart += $Length + 1;
        $RegEnd   += $Length + 1;
        $Point    += $Length + 1;
    }
    elsif( $RegStart >= $Length ) {
        $RegStart -= $Length;
        $RegEnd   -= $Length;
        $Point    -= $Length;
    }

    @Result = &get_genes( $Organism, $chrid, $contigid, $RegStart, $RegEnd);
    if ($RegStart < 0) {
        push(@Result, &get_genes( $Organism, $chrid, $contigid, $RegStart + $Length, $Length ));
    }
    if ($Length <= $RegEnd && $Length > 0) {
        push(@Result, &get_genes( $Organism, $chrid, $contigid, 0, $RegEnd % $Length ));
    }

    return @Result;
}

###############################################################################
#
sub get_gene_colors {
    my( $Width, $Offset, @Org_Genes ) = @_;
    my( $Org, $Gene );
    my( @GeneList, %NbrGeneList );
    my( $filename );
    my( %pidList );
    my( $i );

#    my( @Tiles );
#    push(@Tiles,
#         &MBGDImg_MakeMonoColorTiles(@MBGD_REGION_IMG_GENE_COLOR_LIST));
#    push(@Tiles,
#         &MBGDImg_MakePatternTiles(@MBGD_REGION_IMG_GENE_TILE_COLOR_LIST));
#print STDERR "3,",0+@Org_Genes,"\n";

    for($i = 0; $i < scalar(@Org_Genes); $i++) {
        ( $Org, $Gene ) = split( /:/, $Org_Genes[$i]);

        my(@res) = &get_region_around_gene( $Org, $Gene, $Width, $orgOffset );
        $NbrGeneList{"$Org:$Gene"} =  \@res;
        push( @GeneList, @res);
    }
print STDERR "@GeneList\n";

    my(%colors);	# $colors{$sp} = [list of genes]
    # [cluster ID]
    my($refClusterId);
    my($info);
    my($centerCount);
    my($orfCount);	## $orfCount{$clustid} = $cluster_count;
    my(%orfDom);	## $orfDom{$orfname} = [ $domains,... ];
    my(%dom2clust);	## $dom2clust{"$orfname:$dom"} = {id=>clustid,...}
    my(%clid2color);	## $clid2color{$clustid} = $color;
    my(@clustIDs);
    my($colorIdx);
    my(%maxDom);

    # cluster table
    $refClusterId = &searchClusterIdByGenes($tabID, \@GeneList);

	
    my(@gnames, %GeneLength);
    foreach $ent (@{$refClusterId}) {
	push(@gnames, $ent->{sp} . ":" . $ent->{name});
    }

    my @Genes = MBGD::Gene->get(\@gnames);
    foreach my $g (@Genes) {
	$GeneLength{ $g->{sp} . ":" . $g->{name} } = $g->{aalen};
    }

    foreach $ent (@{$refClusterId}) {
        my($id)     = $ent->{'clustid'};
        my($sp)     = $ent->{'sp'};
        my($name)   = $ent->{'name'};
        my($spname) = $ent->{'spname'};
        my($dom)    = $ent->{'dom'};
#print STDERR "$id, $sp,$name, $spname,$dom\n";


        $centerCount->{"$id"}++ if ($NbrGeneList{"$sp:$name"});
        $orfCount->{"$id"}++;

        push(@{$orfDom{$spname}}, $dom);
        my $length = $GeneLength{"$sp:$name"};
        $dom2clust{"$spname:$dom"} = {
            id     => $id,
            from   => $ent->{from1},
            to     => $ent->{to1},
            length => $length
        };

    }

    # Eliminate clusters that appear only once in this region
    foreach $key (keys(%{$orfCount})) {
        if ($orfCount->{"$key"} == 1) {
            delete($orfCount->{"$key"});
        }
    }

    # The clusters are ordered according to the number of occurrences
    # in the region
    @clustIDs = sort {
			$centerCount->{$b}<=>$centerCount->{$a} ||
			$orfCount->{$b}<=>$orfCount->{$a}
		} keys(%{$orfCount});

    $colorIdx = 0;
    foreach $clid (@clustIDs) {
        $clid2color{"$clid"} = $colorIdx++;
    }

    foreach $center_gene (keys %NbrGeneList) {
#print STDERR "center>$center_gene\n";
	foreach $g (@{ $NbrGeneList{$center_gene} }) {
	    foreach $dom (@{ $orfDom{$g} }) {
		my ($org,$gene) = split(/:/, $g);
		my ($key) = "$g:$dom";

	        $data = $dom2clust{$key};

	        next if (! defined($clid2color{"$data->{id}"}));
#print STDERR "$org,$gene,$dom $data->{id}:$data->{from}:$data->{length}\n";

		my $gdata = join(":", $gene, $clid2color{$data->{id}}, $dom);
		my $from = sprintf("%.2f",$data->{from}/$data->{length});
		my $to = sprintf("%.2f",$data->{to}/$data->{length});
		if (! ($from == 0 && $to == 1)) {
			$gdata .= ":$from:$to";
		}
       		push( @{$colors{$center_gene}}, $gdata);
	    }
	}
    }

    return(%colors);
}

###############################################################################
#
sub sort_org_and_genes {
    my( $org, @list ) = @_;
    my( @result );
    my( $buf, @match, @unmatch );

    while( scalar( @list )) {
        $buf = shift( @list );
        if( $buf =~ /^\s*$org:/ ) {
            push( @match, $buf );
        }
        else {
            push( @unmatch, $buf );
        }
    }

    push( @result, @match, sort @unmatch );

    return @result;
}

sub sort_genenames {
	my(@genenames) = @_;
	my($i);
	my(%Order, %GeneOrder);
	foreach $sp (&MBGD_SpecTableGetAllSpec()) {
		$Order{$sp} = ++$i;
	}
	foreach $g (@genenames) {
		($sp,$gene) = split(/:/, $g);
		$GeneOrder{$g} = $Order{$sp};
	}
	return sort {$GeneOrder{$a}<=>$GeneOrder{$b}} @genenames;
}

###############################################################################
#
sub searchClusterIdByGenes {
#    return searchClusterIdByGenes_mbgd(@_);
    return searchClusterIdByGenes_recog(@_);
}

###############################################################################
#
sub searchClusterIdByGenes_mbgd {
    my($tabID, $refGeneList) = @_;

    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DBTMP'};
    $db = MBGD::DB->new($dbname);

    $tab = "cluster_$tabID";
##    $opt->{'columns'} = "clustid, sp, name, spname, dom";
    $opt->{'where'} = "";
    return 0 if (! @{$refGeneList});

    foreach $genename (@{$refGeneList}) {
        $opt->{'where'} .= "," if ($opt->{'where'} ne '');
        $opt->{'where'} .= $db->{conn}->quote($genename);
    }
    $opt->{'where'} = "spname in ($opt->{'where'})";
    $opt->{'order'} = "spname, dom";

    #
    $res = $db->select_fetch($tab, $opt);
    @{$refClust} = @{$res->{'INFO'}};

    return $refClust;
}

###############################################################################
#
sub searchClusterIdByGenes_recog {
    my($tabID, $refGeneList) = @_;

    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $main::DBNAME_RECOG;
    $db = MBGD::DB->new($dbname);

    $tab = "cluster_domclust_cache_$tabID";
##    $opt->{'columns'} = "clustid, sp, name, spname, dom";
    $opt->{'where'} = "";
    return 0 if (! @{$refGeneList});

    foreach $genename (@{$refGeneList}) {
        $opt->{'where'} .= "," if ($opt->{'where'} ne '');
        $opt->{'where'} .= $db->{conn}->quote($genename);
    }
    $opt->{'where'} = "spname in ($opt->{'where'})";
    $opt->{'order'} = "spname, dom";

    #
    $res = $db->select_fetch($tab, $opt);
    @{$refClust} = @{$res->{'INFO'}};

    return $refClust;
}

###############################################################################
#
sub getGeneByClustID {
#    return getGeneByClustID_mbgd(@_);
    return getGeneByClustID_recog(@_);
}

###############################################################################
#
sub getGeneByClustID_mbgd {
    my($tabID, $clustList) = @_;
    my $dbname = $ENV{'MYSQL_DBTMP'};
    my $db = MBGD::DB->new($dbname);
    my $tab = "cluster_$tabID";

#    $opt->{'columns'} = "spname, dom";
    $opt->{'where'} = "";
    return 0 if (! @{$clustList});

    foreach $clid (@{$clustList}) {
        $opt->{'where'} .= "," if ($opt->{'where'} ne '');
        $opt->{'where'} .= "$clid";
    }
    $opt->{'where'} = "clustid in ($opt->{'where'})";
    my $res = $db->select_fetch($tab, $opt);
    $res->{INFO};
}

###############################################################################
#
sub getGeneByClustID_recog {
    my($tabID, $clustList) = @_;

    my $dbname = $main::DBNAME_RECOG;
    my $db = MBGD::DB->new($dbname);
    my $tab = "cluster_domclust_cache_$tabID";

#    $opt->{'columns'} = "spname, dom";
    $opt->{'where'} = "";
    return 0 if (! @{$clustList});

    foreach $clid (@{$clustList}) {
        $opt->{'where'} .= "," if ($opt->{'where'} ne '');
        $opt->{'where'} .= "$clid";
    }
    $opt->{'where'} = "clustid in ($opt->{'where'})";
    my $res = $db->select_fetch($tab, $opt);
    $res->{INFO};
}

###############################################################################
1;#
###############################################################################
