#!/usr/bin/perl -s
#
# DomClust CGIǥƥȥץ
#
BEGIN {
#    $main::USE_QSUB = 1;
    require 'MBGD_commonPath.pl';
    $main::CMD_select = '$MBGD_HOME/WWW/bin/select.pl';
    $main::CMD_domclust = '$MBGD_HOME/WWW/bin/domclust';
}
#$main::DEBUG = 1;
$main::SAVE_log = 1;

use CGI qw/ :standard start_table end_table /;
use RECOG;
use RECOG::DomClustCommon;
use RECOG::MBGD::DomClust;
use RECOG::MBGD::ClusterTable;
use RECOG::MBGD::OutputDomClust;
use MBGD::DB;
use MBGD::Taxonomy;
use RECOG::RecogCommon;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'MBGD_commonPath.pl';

$| = 1;
###############################################################################
#
sub printWarnings {
	my($db) = shift;
	my($st) = shift;
	my($clid) = shift;
	my($outputFormat) = shift;

	if($clid) { 
		my $status = getStatus($db, $clid);
        # tabidְäƤ
        if($status) { # ¹Խλ or 顼λ
			if($outputFormat eq 'html') {
				$st->showWarnings($db, $clid);
			} else {
				$st->showWarnings_txt($db, $clid);
			}
			return;
        }
	}

	# clusterIDְäƤ
	if($format eq 'html') {
		$st->outputError('1',$clid);
	} else {
		$st->outputError_txt('1',$clid);
	}

    return;
}

###############################################################################
#
sub parseTargetSpecies {
	my(@param) = @_;
    my($refSpec) = {};

	foreach my $s (grep length($_), @param) {
		foreach my $p (split/,/,$s) {
			if(length($p) > 0) {
				$refSpec->{$p} = 1;
			}
		}
	}

    return $refSpec;
}

###############################################################################
#
sub printDomClustStatus {
    my($db) = shift;
    my($st) = shift;
    my($tabid) = shift;
    my($format) = shift;
    my($type) = shift;
    my($mode_get_status) = shift;

    if ($tabid !~ /^\d+\_\d+$/) {
        # invalid tabid format!
        print STDERR "DBG :: invalid tabid format :: $tabid\n";
        if($format eq 'html') {
            $st->outputError('1',$tabid);
        } else {
            $st->outputError_txt('1',$tabid);
        }
        exit;
    }

    #
	if(length($tabid) >1) {

		my $status = getStatus($db, $tabid);

		# $tabid ¸ߤʤ̤¹ or Ťƺ줿
		if(!$status) {
#            if($format eq 'html') {
#                $st->outputError('1',$tabid);
#            } else {
#                $st->outputError_txt('1',$tabid);
#            }
#			exit;
        }
		elsif($status == -1) { # ¹Խλ
            my $header = $st->clusterIDtoInfo($db, $tabid);
			if($format eq 'o11') {
                $st->write_o11($db, $type, $tabid, $header, $mode_get_status);
            }
			elsif($format eq 'list') {
                $st->write_list($db, $type, $tabid, $header, $mode_get_status);
            }
            elsif ($format eq 'html') {
				$st->write_html($db, $type, $tabid, $header, $mode_get_status);
            }
            else {
				$st->write_text($db, $type, $tabid, $header, $mode_get_status);
			}
			exit;
		}
		elsif($status == -99) { # ¹ԥ顼
			if($format eq 'html') {
                $st->outputError('-99',$tabid);
            } else {
                $st->outputError_txt('-99',$tabid);
            }
			exit;
		}
		# domclustμ¹
		else {
			# ˼¹椫򤷤٤롣
			if(isRunning($status)) {
				if($format eq 'html') {
					$st->runTabID($db,$tabid,$type);
				} else {
					$st->runTabID_txt($db,$tabid,$type);
				}
				exit;
			}

			# retryμ¹Բ°ʤȥ饤
			if(canRetry($db,$tabid)) {
				uploadRetryStatus($db,$tabid);
			} else {
				addRetryCountOver($db,$tabid);
				if($format eq 'html') {
					$st->outputError(3,$tabid);
				} else {
					$st->outputError_txt(3,$tabid);
				}
				exit;
			}
		}
	}
}

###############################################################################
sub check_species {
    my($tax) = shift;
    my($mode_no_exec) = shift;
    my(@target_species) = @_;

    my(@all_spec_list) = $tax->get_all_spec();
    my(%all_spec_hash);
    foreach my$sp (@all_spec_list) {
        $all_spec_hash{"$sp"} = 1;
    }

    #
    my(@ng_spec_list);
    foreach my$sp (@target_species) {
        if (!exists($all_spec_hash{"$sp"})) {
            push(@ng_spec_list, $sp);
        }
    }

    #
    my($n_ng_spec) = scalar(@ng_spec_list);
    if ($n_ng_spec != 0) {
	my($MAX_ERRSP) = 15;
        my($err_spec) = join(',', @ng_spec_list[0..$MAX_ERRSP-1]);
	my($etc) = "..." if ($n_ng_spec > $MAX_ERRSP);
	my($msg) = "domclust.cgi: The following $n_ng_spec genomes are not found in the current taxonomy data: $err_spec$etc\n";
        printErrMsgExit($DomClustCommon::ERRNO_NO_SPEC, $msg);
        exit(0);
    }

    if ($mode_no_exec) {
        print "Content-type: text/plain\n";
        print "\n";
        print "#STATUS=ok\n";
        exit(0);
    }

    return;
}

###############################################################################
#
sub exists_taxdump {
    my($db) = shift;
    my($tabid) = shift;
    my(@spec_list) = @_;

    #
    my($sql, $sth, $ref);

    $sql = "select * from $main::TBL_DOMINDEX where clusterID=?";
    $sth = $db->prepare($sql);
    $sth->execute($tabid);
    if ($sth->rows() == 0) {
        return;
    }
    $ref = $sth->fetchrow_hashref();
    my($cmdstr) = $ref->{'cmd'};
    my($cmd_dump) = RECOG::Cache::mysql::getCmdForDump(undef(), $cmdstr);
    my($cmdstr_ref) = RECOG::Cache::mysql::parseCmdOpts(undef(), $cmd_dump);
    $sql = "select * from $main::TBL_DOMINDEX";
    my $st = $db->execute($sql);
    my($dumpid);
    while(my$ref = $st->fetchrow_hashref()) {
        my($cmd_dump) = RECOG::Cache::mysql::getCmdForDump(undef(), $ref->{'cmd'});
        my($cmd_ref) = RECOG::Cache::mysql::parseCmdOpts(undef(), $cmd_dump);
        my($staCmdCmp) = RECOG::Cache::mysql::canUseSameCmdOptsForDump(undef(), $cmdstr_ref, $cmd_ref);
        if ($staCmdCmp) {
            my($fileDump) = "$ENV{'MBGD_HOME'}/MBGD.tmp/clustdump_" . $ref->{'clusterID'};
            if (-e $fileDump) {
                # dump ̥ơ֥뤢
                $dumpid = $ref->{'clusterID'};
                last;
            }
        }
    }

    if (!$dumpid) {
        return;
    }

    my($sql) = "select * from $main::TBL_DOMTAXMAPIDX where dumpid=? or clustid=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($dumpid, $dumpid);
    if ($sth->rows() == 0) {
        return;
    }

    #
    my(%map_spec);
    while (my$ref=$sth->fetchrow_hashref()) {
        my($mapspec) = $ref->{'mapspec'};
        foreach my$sp (split(/,/, $mapspec)) {
            $map_spec{"$sp"} = 1;
        }
    }

    #
    my($cmd_spec_list) = ($cmdstr =~ /\-SPEC\=(\S+)/);
    my(%cmd_spec);
    foreach my$sp (split(',', $cmd_spec_list)) {
        $cmd_spec{"$sp"} = 1;
    }

    #
    foreach my$sp (@spec_list) {
        if (!exists($cmd_spec{"$sp"})) {
            next;
        }

        if (!exists($map_spec{"$sp"})) {
            return;
        }
    }

    return 1;
}

###############################################################################
#
sub get_spid_list_base_cluster {
    my($base_cluster_id) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    my($tab) = 'base_cluster_index';
    my($sql) = "select * from base_cluster_index where clusterID=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($base_cluster_id);

    if ($sth->rows() != 0) {
        my($ref) = $sth->fetchrow_hashref();
        my($spid) = $ref->{'spec'} || $ref->{'name'};
	if ($spid eq '') {
        	$spid = ($ref->{'cmd'} =~ /\-SPEC=(\S+)/i);
	}
        @spid_list = split(/\,/, $spid);
    }

    return @spid_list;
}

###############################################################################
#
sub get_cmd_mergetree {
    my($dc) = shift;
    my($base_cluster_id) = shift;
    my(@species) = @_;

    my($ch) = $dc->{'Cache'};

    #
    my($cmd_select) = $dc->makeInputStream(@species);
    my(%spec_all);
    foreach my$spec (@species) {
        $spec_all{"$spec"} = 1;
    }

    #
    my(@spec_list_base) = get_spid_list_base_cluster($base_cluster_id);
    foreach my$spec_base (@spec_list_base) {
        delete($spec_all{"$spec_base"});
    }
    my(@spec_new) = keys(%spec_all);

    #
    $cmd_select =~ s#\|\s*$##;
    $cmd_select .= "-mergetree -QSPEC=" . join(',', @spec_new);

    #
    my($cmd_domclust) = $dc->editStatement();
    my($cmd_mergetree) = $cmd_domclust;
    $cmd_mergetree =~ s#/domclust#/mergetree#;

    $cmd_mergetree .= " -baseClusterID=$base_cluster_id";

    return ($cmd_select, $cmd_mergetree);
}

###############################################################################
#
sub _exec_mergetree {
    my($db) = shift;
    my($dc) = shift;
    my($clusterID) = shift;
    my($origClusterID) = shift;
    my($base_cluster_id) = shift;
    my(@species) = @_;

    #
    my($pid) = $$;
    my($dir_work) = sprintf("%s/work", $ENV{'RECOG_HOME'});
    my($ch) = $dc->{'Cache'};
    my $res = $ch->updateRunningStatus($db, $clusterID, $pid);

    #
    my($cmd_select, $cmd_mergetree) = get_cmd_mergetree($dc, $base_cluster_id, @species);
    my($cmd_key) = "$cmd_select | $cmd_mergetree";
#    $ch->createIndex($db, $cmd_key, $clusterID, @species);

    my($file_mergetree_o11);
    if ($origClusterID) {
    	$file_mergetree_o11 = "$ENV{'MBGD_HOME'}/MBGD.tmp/mergetree_o11_$origClusterID";
    }

    #
    my($mapspec);
    my($file_mergetree_o1)  = "$ENV{'MBGD_HOME'}/MBGD.tmp/tmp_mergetree.o1";
    my($file_outputscore)   = "$dir_work/tmp_outputscore.$pid";
    my($file_taxmap_out)    = "$dir_work/tmp_tax_map_out.$pid";
    if ($cmd_mergetree =~ /\-OtaxMapSpec\=(\S+)/) {
        $mapspec = $1;
        $cmd_mergetree .= " -OtaxMapOut=$file_taxmap_out -OnoReplaceSpTreeLeafName ";
    }
#print STDERR "orig=$origClusterID; clustid=$clusterID; $file_mergetree_o11\n";

    if (! -s $file_mergetree_o11) {
#print STDERR "file $file_mergetree_o11 not exist\n";
    	# select
    	my($file_select_out) = "$dir_work/tmp_select.out.$pid";
    	print STDERR "LOG :: CMD(select) :: $cmd_select\n";
    	my($fh) = IO::File->new(">$dir_work/cmd.out");
    	$fh->print("CMD :: $cmd_select"); $fh->close();
	system("$cmd_select > $file_select_out");

    	# mergetree -o11
    	my($dir) = sprintf("%s/MBGD.tmp/base_cluster", $ENV{'MBGD_HOME'});
    	my($file_base_cluster) = "$dir/$base_cluster_id";

    	$file_mergetree_o11 = "$ENV{'MBGD_HOME'}/MBGD.tmp/mergetree_o11_$clusterID";
    	my($cmd)  = " $cmd_mergetree ";
    	$cmd =~ s# \-o1 ##;
    	$cmd .= " -o11 -OoutputScore=$file_outputscore $file_base_cluster $file_select_out ";
    	print STDERR "LOG :: CMD(mergetree_o11) :: $cmd\n";
    	system("$cmd > $file_mergetree_o11");
    }

    my($cmd) = " $cmd_mergetree ";
    $cmd =~ s# \-o1 ##;
    $cmd .= " -o1 -OoutputScore=$file_outputscore $file_mergetree_o11 ";
    print STDERR "LOG :: CMD(mergetree_o1) :: $cmd\n";
    system("$cmd > $file_mergetree_o1");

    my($cmd) = "$main::PROG_DOMCLUST_TREE2FLAT $file_mergetree_o1 > $file_mergetree_o1.flat";
    system("$cmd");

    my($specs) = join(',', @species);
    my($cmd) = "$main::PROG_DOMCLUST2SQL -dbname=$main::DOMCLUST_DB -tabid='domclust_cache_$clusterID' -spec=\'$specs\' -cmd=\'$cmd\' $file_mergetree_o1.flat";
    print STDERR "LOG :: CMD :: $cmd\n";
    system("$cmd");

    my($cmd) = "$main::PROG_DOMCLUST_TREE2MYSQL -DBNAME=$main::DOMCLUST_DB -TABID='$clusterID' $file_mergetree_o1";
    print STDERR "LOG :: CMD :: $cmd\n";
    system("$cmd");

    #
    createResultTableAndLoad($db, $clusterID, "$file_mergetree_o1.flat");

    main::load_cluster_score($db, $clusterID, $file_outputscore);
    main::load_taxmapout($db, $clustdumpid,
                              $clusterID,
                              $file_taxmap_out,
                              $mapspec);

    #
    my($file_tmp_domclust) = "$dir_work/tmp_domclust.$pid";
    my($ctbl) = RECOG::MBGD::ClusterTable->new();
    $ctbl->setSpecies(@species);
    $ctbl->setInGroup(@species);
#    $ctbl->setOutGroup(@$outsp);
    my($ch) = IO::File->new("$file_mergetree_o1.flat");
    while(my $line = $ch->getline()) {
        my $hcid;
        if($line =~ /^HomCluster +(\d+)/) {
            $hcid = $1;
        }
        elsif($line =~ /^Cluster +(\d+)/) {
            $cid = $1;                 # 饹ID
            $group = 'ingroup';        # 롼פingroupǥեȤ

            $count-- if(defined $count);
            last if($count < 0);
            $countCluster++;
        }
        elsif($line =~ /^SubCluster +(\d+)/) {
            $sid = $1;                 # ֥饹ID
        }
        elsif($line =~ /^OutGroup/) {
            $group = 'outgroup';       # 롼פoutgroupڤؤ
        }
        elsif($line =~ /^\s*$/) {      # Ԥϥå
            next;
        }
        elsif($line =~ /^(([a-z0-9]+):\S+)\s+(\d+)\s+(\d+)/i) {
            my $orf = $1;              # ξ
            my $sp  = $2;
            my $fm  = $3;
            my $to  = $4;

            # ingroup/outgroup ˳Ҿʪ¸롣
            $ctbl->setGeneInfo($sp,
                   $orf,
                   {'gene' => $orf, 'from' => $fm, 'to' => $to},
                   $cid, $hcid,
                   (defined $sid ? $sid : 1),
                   $group);
        }
    }
    my($tmpProgfile) = &RECOG::DomClust::createTmpfileName($clusterID,$main::PREF_DOMCLUST_PROG);
    $ctbl->addGeneInfoFuncLog($tmpProgfile, '', $clusterID);
    $ctbl->write($db,(
             file => $file_tmp_domclust,
             format => 'text',
             type => $type,
             clusterID => $clusterID));
    createFunctionTableAndLoad($db, "clust2sql_$clusterID", $file_tmp_domclust);

    #
    my($cmd) = "$main::CMD_create_clustxref_recog -DBNAME='$main::DOMCLUST_DB' -TABID='$clusterID'";
print STDERR "LOG :: CMD :: $cmd\n";
    system("$cmd");

    #
    unlink("$file_mergetree_o1");
    unlink("$file_mergetree_o1.flat");
    unlink("$file_select_out");


    my $optionlines = 'clusterID=' . $clusterID . " " .
                      'clusternum=' . $ctbl->getNumberOfCluster() . " " .
                      'spec='      . join(",", $ctbl->getSpecies()) . " " .
                      'ingroup='   . join(",", $ctbl->getInGroup()) . " " .
                      'outgroup='  . join(",", $ctbl->getOutGroup());
    uploadFinishStatus($db,$clusterID,$optionlines);

    return;
}

###############################################################################
sub exec_mergetree {
    my($qry) = shift;
    my($base_cluster_id) = shift;
    my($db) = shift;
    my($st) = shift;
    my($dc) = shift;

    #
    my($ch) = $dc->{'Cache'};

    # selectץμ
    my($refSelectOpt) = parseSelectOpt($qry);

    # DomClustץμ
    my($refDomclustOpt) = parseDomClustOpt($qry);
    my(%dc_opt) = %{$refDomclustOpt};

    # ingroup/outgroup Ȥƻꤵ줿ʪоʪȤƼ
    my $in_ref  = parseTargetSpecies($qry->param('ingroup'));
    my $out_ref = parseTargetSpecies($qry->param('outgroup'));

    #
#    my($base_cluster_id) = $qry->param('baseClusterID');
    my($format)          = $qry->param('output_format');
    my($type)            = $qry->param('output_type');
    my($optTaxMapSpec)   = $qry->param('taxMapSpec');
    my($origTabid)           = $qry->param('clusterID');
    my($useDomclustDump) = $qry->param('USE_DOMCLUST_DUMP');
    my($besthit)         = $qry->param('besthit');

    #
    if ($origTabid && $optTaxMapSpec) {
            #
            $in_ref  = {};
            $out_ref = {};
            $refSelectOpt = {};
            %dc_opt = ();
            @species = RECOG::RecogCommon::rebuild_domclust_options($db, $origTabid, $refSelectOpt, \%dc_opt);
            $dc_opt{'-OtaxMapSpec'} = $optTaxMapSpec;

            @outg = split(/,/, $dc_opt{'-Ooutgroup'});
            foreach my$sp (@outg) {
                $out_ref->{"$sp"} = 1;
            }

            foreach my$sp (@species) {
                if ($out_ref->{"$sp"}) {
                    next;
                }
                $in_ref->{"$sp"} = 1;
            }
    }


    #
    my $tax = MBGD::Taxonomy->new();

    # оʪϿå
    check_species($tax, $mode_no_exec, keys(%{$out_ref}), keys(%{$in_ref}));

    # ꤵ줿ʪ Taxonomy ¤ؤ
    my @outg = $tax->sortByTaxonomy(keys(%{$out_ref}));
    my @ing  = $tax->sortByTaxonomy(keys(%{$in_ref}));

    # mergetree  outgroup ̤б꤬硢顼Ȥ
    if (scalar(@outg) != 0) {
        my($msg) = "Can not use out-group in this mode.";
        if($qry->param('output_format') eq 'html') {
            $st->outputError('90', $msg);
        } else {
            $st->outputError_txt('90', $msg);
        }
        exit(0);
    }

    # outgroup λ꤬硢ingroupʪȽʣޡԤ
    my($spec_ref) = { %{$in_ref}, %{$out_ref} };
    my(@species) = $tax->sortByTaxonomy(keys(%{$spec_ref}));
#    if(@outg) {
#        # outgroupꥪץ
#        $dc_opt{'-O'} = sprintf("outgroup=%s", join(',', @outg));
#    }

    #
    my($conf_recog_ref) = RECOG::RecogCommon::read_recog_conf();
    my($max_species) = $conf_recog_ref->{'max-species-mergetree'} || $conf_recog_ref->{'max-species-domclust'};
#    my($max_species) = $conf_recog_ref->{'max-species-domclust'};
#    if ($besthit eq 'bidirec') {
#        $max_species = $conf_recog_ref->{'max-species-domclust-bidirec'};
#    }
#    elsif ($besthit eq 'unidirec') {
#        $max_species = $conf_recog_ref->{'max-species-domclust-unidirec'};
#    }
    my($n_selected_species) = scalar(@species);
    if ($max_species < $n_selected_species) {
        # 򤵤줿ʪ¥С
        print STDERR "LOG :: Too many species are selected.($max_species < $n_selected_species)\n";
        if($qry->param('output_format') eq 'html') {
            $st->outputError('4', $n_selected_species, $max_species);
        } else {
            $st->outputError_txt('4', $n_selected_species, $max_species);
        }
        exit(0);
    }

    $dc->setOptionSelect($refSelectOpt);
    $dc->setOption(%dc_opt);
    my($cmd_select, $cmd_mergetree) = get_cmd_mergetree($dc, $base_cluster_id, @species);
    my($cmd_key) = "$cmd_select | $cmd_mergetree";
    my($ret_stat) = $ch->createIndex($db, $cmd_key, $clusterID, @species);

    #
    my($clusterID) = $ch->getTabId($db, $cmd_key);
    my($sts) = 0;
    if ($ret_stat) {
    	$sts = $ch->getStatus($db, $clusterID);
    }

    print STDERR "LOG :: getCacheStatus: status=$sts; clusterID=$clusterID; origClusterID=$origTabid; cmd: $cmd_key\n";

    if (!$sts) {
        # ̤¹
    }
    elsif ($sts == -1) {
        # ¹ԺѤ
	## come here when the process has been finished
        my $header = $st->clusterIDtoInfo($db, $clusterID);
print STDERR ">>>$sts; $db, $type, $clusterID, $header, $format\n";
        if($format eq 'o11') {
            $st->write_o11($db, $type, $clusterID, $header, $mode_get_status);
        }
        elsif($format eq 'list') {
            $st->write_list($db, $type, $clusterID, $header);
        }
        elsif($format eq 'html') {
            $st->write_html($db, $type, $clusterID, $header);
        }
        else { # if($format eq 'text') {
print STDERR "format=$format\n";
            $st->write_text($db, $type, $clusterID, $header);
        }
        exit;
    }
    elsif ($sts == -99) {
        if($format eq 'html') {
            $st->outputError('-99', $clusterID);
        }
        else {
            $st->outputError_txt('-99',$clusterID);
        }
        exit;
    }
    else {
        # ˼¹椫ɤĴ
        if(isRunning($sts)) {
            if($format eq 'html') {
                $st->runTabID($db, $clusterID, $type);
            } else { #if($format eq 'text') {
                $st->runTabID_txt($db,$clusterID, $type);
            }
            exit;
	}
	## the job seems to has been prematurely terminated; ignore and re-execute it.
    }

    # ̤¹
    my($pid) = fork();
    if ($pid) {
		if($format eq 'html') {
			$st->runTabID($db, $clusterID, $type);
		} else { #if($format eq 'text') {
			$st->runTabID_txt($db, $clusterID, $type);
		}
		close(STDOUT);
		close(STDERR);
    }
    elsif (defined($pid)) {
        close(STDOUT);
        close(STDERR);
        if ($main::SAVE_log) {
		&open_log;
	}

        # ¹
        _exec_mergetree($db, $dc, $clusterID, $origTabid, $base_cluster_id, @species);
        exit(0);
    }
    else {
    }

    exit(0);

    return;
}
sub open_log {
        my($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
        $year += 1900;
        $mon++;
        my($date) = sprintf("%04d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
        $main::SAVE_log = "$ENV{'MBGD_HOME'}/WWW/logs/tmplog_domclust_$ENV{'SERVER_NAME'}.$date";
        open(STDERR, ">>$main::SAVE_log");
	select(STDERR);
	$| = 1;
}

###############################################################################
my $qry = defined($ENV{'REQUEST_METHOD'}) ? new CGI
                                          : new CGI('DATA'); # test

my $db = new MBGD::DB($main::DOMCLUST_DB);
my $st = new RECOG::MBGD::OutputDomClust;

my $dc = new RECOG::MBGD::DomClust(driver => 'mysql', space => (defined($ENV{'REQUEST_METHOD'}) ? $DIR_tmp : '/tmp'));

$dc->setProgFname("$main::PROG_DOMCLUST");

my ($fm, $no);  # $fm => ɽϥ饹ID, $no => ɽ饹

if ($main::DEBUG) {
    print STDERR "LOG :: ### QUERY ###\n";
    my(@key_list) = $qry->param();
    foreach my$key (sort @key_list) {
        my($val) = $qry->param($key);
        print STDERR "LOG :: $key :: $val\n";
    }
}

#
my($mode_no_exec) = $qry->param('NO_EXEC');
my($base_cluster_id) = $qry->param('baseClusterID');
if (!$base_cluster_id) {
    my($cluster_id) = $qry->param('clusterID');
    $base_cluster_id = RecogProjectCommon::get_baseClusterID_by_clusterID($cluster_id);
}
if ($base_cluster_id) {
    exec_mergetree($qry, $base_cluster_id, $db, $st, $dc);
    exit(0);
}

# selectץμ
my $refSelectOpt = parseSelectOpt($qry);

# DomClustץμ
my $refDomclustOpt = parseDomClustOpt($qry);
my %dc_opt = %{$refDomclustOpt};

# ץgetWarningsޤޤ줪ꡢ1ʾξ
# WARNINGƤɽ
if($qry->param('getWarnings')) {
	printWarnings($db, $st, $qry->param('clusterID'), $qry->param('output_format'));
	exit;
}

# ingroup/outgroup Ȥƻꤵ줿ʪоʪȤƼ
my $in_ref = parseTargetSpecies($qry->param('ingroup'));
my $out_ref = parseTargetSpecies($qry->param('outgroup'));

#
my $tax = MBGD::Taxonomy->new();

# оʪϿå
check_species($tax, $mode_no_exec, keys(%{$out_ref}), keys(%{$in_ref}));

# ꤵ줿ʪ Taxonomy ¤ؤ
my @outg = $tax->sortByTaxonomy(keys(%{$out_ref}));
my @ing  = $tax->sortByTaxonomy(keys(%{$in_ref})); 

# outgroup λ꤬硢ingroupʪȽʣޡԤ
my $spec_ref = { %{$in_ref}, %{$out_ref} };
my @species = $tax->sortByTaxonomy(keys(%{$spec_ref})); 
if(@outg) {
    # outgroupꥪץ
	$dc_opt{'-O'} = sprintf("outgroup=%s", join(',', @outg));
}

#
my $besthit = $qry->param('besthit');
my($conf_recog_ref) = RECOG::RecogCommon::read_recog_conf();
my($max_species) = $conf_recog_ref->{'max-species-domclust'};
if ($besthit eq 'bidirec') {
    $max_species = $conf_recog_ref->{'max-species-domclust-bidirec'};
}
elsif ($besthit eq 'unidirec') {
    $max_species = $conf_recog_ref->{'max-species-domclust-unidirec'};
}
my($n_selected_species) = scalar(@species);
if ($max_species < $n_selected_species) {
    # 򤵤줿ʪ¥С
    print STDERR "LOG :: Too many species are selected.($max_species < $n_selected_species)\n";
    if($qry->param('output_format') eq 'html') {
        $st->outputError('4', $n_selected_species, $max_species);
    } else {
        $st->outputError_txt('4', $n_selected_species, $max_species);
    }
    exit(0);
}

my $format = $qry->param('output_format');
my $type = $qry->param('output_type');
my $mode_get_status = $qry->param('GET_STATUS_ONLY');
my $optTaxMapSpec = $qry->param('taxMapSpec');
my $tabid = $qry->param('clusterID');
my($useDomclustDump) = $qry->param('USE_DOMCLUST_DUMP');

# tabIDä硢domclustϼ¹ԤƤ롣ơ֥ID֤Ĵ٤
if ($tabid && $optTaxMapSpec) {
    # 饹󥰷̤¸ߤ뤫
    my($status) = getStatus($db, $tabid);
    if ($status == -1) { # ¹Խλ
        # б taxmap ̤¸ߤ뤫
        my($sta_map) = exists_taxdump($db, $tabid, split(/,/, $optTaxMapSpec));
        if (!$sta_map) {
            # domclust Ƽ¹Ԥ taxmap 

            #
            $refSelectOpt = {};
            %dc_opt = ();
            @species = RECOG::RecogCommon::rebuild_domclust_options($db, $tabid, $refSelectOpt, \%dc_opt);
            $dc_opt{'-OtaxMapSpec'} = $optTaxMapSpec;

            @outg = split(/,/, $dc_opt{'-Ooutgroup'});
            my(%outg_hash);
            foreach my$sp (@outg) {
                $outg_hash{"$sp"} = 1;
            }

            @ing = ();
            foreach my$sp (@species) {
                if ($outg_hash{"$sp"}) {
                    next;
                }
                push(@ing, $sp);
            }

            $main::SAVE_args{'tabid'} = $tabid;
            $tabid = undef();
        }
    }
}
if($tabid) {
    printDomClustStatus($db, $st, $tabid, $format, $type, $mode_get_status);

    # ¹ or ¹Է̤¸ߤ or IDꤵ줿ϡˤϤɤ夫ʤ
    # DomClust 顼Ȥʤä硢ʹߤνԤ

    if (length($tabid) > 0) {
        my($force) = $qry->param('FORCE');
        if (!$force) {
            if($format eq 'html') {
                $st->outputError('1',$tabid);
            } else {
                $st->outputError_txt('1',$tabid);
            }
			exit;
        }

        # else :: $tabid Ѥϼ¹
    }
}

$ck_in=0;
my %outh;
foreach my $s (@outg) {
	$outh{$s}++;
}
foreach my $s (grep length($_), @ing) {
	if(!exists $outh{$s}) {
		$ck_in++;
	}
}
if($ck_in < 1) { # ingroupޤäʤ硢顼Фƽλ
	if($format eq 'html') {
		$st->outputError('2');
	} else {
		$st->outputError_txt('2', $type);
	}
	exit;
}


$dc->setOptionSelect($refSelectOpt);
$dc->setOption(%dc_opt);     # ưץ
my $cmd = $dc->makeInputStream(@species);
$cmd   .= $dc->editStatement();

# $ch : Class RECOG::Cache::mysql
my $ch = $dc->{'Cache'};
$ch->setUseDomclustDump($useDomclustDump);

my $clusterID;
my($ret_stat) = $ch->createIndex($db, $cmd, $tabid, @species);
$clusterID = $ch->getTabId($db, $cmd);

$sts = $ch->getStatus($db,$clusterID);

if(!$sts) {
	# 줫¹Ԥ($sts=0)
}
elsif (($sts == -1) && ($main::SAVE_args{'tabid'})) {  # domclust ϼ¹ԺѤmapping ̵̤
	# Ƽ¹Ԥ
}
elsif($sts == -1) {  # ¹Ժ
#    my $header = getHeaderInfo($db, $clusterID);
    my $header = $st->clusterIDtoInfo($db, $clusterID);
    if($format eq 'o11') {
        $st->write_o11($db, $type, $clusterID, $header, $mode_get_status);
    }
    elsif($format eq 'list') {
        $st->write_list($db, $type, $clusterID, $header);
    }
    elsif($format eq 'html') {
        $st->write_html($db, $type, $clusterID, $header);
    }
    else { # if($format eq 'text') {
        $st->write_text($db, $type, $clusterID, $header);
    }
    exit;
}
elsif($sts == -99) { # ¹ԥ顼
    if($format eq 'html') {
        $st->outputError('-99', $clusterID);
    } else {
        $st->outputError_txt('-99',$clusterID);
    }
	exit;
}
else { # ¹?
	# ˼¹椫ɤĴ
	if(isRunning($sts)) {
		if($format eq 'html') {
			$st->runTabID($db, $clusterID, $type);
		} else { #if($format eq 'text') {
			$st->runTabID_txt($db,$clusterID, $type);
		}
		exit;
	}
	else { # status0ˤdomclust¹Ԥ롣ΤȤȤUP롣
		# retryμ¹Բ°ʤȥ饤
#		if(canRetry($db,$clusterID)) {
#			uploadRetryStatus($db, $clusterID);
#		} else {
#			addRetryCountOver($db, $clusterID);
#			if($format eq 'html') {
#				$st->outputError(3, $clusterID);
#			} else {
#				$st->outputError_txt(3, $clusterID);
#			}
#			exit;
#		}
	}
}

print "";
FORK: {
	$pid = fork();
	$db = new MBGD::DB($main::DOMCLUST_DB, {'new' => 1}); # FORK˺ƥ
	if($pid) {
		if($format eq 'html') {
			$st->runTabID($db, $clusterID, $type);
		} else { #if($format eq 'text') 
			$st->runTabID_txt($db, $clusterID, $type);
		}
		close(STDOUT);
		close(STDERR);

	} elsif (defined $pid) {
		close(STDOUT);
		close(STDERR);

        #
        if ($main::SAVE_log) {
	    &open_log;
#            my($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
#            $year += 1900;
#            $mon++;
#            my($date) = sprintf("%04d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
#            $main::SAVE_log = "$ENV{'MBGD_HOME'}/WWW/logs/tmplog_domclust_$ENV{'SERVER_NAME'}.$date";
#            open(STDERR, ">>$main::SAVE_log");
#            select(STDERR);
#            $| = 1;
        }

        # sigterm 򤦤Ȥν
        setupSigTermFunctionForLocal();
		my $res = $ch->updateRunningStatus($db, $clusterID, $$);
        if(!$res) {
            updateErrorStatus($db, $clusterID);
            exit;
        }
		my $t = scalar(localtime);
		print STDERR "########### DBG :: START domclust : " . scalar(localtime) . "\n";
		my $res = $dc->exec($db,@species);         # DomClust¹
 		print STDERR "########### DBG :: Done  domclust : " . scalar(localtime) . "\n";

        if (-e "$dc_opt{'-t'}") {
            # domclust ϥե taxonlevel 
            unlink("$dc_opt{'-t'}");
        }

		# ¹ԥ顼ξ硢顼ơϿƽλ롣
		if(!$res) {
    		print STDERR "########### DBG :: Found  domclust error : " . scalar(localtime) . "\n";
			updateErrorStatus($db,$clusterID);
			exit;
		}
		# domclustwarningФƤDBwarningϿ
		if(-s $dc->{'TmpErrorfile'}) {
    		print STDERR "########### DBG :: Update  domclust warnings : " . scalar(localtime) . "\n";
			uploadWarnings($db,$clusterID,$dc->{'TmpErrorfile'});
		}
		$t = scalar(localtime);
		print STDERR "########### test exec domclust end   : $t";

        # 饹ơ֥ȤƼ롣
		my $ctbl;
		$t = scalar(localtime);
		print STDERR "########### test make clustertable start : $t\n";
		$ctbl = $dc->getClusterTableOpt($fm, $no, "", \@ing, \@outg, \@species);  # ϰϤΥ饹
		# 饹DBϿ
		my $cluster_Count = $dc->{'ClusterCount'};
		uploadNdomclust($db,$clusterID,$cluster_Count);

		$t = scalar(localtime);
		print STDERR "########### test make clustertable end   : $t\n";

		$t = scalar(localtime);
		print STDERR "########### test add gene info start : $t\n";
		if(! existsFuncColumn($db,$clusterID) ) {
			$ctbl->addGeneInfoFuncLog($dc->{'TmpProgfile'}, '', $clusterID);
		} else {
			print STDERR "########### skip\n";
		}
		$t = scalar(localtime);
		print STDERR "########### test add gene info end   : $t\n";

        # domclustμ¹Է̤ϿƤʤ硢mysql¸롣#########################
		if(! existsResultColumn($db,$clusterID) ) {
		$t = scalar(localtime);
			print STDERR "########### create cluster_result_table start. :: $t\n";
			my $cfile = $dc->{'Cache'}->{'CacheFile'};
			createResultTableAndLoad($db,$clusterID,$cfile);
		$t = scalar(localtime);
			print STDERR "########### create cluster_result_table end. :: $t\n";
		}

		if(! existsFuncColumn($db,$clusterID) ) {
            $t = scalar(localtime);
			print STDERR "########### create cluster_func_clust2sql_table start. :: $t\n";
			my $tmpfile = $DOMCLUST_TMP_DIR . "/tmp_domclust_$$.txt";
			$ctbl->write($db,(
             file => $tmpfile,
             format => 'text',
             type => $type,
             clusterID => $clusterID));

		$t = scalar(localtime);
            print STDERR "########### create cluster_func_clust2sql_table load. :: $t\n";
            createFunctionTableAndLoad($db,"clust2sql_$clusterID",$tmpfile);
##            unlink($tmpfile);
            $t = scalar(localtime);
            print STDERR "########### create cluster_func_clust2sql_table end. :: $t\n";

            my($cmd) = "$main::CMD_create_clustxref_recog -DBNAME='$main::DOMCLUST_DB' -TABID='$clusterID'";
            system("$cmd");

        }
        my $optionlines = 'clusterID=' . $clusterID . " " .
                          'clusternum=' . $ctbl->getNumberOfCluster() . " " .
                          'spec='      . join(",", $ctbl->getSpecies()) . " " .
                          'ingroup='   . join(",", $ctbl->getInGroup()) . " " .
                          'outgroup='  . join(",", $ctbl->getOutGroup());
        uploadFinishStatus($db,$clusterID,$optionlines);

        #
        if ($main::SAVE_log) {
            if (-e "$main::SAVE_log") {
                # 顼̵Ͻλ  եκ
#                unlink($main::SAVE_log);
            }
        }
		$t = scalar(localtime);
        print STDERR "########### All done. :: $t\n";

		exit;
	} elsif ( $! =~ /No more process/) {
		sleep 5;
		redo FORK;
	} else {
        # 뤳ȤϤʤ
		die "Can't fork: $\n";
    }
} # End Of Label:FORK

exit

__END__

getWarnings=1175220509_18029
ingroup=eco
ingroup=bar
ingroup=bat
ingroup=bca
ingroup=bce
