#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub print_cluster_text {
    my($db) = shift;
    my($ref) = shift;

    #
    my($clust_id) = $ref->{'clusterID'};
    if ($clust_id eq 'addspec') {
        return;
    }

    #
    my($clust_ymd, $clust_hms) = split(/\s/, $ref->{'cdate'});
    my($clust_date) = $clust_ymd . ' ' . $clust_hms;

    #
    my($status) = 'finished';
    if ($ref->{'status'} == 0) {
        $status = 'error';
        return;
    }
    elsif (0 < $ref->{'status'}) {
        $status = 'running';
        return;
    }

    #
    my($file_o11) = "$ENV{'RECOG_HOME'}/MBGD.tmp/tmp_dom_res_$clust_id.o11";
    if (! -e "$file_o11") {
        return;
    }

    #
    my($n_clusters) = $ref->{'ncluster'};

    #
    my($cmd) = $ref->{'cmd'};

    my(%opt_clust1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
    my($opt_clust1) = '';
    foreach my$k (sort keys(%opt_clust1)) {
        my($v) = $opt_clust1{"$k"};
        $opt_clust1 .= "$k=$v ";
    }

    my(%opt_clust2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
    my($opt_clust2) = '';
    foreach my$k (sort keys(%opt_clust2)) {
        next if ($k =~ /\-tabout/);

        my($v) = $opt_clust2{"$k"};
        $opt_clust2 .= "$k$v ";
    }

    my($opt_clust) = $opt_clust1 . $opt_clust2;

    print $clust_id,   "\t";
#    print $status,     "\t";
    print $clust_date, "\t";
#    print $n_clusters, "\t";
    print $opt_clust,  "\t";
    print "\n";

    return;
}

###############################################################################
#
sub print_cluster_phylopat_html {
    my($db) = shift;
    my($clust_id) = shift;

    #
    my($tab) = 'cluster_tables_idx_phylopat';
    my($refCoreRes);
    if ($db->exist_table($tab)) {
        my($opt) = {};
        $opt->{'where'} = "clust_tab_id='$clust_id'";
        $opt->{'order'} = 'cdate';
        $refCoreRes = eval { $db->select_fetch($tab, $opt); };
    }
    if ($refCoreRes->{'ROWS'} == 0) {            
        print "    <td nowrap>No data</td>\n";
    }
    else {
        print "    <td>";
        print "<a href=\"/htbin/RECOG/list_phylopat.cgi?id_cluster=$clust_id\">List</a>";
        print "    </td>\n";
    }

    return;
}

###############################################################################
#
sub print_cluster_core_html {
    my($db) = shift;
    my($clust_id) = shift;

    #
    my($tab) = 'core_tables_idx';
    my($refCoreRes);
    if ($db->exist_table($tab)) {
        my($opt) = {};
        $opt->{'where'} = "clust_tab_id='$clust_id'";
        $opt->{'order'} = 'cdate';
        $refCoreRes = eval { $db->select_fetch($tab, $opt); };
    }
    if ($refCoreRes->{'ROWS'} == 0) {            
        print "    <td nowrap>No data</td>\n";
    }
    else {
        print "    <td>";
        print "<a href=\"/htbin/RECOG/list_core.cgi?id_cluster=$clust_id\">List</a>";
        print "    </td>\n";
    }

    return;
}

###############################################################################
#
sub print_cluster_head_html {

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "<script>\n";
    print "function deleteCluster(id) {\n";
    print "  var sta = confirm('Delete this cluster?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_clust.clust_id.value = id;\n";
    print "  doc.frm_del_clust.action = '/htbin/RECOG/delete_cluster.cgi';\n";
    print "  doc.frm_del_clust.submit();\n";
    print "}\n";

    print "function deleteAllClusters() {\n";
    print "  var sta = confirm('Delete all clustering output?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "  doc.frm_del_clust.all.value= 1;\n";
    print "  doc.frm_del_clust.action = '/htbin/RECOG/delete_cluster.cgi';\n";
    print "  doc.frm_del_clust.submit();\n";
    print "}\n";

    print "function killCluster(id) {\n";
    print "  var sta = confirm('Kill this clustering job?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_clust.clust_id.value = id;\n";
    print "  doc.frm_del_clust.action = '/htbin/RECOG/kill_cluster.cgi';\n";
    print "  doc.frm_del_clust.submit();\n";
    print "}\n";
    print "</script>\n";
    print "</head>\n";

    return;
}

###############################################################################
#
sub print_cluster_foot_html {

    print "</table>\n";
    print "</form>\n";

    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
#
sub print_cluster_html {
    my($db) = shift;
    my($ref) = shift;

    #
    my($clust_id) = $ref->{'clusterID'};

    #
    my($clust_ymd, $clust_hms) = split(/\s/, $ref->{'cdate'});
    my($clust_date) = $clust_ymd . '<br>' . $clust_hms;

    #
    my($status) = 'finished';
    if ($ref->{'status'} == 0) {
        $status = 'error';
    }
    elsif (0 < $ref->{'status'}) {
        $status = 'running';
    }

    #
    my($n_clusters) = $ref->{'ncluster'};
    while($n_clusters =~ s#(\d+)(\d{3})#$1,$2#) {}

    #
    my($cmd) = $ref->{'cmd'};

    my(%opt_clust1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
    my($opt_clust1) = '';
    foreach my$k (sort keys(%opt_clust1)) {
        my($v) = $opt_clust1{"$k"};
        $opt_clust1 .= "$k=$v<br>\n";
    }

    my(%opt_clust2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
    my($opt_clust2) = '';
    foreach my$k (sort keys(%opt_clust2)) {
        next if ($k =~ /\-tabout/);

        my($v) = $opt_clust2{"$k"};
        $opt_clust2 .= " , " if ($opt_clust2 ne '');
        $opt_clust2 .= "$k$v\n";
    }

    my($opt_clust) = $opt_clust1 . $opt_clust2;

    print "<tr><td>";
    if ($status =~ /^finished/i) {
        print "<input type=\"button\" value=\"Del\" onclick=\"deleteCluster('$clust_id');\">\n";
    }
    else {
        print "<input type=\"button\" value=\"Kill\" onclick=\"killCluster('$clust_id');\">\n";
    }
    print "    </td>\n";
    print "    <td nowrap>$clust_id</td>\n";
    print "    <td nowrap>$status</td>\n";
    print "    <td align=\"center\" nowrap>$clust_date</td>\n";
    print "    <td align=\"right\" nowrap>$n_clusters</td>\n";
    print "    <td nowrap>$opt_clust</td>\n";

    print_cluster_core_html($db, $clust_id);
    print_cluster_phylopat_html($db, $clust_id);

    print "\n";
    print "</tr>\n";

    return;
}

###############################################################################
#
sub list_cluster {
    my($form_opt) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    my($tab) = 'cluster_tables_idx';
    my($opt) = {};
    $opt->{'order'} = 'cdate';
    my($refRes) = eval { $db->select_fetch($tab, $opt); };

    #
    my($mode) = $form_opt->{'mode'};
    if ($mode =~ /^text$/i) {
        print "Content-type: text/plain\n";
        print "\n";
    }
    else {
        print "Content-type: text/html\n";
        print "\n";
        print_cluster_head_html();

        print "<body>\n";
        if ($refRes->{'ROWS'} == 0) {
            print "<h1>No cluster</h1>\n";
        }
        else {
            print "<h1>Cluster(s)</h1>\n";
            print "<form name=\"frm_del_clust\" method=\"post\" action=\"/htbin/RECOG/delete_cluster.cgi\">\n";

            print "<input type=\"hidden\" name=\"clust_id\" value=\"\">\n";
            print "<input type=\"hidden\" name=\"all\" value=\"\">\n";
            print "<input type=\"button\" value=\"Clear All Results\" onclick=\"deleteAllClusters();\">\n";
            print "<table border>\n";
            print "<tr><th></th>\n";
            print "    <th nowrap>Cluster ID</th>\n";
            print "    <th nowrap>Status</th>\n";
            print "    <th nowrap>Date</th>\n";
            print "    <th nowrap>clusters</th>\n";
            print "    <th nowrap>Parameter(s)</th>\n";
            print "    <th nowrap>Core</th>\n";
            print "    <th nowrap>Phylopat</th>\n";
            print "</tr>\n";
        }
    }

    foreach my$ref (@{$refRes->{'INFO'}}) {

        if ($mode =~ /^text$/i) {
            print_cluster_text($db, $ref);
        }
        else {
            print_cluster_html($db, $ref);
        }

    }
    print_cluster_foot_html();

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    my($cgi) = CGI->new();

    #
    my(@key_list) = ('mode');

    #
    my($form_opt) = {};
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    list_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
