#!/usr/bin/perl -s
use strict;
use MBGD;
use MBGD::WWW;
use RECOG::RecogCommon;

###############################################################################
#
sub list_cluster_gene {
    my($www) = shift;

    my(%args) = $www->cgiGetArgs();
    my($tabid)  = ($args{'tabid'} =~ /^(\d+\_\d+)$/);

    my($spname_ref) = $args{'spname'};
    my(@spname_list) = ($spname_ref =~ /([a-z0-9\_]+\:[a-z0-9\_\-\.]+)/ig);
    if (ref($spname_ref)) {
        @spname_list = ();
        foreach my$spname_wk (@{$spname_ref}) {
            foreach my$spname (split(/,/, $spname_wk)) {
                push(@spname_list, ($spname =~ /^([a-z0-9\_]+\:[a-z0-9\_\-\.]+)$/i));
            }
        }
    }

    #
    my(%html_opt) = ();
    $html_opt{-style} = {src=>['/css/mbgd.css', '/css/mbgd_button.css']};
    $html_opt{-script} = {src=>'/js/mbgd.js'};
    $html_opt{-title} = "Orthologous clusters";

    #
    $www->start_html(%html_opt);
    print "<h1>Orthologous clusters</h1>";


    #
    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    #
    my($tabname) = 'cluster_tables_idx';
    my($sql) = "select * from $tabname where clusterID='$tabid'";
    my($sth) = $db->execute($sql);
    my($ref) = $sth->fetchrow_hashref();
    my($spec_list) = ($ref->{'cmd'} =~ /\-SPEC\=(\S+)/);



    #
    my($where_spname) = '';
    foreach my$spname (@spname_list) {
        if ($spname =~ /[^a-z0-9\_\-\:\.]/i) {
            next;
        }

        $where_spname .= ',' if ($where_spname ne '');
        $where_spname .= "'$spname'";
    }

    #
    my($tabname) = "cluster_domclust_cache_$tabid c, cluster_func_clust2sql_$tabid f";
    my($cols) = "c.spname cspname, c.subclustid csubclustid, f.clustid fclustid, f.subclustid fsubclustid, f.phylopat phylopat, f.spnum fspnum, f.orfnum forfnum, f.cdescr fcdescr";
    my($sql) = "select $cols from $tabname";
    if ($where_spname ne '') {
        $sql .= " where c.spname in($where_spname)"
                  . " and "
                  . " c.clustid=f.clustid ";
#                  . " and "
#                  . " c.subclustid=f.subclustid ";
    }
    $sql .= " group by f.clustid, f.subclustid";
    $sql .= " order by f.clustid, f.subclustid";
#print STDERR "SQL :: $sql\n";

    #
    my($sth) = $db->execute($sql);
    my($n_row) = $sth->rows();
    if ($n_row == 0) {
        print "No clusters found.";
        return;
    }

    print "<form>\n";
    print "<input type=\"checkbox\" name=\"\" value=\"\">Display ORF names\n";
    print "<input type=\"submit\" value=\"Redraw\">\n";
    print "<input type=\"hidden\" name=\"tabid\" value=\"$tabid\">\n";
    my($spname_list) = join(',', @spname_list);
    print "<input type=\"hidden\" name=\"spname\" value=\"$spname_list\">\n";
    print "<table border>\n";
    print "<tr>";
    print "<th>Cluster ID</th>";
    print "<th>SubCluster ID</th>";
    print "<th># of species</th>";
    print "<th># of orf</th>";
    print "<th>Description</th>";
    print "<th>Phylogenetic pattern</th>";
    print "</tr>";
    while (my$ref=$sth->fetchrow_hashref()) {
        if (($ref->{'csubclustid'} != 0)
         && ($ref->{'csubclustid'} != $ref->{'fsubclustid'})) {
            next;
        }
        my($pat) = $ref->{'phylopat'};

        my($clustid) = $ref->{'fclustid'};
        my($path_cgi) = "/htbin/RECOG/hcluster?prog=hcluster&clustid=$clustid&tabid=$tabid";
        print "<tr>";
#        print "<td>", $ref->{'cspname'}, "</td>";
#        print "<td>", $ref->{'csubclustid'}, "</td>";

        print "<td align=\"right\"><a href=\"$path_cgi\">", $ref->{'fclustid'}, "</a></td>";
        print "<td align=\"right\">", $ref->{'fsubclustid'}, "</td>";
        print "<td align=\"right\">", $ref->{'fspnum'}, "</td>";
        print "<td align=\"right\">", $ref->{'forfnum'}, "</td>";
        print "<td>", $ref->{'fcdescr'}, "</td>";
        print "<td><img src=\"/htbin/create_phylopat_gif?phylopat=$pat\"></td>\n";
        print "</tr>\n";
    }
    print "</table>\n";
    print "</form>";

    return;
}

###############################################################################

if ($0 eq __FILE__) {
    my($www) = MBGD::WWW->new();


    list_cluster_gene($www);
}

1;#
