#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub list_phylopat_res {
    my($id_cluster) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    my($tab) = 'cluster_tables_idx_phylopat';
    my($opt) = {};
    if ($id_cluster) {
        $opt->{'where'} = "clust_tab_id ='$id_cluster'";
    }
    $opt->{'order'} = 'cdate';
    my($refRes) = eval { $db->select_fetch($tab, $opt); };

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "<script>\n";
    print "function deletePhylopat(id) {\n";
    print "  var sta = confirm('Delete this phylopat?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_phylopat.id_phylopat.value = id;\n";
    print "  doc.frm_del_phylopat.action = '/htbin/RECOG/delete_phylopat.cgi';\n";
    print "  doc.frm_del_phylopat.submit();\n";
    print "}\n";
    print "</script>\n";
    print "</head>\n";

    print "<body>\n";
    if ($refRes->{'ROWS'} == 0) {
        print "<h1>No phylopat result</h1>\n";
    }
    else {
        print "<h1>Phlopat result(s)</h1>\n";
        print "<form name=\"frm_del_phylopat\" method=\"post\" action=\"/htbin/RECOG/delete_phylopat.cgi\">\n";
        print "<input type=\"hidden\" name=\"id_phylopat\" value=\"\">\n";
        print "<table border>\n";
        print "<tr><th></th>\n";
        print "    <th nowrap>Phylopat ID</th>\n";
        print "    <th nowrap>Status</th>\n";
        print "    <th nowrap>Date</th>\n";
        print "    <th nowrap>Parameter(s)</th>\n";
        print "</tr>\n";

        foreach my$ref (@{$refRes->{'INFO'}}) {
            #
            my($phylopat_id) = $ref->{'clust_tab_id'};

            #
            my($phylopat_ymd, $phylopat_hms) = split(/\s/, $ref->{'cdate'});
            my($phylopat_date) = $phylopat_ymd . '<br>' . $phylopat_hms;

            #
            my($status) = 'finished';
            if ($ref->{'status'} == 0) {
                $status = 'error';
            }
            elsif (0 < $ref->{'status'}) {
                $status = 'running';
            }

            #
            my($cmd) = $ref->{'cmd'};

            my(%opt_phylopat1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
            my($opt_phylopat1) = '';
            foreach my$k (sort keys(%opt_phylopat1)) {
                next if ($k =~ /\-DIR_WORK/);

                my($v) = $opt_phylopat1{"$k"};
                $opt_phylopat1 .= "$k=$v<br>\n";
            }

            my(%opt_phylopat2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
            my($opt_phylopat2) = '';
            foreach my$k (sort keys(%opt_phylopat2)) {
                my($v) = $opt_phylopat2{"$k"};
                $opt_phylopat2 .= " , " if ($opt_phylopat2 ne '');
                $opt_phylopat2 .= "$k$v\n";
            }

            my($opt_phylopat) = $opt_phylopat1 . $opt_phylopat2;

            print "<tr><td>";
            if ($status =~ /^finished/i) {
                print "<input type=\"button\" value=\"Del\" onclick=\"deletePhylopat('$phylopat_id');\">\n";
            }
            print "    </td>\n";
            print "    <td nowrap>$phylopat_id</td>\n";
            print "    <td nowrap>$status</td>\n";
            print "    <td align=\"center\" nowrap>$phylopat_date</td>\n";
            print "    <td nowrap>$opt_phylopat</td>\n";
            print "\n";
            print "</tr>\n";
        }
        print "</table>\n";
        print "</form>\n";
    }
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($id_cluster) = $cgi->param('id_cluster');

    list_phylopat_res($id_cluster);
}

###############################################################################
1;#
###############################################################################
