#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use FileHandle;

###############################################################################
if ($0 eq __FILE__) {
    my($max_size) = 3 * 1024 * 1024; # 3MB

    my($cgi) = CGI->new();

    print "Content-type: text/plain\n";
    print "\n";

    if ($max_size < $ENV{'CONTENT_LENGTH'}) {
        print "#ERROR=Too large :: upload data size.\n";
        exit(0);
    }

    my($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
    $year += 1900;
    $mon++;
    my($dir) = sprintf("%s/upload_msg/error_report%04d%02d%02d%02d%02d%02d-%d", $ENV{'MBGD_HOME'}, $year, $mon, $mday, $hour, $min, $sec, $$);

    File::Path::mkpath($dir, 0750);
    foreach my$key ('message1') {
        my($val) = $cgi->param($key);

        my($fh) = FileHandle->new(">$dir/$key");
        $fh->print($val);
        $fh->close();
    }
    print "#Done.\n";

    exit(0);
}
###############################################################################
1;#
###############################################################################
