#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
use RecogBuild;
use RECOG::RecogProject;

###############################################################################
#
sub add_user_genome_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta) = $auth->permit_project_user($user,
                                          $RECOG::RecogProject::ID_PRJ_system,
                                          $RECOG::RecogProject::ACT_ADD_PRJ);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    RecogBuild::add_user_genome_win($form_opt);

    return;
}
###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('spid') {
        $formOpt->{"$key"} = $cgi->param($key);
    }
    if ($formOpt->{'spid'} =~ /^gu\d+$/) {
        my(@uc_id_list) = split(/,/, $formOpt->{'uc_id_list'});
        foreach my$uc_id (@uc_id_list) {
            foreach my$k ('uc_name', '') {
                my($key) = join('_', $k, $uc_id);
                $formOpt->{"$key"} = $cgi->param($key);
            }
        }
    }
    else {
        delete($formOpt->{'spid'});
    }

    add_user_genome_win($formOpt);
}

###############################################################################
1;#
###############################################################################
