#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;

###############################################################################
sub load_genome_txt {
    my($spid) = shift;

    #
    my($ref) = {};
    my($dir) = sprintf("%s/species/%s", $ENV{'RECOG_HOME'}, $spid);
    my($filename) = "$dir/gm/genome.txt";
    my($fh) = FileHandle->new("$filename") || die("Can not open $filename($!)");
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;

        my($key, $val) = split(/\t/, $line);
        $ref->{"$key"} = $val;
    }
    $fh->close();

    return $ref;
}

###############################################################################
sub print_html_spid_set {
    my($set_name) = shift;
    my(@spid_list) = @_;

    my(@html_spid_list);
    foreach my$spid (@spid_list) {
        my($ref) = load_genome_txt($spid);
        push(@html_spid_list, qq{<span title="$ref->{'orgname'}">$ref->{'sp'}</span>});
    }

    print qq{<tr>\n};
    print qq{<td><input type="button" name="btn_del" value="DEL" onclick="del_spid_set('$set_name');"></td>\n};
    print qq{<td>$set_name</td>\n};
    print qq{<td>};
    print join(' , ', @html_spid_list);
    print qq{</td>\n};
    print qq{</tr>\n};

    return;
}

###############################################################################
sub list_species_set_win {

    my($dir) = sprintf("%s/etc/spid_set", $ENV{'RECOG_HOME'});
    my($spidset_ref) = SpidSet->new($dir);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
</head>

<body>

<h1>List species set</h1>

<form name="f0">

<table border>
<tr><th></th>
    <th>name</th>
    <th>species</th>
</tr>
EOB

    my(@set_name_list) = $spidset_ref->get_setname();
    if (scalar(@set_name_list) == 0) {
        print qq{<tr><th colspan=9">No species set</th></tr>};
    }
    else {
        foreach my$set_name (@set_name_list) {
            print_html_spid_set($set_name, $spidset_ref->get_spid($set_name));
        }
    }

    print <<EOB;
</table>

<input type="button" name="" value="Make species set" onclick="make_species_set_win(); ">

</form>

</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    list_species_set_win();
}

###############################################################################
1;#
###############################################################################
