#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogBuild;
use RecogProjectCommon;

###############################################################################
#
sub list_user_genome_win {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($dir) = "$ENV{'RECOG_HOME'}/species";
    my($dh) = DirHandle->new("$dir") || die("Can not open $dir($!)");
    my(@spid_list);
    while (my$file=$dh->read()) {
        next if ($file !~ /^gu\d+$/);

        push(@spid_list, $file);
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/mymbgd.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
<script>
</script>
</head>

<body>

<h1>List user genome</h1>

<form name="frm_add_user_genome" method="post">
<input type="button" name="btn_add" value="Create user genome" onclick="add_user_genome_win();">
</form>
<form name="frm_mod_user_genome" method="post">
<input type="hidden" name="spid" value="">
EOB

    #
    print qq{<table border>\n};
    print qq{<tr>};
    print qq{<th></th>};
    print qq{<th></th>};
    print qq{<th>SPID</th>};
    print qq{<th>SPEC</th>};
    print qq{<th>Fullname</th>};
    print qq{<th>Abbrev.</th>};
    print qq{<th>Strain</th>};
    print qq{<th>Taxonomy ID</th>};
    print qq{</tr>\n};

    #
    foreach my$spid (sort(@spid_list)) {
        my($ug_ref) = RecogBuild::load_user_genome($spid);

        print qq{<tr>};
        print qq{<td><input type="button" name="btn" value="Del" onclick="del_user_genome('$spid')"></td>};
        print qq{<td><input type="button" name="btn" value="Edit" onclick="mod_user_genome('$spid')"></td>};
        print qq{<td>$spid</td>};
        print qq{<td>$ug_ref->{'sp'}</td>};
        print qq{<td>$ug_ref->{'orgname'}</td>};
        print qq{<td>$ug_ref->{'abbrev'}</td>};
        print qq{<td>$ug_ref->{'strain'}</td>};
        print qq{<td>$ug_ref->{'taxid'}</td>};
        print qq{</tr>\n};

    }
    print qq{</table>};


    print qq{</form>};
    print qq{</body>};
    print qq{</html>};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    list_user_genome_win($formOpt);
}

###############################################################################
1;#
###############################################################################
