#!/usr/bin/perl -s
use strict;
use MBGD::DB;
use RecogProjectCommon;

my($user) = $ENV{'REMOTE_USER'};

#
my($html_project_list) = '';
my(@proj_name_list) = RecogProjectCommon::get_project_list();
foreach my$proj_name (@proj_name_list) {
    $html_project_list .= qq{<option value="$proj_name">$proj_name</options>};
}

print "Content-type: text/html\n";
print "\n";

print qq{
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/common.js"></script>
<script type="text/javascript" src="/js/mbgd.js"></script>
<script type="text/javascript" src="/js/organism_selection.js"></script>
<script type="text/javascript" src="/js/create_tax.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
<!--
<script type="text/javascript" src="http://muffinresearch.co.uk/code/javascript/getElementsByClassName/getElementsByClassName.js"></script>
-->

</head>

<body>

<h1>Build data</h1>

<form name="frm_build" method="post" action="" target="build_body">

<ol>
    <li>
      Download
      <ol type="i">
          <li><a href="/htbin/recog_build/update_taxonomy_win.cgi" target="build_body">Taxonomy</a></li>
          <li><a href="/htbin/recog_build/update_cdd_win.cgi" target="build_body">CDD</a></li>
          <li><a href="/htbin/recog_build/update_kegg_orgs_win.cgi" target="build_body">KEGG Organisms</a></li>
          <li><a href="/htbin/recog_build/update_ncbi_lproks_win.cgi" target="build_body">NCBI genome projects</a></li>
          <li><a href="/htbin/recog_build/update_gold_win.cgi" target="build_body">GOLD</a></li>
      </ol>
    </li>

    <li>
      User Genome
      <ol type="i">
          <li><a href="/htbin/recog_build/add_user_genome_win.cgi" onclick="add_user_genome_win(); return false; ">Add user genome</a></li>
          <li><a href="/htbin/recog_build/list_user_genome_win.cgi" onclick="list_user_genome_win(); return false; ">List user genome</a></li>
      </ol>
    </li>

<!--
    <li>
      Project
      <select name="project_id" onchange="change_project(); ">
      $html_project_list
      </select>
      <ol type="i">
          <li><a href="/htbin/recog_build/sel_user_genome_win.cgi" onclick="select_user_genome_win(); return false; ">Select user genome</a></li>
          <li><a href="/htbin/recog_build/organism_selection_recog.cgi" onclick="select_public_species_win(); return false; ">Select public species</a></li>
          <li><a href="/htbin/recog_build/list_species_win.cgi" onclick="list_species_win(); return false; ">List species</a></li>
      </ol>
    </li>
-->

    <li>
      MySQL
      <ol type="i">
          <li><a href="" onclick="update_mysql_species_win(); return false; ">Update species(mysql)</a></li>
      </ol>
    </li>


    <li>
      <a href="/recog_build/build_homology_all_win.html" target="build_body">Build homology database</a>
      <ol type="i">
<!--
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="get_sequences_win(); return false; ">Extract sequences</a></li>
-->
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="exec_blast_win(); ">BLAST/DP alignment </a></li>
<!--
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="exec_motif_win(); ">Motif search</a></li>
-->
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="update_mysql_homology_win(); ">Insert homology resuts into MySQL</a></li>
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="build_homology_db_win(); ">Build homology DB</a></li>
<!--
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="build_misc_db_win(); ">Build misc DB</a></li>
-->
      </ol>
    </li>

    <li>
      Publish database
      <ol type="i">
          <li><input type="checkbox" name="" value=""><a href="javascript:void(0); " onclick="publish_db_win(); ">Publish DB</a></li>
      </ol>
    </li>


</ol>

</form>

</body>
</html>

};
