#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogBuild;
use RecogProjectCommon;

###############################################################################
#
sub select_user_genome_win {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);
    my($proj_ref) = RecogProjectCommon::get_project($db, $proj_id, $user);
    my($proj_name) = $proj_ref->{'name'};
    my(@spid_list) = split(/,/, $proj_ref->{'spid'});
    my(%spid_hash);
    foreach my$spid (@spid_list) {
        $spid_hash{"$spid"} = 1;
    }

    #
    my($dir) = "$ENV{'RECOG_HOME'}/species";
    my($dh) = DirHandle->new("$dir") || die("Can not open $dir($!)");
    my(@spid_list) = ();
    while (my$file=$dh->read()) {
        next if ($file !~ /^gu\d+$/);

        push(@spid_list, $file);
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/mymbgd.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
<script>
</script>
</head>

<body>

<h1>Select user genome</h1>

<form name="frm_select_user_genome" method="post" action="/htbin/recog_build/select_user_genome.cgi">
<input type="hidden" name="project_id" value="$proj_id">
EOB

    #
    print qq{<table border>\n};
    print qq{<tr>};
    print qq{<th></th>};
    print qq{<th>SPID</th>};
    print qq{<th>SPEC</th>};
    print qq{<th>Fullname</th>};
    print qq{<th>Abbrev.</th>};
    print qq{<th>Strain</th>};
    print qq{<th>Taxonomy ID</th>};
    print qq{</tr>\n};

    #
    foreach my$spid (sort(@spid_list)) {
        my($ug_ref) = RecogBuild::load_user_genome($spid);
        my($sta_checked) = '';
        if ($spid_hash{"$spid"}) {
            $sta_checked = 'checked';
        }

        print qq{<tr>};
        print qq{<td><input type="checkbox" name="spid" value="$spid" $sta_checked></td>};
        print qq{<td>$spid</td>};
        print qq{<td>$ug_ref->{'sp'}</td>};
        print qq{<td>$ug_ref->{'orgname'}</td>};
        print qq{<td>$ug_ref->{'abbrev'}</td>};
        print qq{<td>$ug_ref->{'strain'}</td>};
        print qq{<td>$ug_ref->{'taxid'}</td>};
        print qq{</tr>\n};

    }
    print qq{</table>};

    print qq{<input type="button" name="btn_select_user_genome" value="Select" onclick="select_user_genome();">};

    print qq{</form>};
    print qq{</body>};
    print qq{</html>};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    select_user_genome_win($formOpt);
}

###############################################################################
1;#
###############################################################################
