#!/usr/bin/perl -s
use strict;

sub update_cdd_win {
    print "Content-type: text/html\n";
    print "\n";

    my($dir) = "$ENV{'RECOG_HOME'}/database.common/cdd";
    my($file_cdd) = "$dir/cdd.tar.gz";
    my($tm_cdd) = 'Not found';
    if (-e $file_cdd) {
        my(@stat_list) = stat($file_cdd);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_cdd = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update CDD</h1>
Download CDD from <a href="ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/cdd.tar.gz">ftp.ncbi.nih.gov</a><br />
<p>
timestamp : $tm_cdd<br>
</div>

<form name="frm_update_cdd" method="post">
<input type="button" name="btn_update_cdd" value="Update" onclick="update_cdd();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_cdd_win();
}
1;#
