#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;

###############################################################################
sub delete_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($user_name) = $form_opt->{'user_name'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta_sysadm && ($user ne $user_name)) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($msg);
    if ($user_name eq $RecogProjectCommon::NAME_USR_SYSADM) {
        $msg = "Sorry, you can not delete '$user_name'.";
    }
    else {
        RecogProjectCommon::delete_user($user, $user_name);
        $msg = 'Done.';
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB
    print "</htad>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Delete user</h1>\n";

    #
    print "$msg<br>\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_name') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    delete_user($form_opt);
}

###############################################################################
1;#
###############################################################################
