#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;
require 'libMBGDaxes.pl';

###############################################################################
sub print_user {
    my($user_ref) = shift;

    print qq{<a href="/htbin/recog_project/view_user.cgi?user_id=$user_ref->{'id'}">$user_ref->{'name'}</a>\n};

    return;
}

###############################################################################
sub edit_base_cluster_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($bc_id) = $form_opt->{'base_cluster_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);
    my($dir_proj) = "$ENV{'RECOG_HOME'}/etc/projects/$project_id.d";

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit base cluster condition</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    my($file_sel_conf) = "$dir_proj/$bc_id.sel";
    my($bc_sel_ref) = RecogProjectCommon::read_bc_sel_conf($file_sel_conf);

    #
    my($file_dom_conf) = "$dir_proj/$bc_id.dom";
    my($bc_dom_ref) = RecogProjectCommon::read_bc_dom_conf($file_dom_conf);

    #
    my($html_spec_in) = '';
    my($html_spec_out) = '';

    print <<EOB;
<form name="" method="post" action="/htbin/recog_project/edit_base_cluster.cgi">
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="base_cluster_id" value="$bc_id">

<table border>
<tr><th>In Group</th><th>Out group</th>
</tr>

<tr><td><select name="ingroup" size="15" multiple="multiple">
        $html_spec_in
        </select>
    </td>
    <td><select name="outgroup" size="15" multiple="multiple">
        $html_spec_out
        </select>
    </td>
</tr>

</table>

<table border>
  <tr><td>eval</td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'eval');" />
  <input type="text" name="eval" value="0.001" disabled /></td>
  <td>Cutoff BLAST E-value </td></tr>

  <tr><td>score</td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'score');" />
  <input type="text" name="score" value="60" disabled /></td>
  <td>Cutoff DP score </td></tr>
 
 <tr><td>ident</td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'ident');" />
  <input type="text" name="ident" value="" disabled /></td>
  <td>Cutoff percent identity </td></tr>

  <tr><td>pam</td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'pam');" />
  <input type="text" name="pam" value="" disabled /></td>
  <td>Cutoff PAM distance </td></tr>

  <tr><td>besthit</td>
  <td><label><input TYPE="radio" NAME="besthit" VALUE="none" CHECKED>none</label>
  <label><input TYPE="radio" NAME="besthit" VALUE="bidirec" >bidirec</label>
  <label><input TYPE="radio" NAME="besthit" VALUE="unidirec" >unidirec</label>
  </td>
  <td>Best hit criterion </td></tr>

  <tr><td>ratiocut</td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'ratiocut');" />
  <input type="text" name="ratiocut" value="" disabled /></td>
  <td>Cutoff ratio of the score against the best </td></tr>

  <tr><td>sim_measure (-S / -d)</td>
  <td><label><input type="radio" name="sim_measure" value="score" checked="checked">score</label>
  <label><input type="radio" name="sim_measure" value="pam">pam</label>
  <label><input type="radio" name="sim_measure" value="identity">identity</label>
  </td>
  <td>use similarity or distance as a measure of relatedness </td></tr>

  <tr><td>-ci#   </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'cutoff_ingroup');" />
  <input type="text" size="20" name="cutoff_ingroup" disabled /></td>
  <td>Cutoff DP score / Cutoff PAM distance / Cutoff IDENTITY for in-group</td></tr>

  <tr><td>missdist(-m#)   </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'missdist');" />
  <input type="text" size="20" name="missdist" disabled /></td>
  <td>score/distance for missing relationships (m &lt; c) </td></tr>

  <tr><td>missdist_ratio(-mr#)  </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'missdist_ratio');" />
  <input type="text" size="20" name="missdist_ratio" disabled /></td>
  <td>specify a missing score as a ratio to c (0 &lt; mr &lt; 1) [0.95] </td></tr>

  <tr><td>cutoff2(-C#)   </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'cutoff2');" />
  <input type="text" size="20" name="cutoff2" disabled /></td>
  <td>cutoff score for domain split (c &le; C) </td></tr>

  <tr><td>coverage2(-V#)   </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'coverage2');" />
  <input type="text" size="20" name="coverage2" disabled /></td>
  <td>alignment coverage for domain split (0 &le; V &le; 1) </td></tr>

  <tr><td>phylocut(-p#)   </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'phylocut');" />
  <input type="text" size="20" name="phylocut" disabled /></td>
  <td>ratio of phylogenetic pattern overlap for tree cutting [0.5] </td></tr>

  <tr><td>clustmode(-H)</td>
  <td><label><input type="radio" name="clustmode" value="combined" checked="checked">combined</label>
  <label><input type="radio" name="clustmode" value="homology">homology</label>
  <label><input type="radio" name="clustmode" value="orthology">orthology</lavel>
  </td>
  <td>homology clustering (i.e. skip the tree cutting) </td></tr>

  <tr><td>adjincl(-ai#)  </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'adjincl');" />
  <input type="text" size="20" name="adjincl" disabled /></td>
  <td>member overlap for absorbing adjacent small clusters (0 &le; ai &le; 1) </td></tr>

  <tr><td>adjovlp(-ao#)  </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'adjovlp');" />
  <input type="text" size="20" name="adjovlp" disabled /></td>
  <td>member overlap for merging adjacent clusters (0 &le; ao &le; ai) </td></tr>

  <tr><td>Ohorizweight  </td>
  <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'horizweight');" />
  <input type="text" size="20" name="horizweight" disabled /></td>
  <td>relative weight for horiz. transfer (0 &le; x &le; 1) [0] </td></tr>

</table>

<input type="button" name="btn_close" value="Close" onclick="window.close();">
<input type="reset" name="btn_reset" value="Reset">
<input type="submit" name="btn_edit" value="Update">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_id', 'base_cluster_id') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    edit_base_cluster_win($form_opt);
}

###############################################################################
1;#
###############################################################################
