#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;
require 'libMBGDaxes.pl';

###############################################################################
sub edit_user_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($user_name) = $form_opt->{'user_name'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta_sysadm && ($user ne $user_name)) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($user_ref) = RecogProjectCommon::get_user_info($user_name);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit User</h1>\n";

    #
    if (!$user_ref) {
        print "Sorry, found no user.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<form name="" method="post" action="/htbin/recog_project/edit_user.cgi">
<table border>
<tr><th>Name</th>
    <td>$user_ref->{'name'}
        <input type="hidden" name="user_name" value="$user_ref->{'name'}">
    </td>
</tr>

<tr><th>Organization</th>
    <td><input type="text" name="user_organization" value="$user_ref->{'organization'}"></td>
</tr>
EOB

    #
    if ($sta_sysadm || ($user eq $user_name)) {
        print <<EOB;
<tr><th>password</th>
    <td><input type="button" name="btn_user_passwd" value="Change password" onclick="change_password(this.form);"></td>
</tr>
EOB
    }

    print <<EOB;
</table>

<input type="button" name="btn_close" value="Close" onclick="window.close();">
<input type="reset" name="btn_reset" value="Reset">
<input type="button" name="btn_edit" value="Update" onclick="edit_user(this.form);">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_name') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    edit_user_win($form_opt);
}

###############################################################################
1;#
###############################################################################
