#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;

###############################################################################
#
sub exists_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();

    my($user_name) = $form_opt->{'user_name'};
    my($is_valid_name) = $auth->validate_user_name($user_name);
    my($sta) = $auth->exists_user($user, $user_name);

    print "Content-type: text/html\n";
    print "\n";
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print "</head>\n";
    print "<body>\n";
    print "<h1>User name</h1>\n";
    if (!$user_name || !$is_valid_name) {
        print "Sorry, invalid username. [$user_name]\n";
    }
    elsif ($sta) {
        print "Already used this username. [$user_name]\n";
    }
    else {
        print "This username is free. [$user_name]\n";
    }

    print qq{<input type="button" name="btn_close" value="Close" onclick="self.close();">\n};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_name') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    exists_user($form_opt);
}

###############################################################################
1;#
###############################################################################
