#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
sub print_user_html {
    my($ref) = shift;

    print <<EOB;
<tr>
    <td><input type="button" name="btn_del" value="Del" onclick="delete_user_win(this.form, '$ref->{'name'}');"></td>
    <td><input type="button" name="btn_edit" value="Edit" onclick="edit_user_win(this.form, '$ref->{'name'}');"></td>
    <td>$ref->{'name'}</td>
    <td>$ref->{'organization'}</td>
</tr>
EOB

    return;
}

###############################################################################
sub print_user_text {
    my($ref) = shift;

    my($name) = $ref->{'name'};
    $name =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    my($descr) = $ref->{'organization'};
    $descr =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    #
    print join("\t", $name, $descr),"\n";

    return;
}

###############################################################################
sub print_no_user_html {
    print <<EOB;
<tr><td></td>
    <td>Sorry, no user.</td>
    <td></td>
</tr>
EOB

    return;
}

###############################################################################
sub print_list_user_html {
    my($db) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    print "Content-type: text/html\n";
    print "\n";
    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
</head>

<body>
<div style="float:right; text-align:right;">[ $user ]</div>
<h1>List User(s)</h1>

<form name="frm_create_user" method="post" action="/htbin/recog_project/create_user_win.cgi" target="create_user">
<input type="submit" name="btn_create_user" value="Create user">
</form>

<form name="frm_edit_user" method="post" action="/htbin/recog_project/edit_user_win.cgi" target="edit_user">
<input type="hidden" name="user_name" value="">
<table border>
<tr><th></th>
    <th></th>
    <th>Name</th>
    <th>Organization</th>
</tr>
EOB

    my($user_list_ref) = RecogProjectCommon::get_user_list();
    if (scalar(@{$user_list_ref}) != 0) {
        foreach my$user (sort(@{$user_list_ref})) {
            my($ref) = RecogProjectCommon::get_user_info($user);
            print_user_html($ref);
        }
    }
    else {
        print_no_user_html();
    }

    print <<EOB;
</table>
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
sub print_list_user_text {

    my($user) = $ENV{'REMOTE_USER'};

    print "Content-type: text/plain\n";
    print "\n";

    print '#', join("\t", 'Name', 'Descr'), "\n";

    my(@user_list) = RecogProjectCommon::get_user_list();
    foreach my$user (sort(@user_list)) {
        my($ref) = RecogProjectCommon::get_user_info($user);
        print_user_text($ref);
    }

    return;
}

###############################################################################
sub list_user {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($mode) = $formOpt->{'mode'};

    if ($mode !~ /^text$/i) {
        print_list_user_html();
    }
    else {
        print_list_user_text();
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('mode') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    list_user($formOpt);
}

###############################################################################
1;#
###############################################################################
