#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';

###############################################################################
sub mod_project_user_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($proj_id)   = $form_opt->{'project_id'};
    my($user_name) = $form_opt->{'user_name'};

    my($auth) = RECOG::RecogProject->new();

    #
    my($sta) = $auth->exists_project($user, $proj_id);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($sta) = $auth->permit_project_user($user,
                                          $proj_id,
                                          $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
#    my($proj_ref) = RecogProjectCommon::get_project($proj_id);
    my($proj_ref) = $auth->get_project($user, $proj_id);
    my($proj_name) = $proj_ref->{'PROP'}->{'name'};

    #
    my(@role_list) = @RECOG::RecogProject::AUTH_PRJ;
    if ($auth->is_system_project($user, $proj_id)) {
        @role_list = @RECOG::RecogProject::AUTH_SYS;
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Modify project member</h1>\n";
    print qq{<form name="frm_mod_project_user" method="post" action="/htbin/recog_project/mod_project_user.cgi">\n};

    print <<EOB;
<table border>
<tr><th>Project</th>
    <td>$proj_name
        <input type="hidden" name="project_id" value="$proj_id">
    </td>
</tr>

<tr><th>Name</th>
    <td>$user_name
        <input type="hidden" name="user_name" value="$user_name">
    </td>
</tr>
EOB

    #
    print qq{<tr><th>Role</th>\n};
    print qq{    <td>\n};
    foreach my$r (@role_list) {
        my($sta_checked) = '';
        my($sta) = $auth->has_role_project_user($user, $proj_id, $user_name, $r);
        if ($sta) {
            $sta_checked = 'checked';
        }
        print qq{<label><input type="checkbox" name="$r" value="yes" $sta_checked>$r</label><br>\n};
    }
    print "    </td>\n";
    print "</tr>\n";

    print <<EOB;
</table>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
<input type="submit" name="btn_update" value="Update">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id', 'user_name');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    mod_project_user_win($form_opt);
}

###############################################################################
1;#
###############################################################################
