#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use IO::Dir;
use IO::File;
use RecogProjectCommon;
use RECOG::DomClustCommon;
$main::DEBUG = 1;

###############################################################################
#
sub get_cluster_list_public {
    my($base_cluster_server) = shift;
    my($project_id) = shift;

    my($url) = $base_cluster_server . '/htbin/list_cluster.cgi?mode=text';
    my(@cluster_list);
    my($cmd) = "$main::CMD_curl -s '$url'";
    my($fh) = IO::File->new("$cmd |");
    if ($fh) {
        my(%clust_sp_opt);
        while (my$line=$fh->getline()) {
            $line =~ s#[\r\n]*$##;
            my($clust_id, $date, $options) = split(/\t/, $line);

            $options =~ s#\-SPEC\=(\S+)\s*##;
            my($species) = $1;
            $species =~ s#\'##g;

            my($options4dump) = $options;
            $options4dump =~ s#\s+\-Ooutgroup\S+##;
            $options4dump =~ s#\s+\-Ohorizweight\S+##;
            $options4dump =~ s#\s+\-OtaxMap\S+##;
            $options4dump =~ s#\s+\-Ometa\S+##;

            my($ref) = {};
            $ref->{'CLUSTER_ID'} = $clust_id;
            $ref->{'DATE'}       = $date;
            $ref->{'OPTIONS'}    = $options4dump;
            $ref->{'SPECIES'}    = $species;

            if (!exists($clust_sp_opt{"$options4dump,$species"})) {
                push(@cluster_list, $ref);
            }
            $clust_sp_opt{"$options4dump,$species"} = 1;
        }
        $fh->close();
    }

    return @cluster_list;
}

###############################################################################
#
sub get_cluster_list_local {
    my($base_cluster_server) = shift;
    my($project_id) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    #
    my(%clust_name_hash);
    my($tab) = 'project_domclust';
    if ($db->exist_table($tab)) {
        my($sql) = "select * from $tab";
        if (0 < $project_id) {
            $sql .= " where proj_id=$project_id";
        }
        my($sth) = $db->execute($sql);
        while(my$ref = $sth->fetchrow_hashref()) {
            my($clust_id) = $ref->{'clusttabid'};
            $clust_name_hash{"$clust_id"} = $ref;
        }
    }

    #
    my(@cluster_list);
    my($tab) = 'cluster_tables_idx';
    if (!$db->exist_table($tab)) {
        return @cluster_list;
    }

    #
    my(%clust_sp_opt);
    my($sql) = "select * from $tab order by cdate";
    my($sth) = $db->execute($sql);
    while(my$ref = $sth->fetchrow_hashref()) {
        if (0 == $ref->{'status'}) {
            next; # ERROR
        }
        elsif (0 < $ref->{'status'}) {
            next; # Running
        }

        #
        my($clust_id) = $ref->{'clusterID'};
        my($file_o11) = "$ENV{'RECOG_HOME'}/MBGD.tmp/tmp_dom_res_$clust_id.o11";
        if (! -e "$file_o11") {
#            next;
        }

        #
        my($clust_ymd, $clust_hms) = split(/\s/, $ref->{'cdate'});
        my($clust_date) = $clust_ymd . ' ' . $clust_hms;
        my($n_clusters) = $ref->{'ncluster'};

        #
        my($cmd) = $ref->{'cmd'};

        my(%opt_clust1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
        my($opt_clust1) = '';
        foreach my$k (sort keys(%opt_clust1)) {
            my($v) = $opt_clust1{"$k"};
            $opt_clust1 .= "$k=$v ";
        }
        my(%opt_clust2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
        my($opt_clust2) = '';
        foreach my$k (sort keys(%opt_clust2)) {
            next if ($k =~ /\-tabout/);

            my($v) = $opt_clust2{"$k"};
            $opt_clust2 .= "$k$v ";
        }
        my($options) = $opt_clust1 . $opt_clust2;
        $options =~ s#\-SPEC\=(\S+)\s*##;
        my($species) = $1;
        $species =~ s#\'##g;

        #
        my($options4dump) = $options;
        $options4dump =~ s#\s+\-Ooutgroup\S+##;
        $options4dump =~ s#\s+\-Ohorizweight\S+##;
        $options4dump =~ s#\s+\-OtaxMap\S+##;
        $options4dump =~ s#\s+\-Ometa\S+##;

        #
        my($ref) = {};
        $ref->{'CLUSTER_ID'} = $clust_id;
        $ref->{'DATE'}       = $clust_date;
        $ref->{'OPTIONS'}    = $options4dump;
        $ref->{'SPECIES'}    = $species;
        if (exists($clust_name_hash{"$clust_id"})) {
            $ref->{'NAME'}   = $clust_name_hash{"$clust_id"}->{'name'};
        }

        if (!exists($clust_sp_opt{"$options4dump,$species"})) {
            push(@cluster_list, $ref);
        }
        $clust_sp_opt{"$options4dump,$species"} = 1;
    }

    return @cluster_list;
}

###############################################################################
#
sub select_base_cluster_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($base_cluster_server) = $form_opt->{'base_cluster_server'};
    if (!$base_cluster_server) {
        $base_cluster_server = $main::URL_PUBLIC_SERVER;
    }

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);
    my($dir_proj_bc) = "$ENV{'RECOG_HOME'}/etc/projects/$project_id.d/base_cluster";
    File::Path::mkpath("$dir_proj_bc", 0, 0750) if (! -e "$dir_proj_bc");

    #
    my($n_bc) = 0;
    my($file_bc_hash) = {};
    my($dh) = IO::Dir->new("$dir_proj_bc");
    if ($dh) {
        foreach my$file ($dh->read()) {
            next if ($file =~ /\./);
            $file_bc_hash->{"$file"} = 1;
            $n_bc++;
        }
    }

    #
    my(@cluster_list);
    my($url);
    if ($base_cluster_server eq $main::URL_PUBLIC_SERVER) {
        @cluster_list = get_cluster_list_public($base_cluster_server, $project_id);
    }
    else {
        @cluster_list = get_cluster_list_local($base_cluster_server, $project_id);
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOS;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
<script>
function change_server() {
    var doc = this.document;
    var frm = doc.frm_sel_base_cluster;

    frm.target = '';
    frm.action = '/htbin/recog_project/select_base_cluster_win.cgi';
    frm.submit();

    return;
}

function set_base_cluster_species(spec) {
    var doc = this.document;
    var frm = doc.frm_sel_base_cluster;

    frm.base_cluster_species.value = spec;

    return;
}

function clear_base_cluster() {
    var doc = this.document;
    var frm = doc.frm_sel_base_cluster;

    var n = frm.base_cluster_tab_id.length;
    for (var i = 0; i < n; i++) {
        var elm = frm.base_cluster_tab_id[i];
        if (elm.type == 'radio') {
            elm.checked = false;
        }
    }

    return;
}

function select_base_cluster() {
    var doc = this.document;
    var frm = doc.frm_sel_base_cluster;

    frm.target = '';
    frm.action = '/htbin/recog_project/select_base_cluster.cgi';
    frm.submit();

    return;
}

function upd_cluster_name(cluster_id) {
    var doc = this.document;
    var frm = doc.frm_upd_cluster_name;

    frm.target = 'win_upd_cluster_name';
    frm.action = '/htbin/recog_project/upd_cluster_name_win.cgi';
    frm.cluster_id.value = cluster_id;
    frm.submit();

    reutrn;
}

function do_clustering() {
    var doc = this.document;
    var frm = doc.frm_public_server_clustering;

    var spec = doc.frm_sel_base_cluster.species.value;
    if (spec == '') {
        return;
    }

    frm.selected_species.value = spec;
    frm.submit();

    return;
}

function do_organism_selection() {
    var doc = this.document;
    var frm = doc.frm_organism_selection;

    frm.species.value = doc.frm_sel_base_cluster.species.value;
    frm.submit();

    return;
}

</script>
EOS
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Select base cluster</h1>\n";

    print <<EOB;
<form name="frm_sel_base_cluster" method="post">
EOB

    print "Download base cluster from \n";
    print qq{<select name="base_cluster_server">\n};

    #
    my($adrs) = $main::URL_PUBLIC_SERVER;
    my(%sta_pub) = ( "$adrs" => 'selected' );
    my($sta) = $sta_pub{"$base_cluster_server"};
    print qq{<option value="$adrs" $sta>$adrs</option>\n};

    #
    my($adrs);
    if ($ENV{'HTTPS'} =~ /^on$/i) {
        $adrs = 'https://' . $ENV{'SERVER_NAME'};
        if ($ENV{'SERVER_PORT'} != 443) {
            $adrs .= ':' . $ENV{'SERVER_PORT'};
        }
    }
    else {
        $adrs = 'http://' . $ENV{'SERVER_NAME'};
        if ($ENV{'SERVER_PORT'} != 80) {
            $adrs .= ':' . $ENV{'SERVER_PORT'};
        }
    }
    my(%sta_loc) = ( "$adrs" => 'selected' );
    my($sta) = $sta_loc{"$base_cluster_server"};
    print qq{<option value="$adrs" $sta>$adrs</option>\n};

    #
    print qq{</select>\n};
    print qq{<!-- $url -->\n};
    print qq{<input type="button" name="btn_server" value="Update" onclick="change_server();">\n};
    print "<br>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    # default_filter option:  only shows precomputed clusters and ignore user-created clusters
    my($checked) = $form_opt->{chk_default_filter} ? "checked" : "";
    $checked = '' if ($form_opt->{base_cluster_server} ne $main::URL_PUBLIC_SERVER);
    print qq{<input type="checkbox" name="chk_default_filter" value="on" onclick="change_server();" $checked>\n};
    print "Show only the system precomputed clusters<br>\n";
    #
    my($species_filter) = $form_opt->{"species"};
    my(@species_filter_list) = split(/,/, $species_filter);

    print <<EOB;
<input type="button" name="btn_sel_spec" value="Species" onclick="do_organism_selection();"><input type="text" name="species" value="$species_filter" size="50">
<input type="button" name="btn_clustering" value="Clustering" onclick="do_clustering();">
<br><br>

<input type="button" name="btn_no_select" value="Clear base cluster" onclick="clear_base_cluster();">
<input type="button" name="btn_select" value="Select" onclick="select_base_cluster();">
<input type="button" name="btn_close" value="Close" onclick="self.close();">
<br>
<table border>
<tr><th></th>
    <th>Cluster</th>
    <th>Date</th>
    <th>Options</th>
    <th>Species</th>
</tr>

EOB

    #
    my($base_cluster_species);
    foreach my$cluster_ref (@cluster_list) {
        next if (!$cluster_ref->{'CLUSTER_ID'});
	next if ($form_opt->{chk_default_filter} && $cluster_ref->{'CLUSTER_ID'} =~ /^\d+$/i);

        #
        my(@sp_list) = split(/,/, $cluster_ref->{'SPECIES'});
        my(%sp_hash);
        foreach my$sp (@sp_list) {
            $sp_hash{"$sp"} = 1;
        }
        my($sta_filter) = 1;
        foreach my$sp (@species_filter_list) {
            if (!$sp_hash{"$sp"}) {
                $sta_filter = 0;
                last;
            }
        }
        if (!$sta_filter) {
            next;
        }

        my($file_base_cluster) = "$dir_proj_bc/$cluster_ref->{'CLUSTER_ID'}";
        my($sta) = '';
        if (($n_bc == 0) && ($cluster_ref->{'CLUSTER_ID'} =~ /^default$/)) {
            $sta = 'checked';
            $base_cluster_species = $cluster_ref->{'SPECIES'};
        }
        elsif (-e "$file_base_cluster") {
            $sta = 'checked';
            $base_cluster_species = $cluster_ref->{'SPECIES'};
        }
        print qq{<tr>};
        print qq{<td><input type="radio" name="base_cluster_tab_id" value="$cluster_ref->{'CLUSTER_ID'}" onclick="set_base_cluster_species('$cluster_ref->{'SPECIES'}');" $sta></td>};

        my($cluster_name) = 'NONAME';
        my($cluster_id)   = $cluster_ref->{'CLUSTER_ID'};
        if ($cluster_ref->{'NAME'} ne '') {
            $cluster_name = $cluster_ref->{'NAME'};
        }
        my($html_cluster_name) = $cluster_id;
        if ($base_cluster_server ne $main::URL_PUBLIC_SERVER) {
            $html_cluster_name = qq{$cluster_name <input type="button" name="btn_edit" value="Edit" onclick="upd_cluster_name('$cluster_id');">};
        $html_cluster_name .= '<br>'
                            . '('
                            . $cluster_id
                            . ')';
        }
        print qq{<td style="">$html_cluster_name</td>};
        print qq{<td style="white-space: nowrap;">$cluster_ref->{'DATE'}</td>};
        print qq{<td>$cluster_ref->{'OPTIONS'}</td>};
        print qq{<td>$cluster_ref->{'SPECIES'}</td>};
        print qq{</tr>\n};
    }

    print <<EOB;
</table>
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="base_cluster_species" value="$base_cluster_species">
</form>

<form name="frm_upd_cluster_name">
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="cluster_id" value="">
</form>

<form name="frm_public_server_clustering" method="post" action="$main::URL_PUBLIC_SERVER/htbin/cluster" target="win_clunstering">
<input type="hidden" name="selected_species" value="">
</form>

<form name="frm_organism_selection" method="post" action="/htbin/recog_project/organism_selection.cgi" target="win_organism_selection">
<input type="hidden" name="mode" value="recog_build">
<input type="hidden" name="species" value="">
</form>

</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my(@key_list) = ( 'project_id',
                      'base_cluster_server',
                      'species',
                      'chk_default_filter',
                    );
    my($form_opt) = {};
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    select_base_cluster_win($form_opt);
}
###############################################################################
1;#
###############################################################################
