function add_event_listener(elm, event_type, func_name, phase) {
    if (!elm) {
        return false;
    }

    if (phase != true) {
        phase = false;
    }
    if (elm.addEventListener) {
        elm.addEventListener(event_type, func_name, phase);
    }
    else if (elm.attachEvent) {
        elm.attachEvent('on' + event_type, func_name);
    }
    else {
        return false;
    }

    return true;
}

function hide_all_menu() {
  setVisibleMenu('popup_alignment', false);
  setVisibleMenu('popup_sequence', false);
  setVisibleMenu('popup_distmat', false);
  setVisibleMenu('popup_phylopat', false);
  setVisibleMenu('popup_kegg', false);
}

function setup_tab_action() {
  var name;
  var elm;

  name = 'tab_summary';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_summary);

  name = 'tab_list';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_list);

  name = 'tab_tree';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_tree);

  name = 'tab_maps';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_orf_maps);

  name = 'tab_alignment';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_alignment_menu);

  name = 'tab_sequence';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_sequence_menu);

  name = 'tab_clustering_tree';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_clustering_tree);

  name = 'tab_distmat';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_distmat_menu);

  name = 'tab_homclust';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_homclust);

  name = 'tab_phylopat';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_phylopat_menu);

  name = 'tab_kegg';
  elm = document.getElementById(name);
  add_event_listener(elm, 'mouseover', hide_all_menu);
  add_event_listener(elm, 'click', display_kegg_menu);

}

function display_tab(ent_name) {
  var name_list = new Array('summary', 'list', 'tree', 'distmat')
  var k;
  var i;
  for(i = 0; i < name_list.length; i++) {
    if (name_list[i] == ent_name) {
      k = 'orf_' + name_list[i];
      document.getElementById(k).style.display = 'block';
      k = 'tab_' + name_list[i];
      document.getElementById(k).style.backgroundColor = '#d8f0d8';
      document.getElementById(k).style.textDecoration = 'none';
    }
    else {
      k = 'orf_' + name_list[i];
      document.getElementById(k).style.display = 'none';
      k = 'tab_' + name_list[i];
      document.getElementById(k).style.backgroundColor = '#b0d2b0';
      document.getElementById(k).style.textDecoration = 'underline';
    }
  }
}


function display_summary() {
  display_tab('summary');
}


function display_list() {
  display_tab('list');
}


function display_tree() {
  display_tab('tree');
}


function display_orf_maps() {
  exec_orf_maps();
}


function display_alignment_menu(event) {
  setVisibleMenu('popup_alignment', true, get_event_x(event), get_event_y(event));
}


function display_sequence_menu(event) {
  setVisibleMenu('popup_sequence', true, get_event_x(event), get_event_y(event));
  return false;
}


function display_clustering_tree() {
  exec_clustering_tree();
}


function display_distmat_menu(event) {
  setVisibleMenu('popup_distmat', true, get_event_x(event), get_event_y(event));
}


function display_distmat() {
  display_tab('distmat');
}


function display_homclust(event) {
  exec_homclust();
}

function display_phylopat_menu(event) {
  setVisibleMenu('popup_phylopat', true, get_event_x(event), get_event_y(event));
}

function display_kegg_menu(event) {
  setVisibleMenu('popup_kegg', true, get_event_x(event), get_event_y(event));
}

function setVisibleMenu(name, sta, posx, posy) {
  var popup_menu = document.getElementById(name);
  if (sta) {
    popup_menu.style.top = posy - 10 + 'px';
    popup_menu.style.left = posx - 10 + 'px';
    popup_menu.style.visibility='visible';
  }
  else {
    popup_menu.style.visibility='hidden';
  }
}


function exec_orf_maps() {
  var n = countCheckedEntries(document);
  if (n < 2) {
//    alert('Please check ORFs.(2 or more)');
//    return;
  }
  document.clusterForm.target = "_blank";
  document.clusterForm.drawmap.value = "Compare";
  document.clusterForm.submit();
  document.clusterForm.drawmap.value = "";
}

function exec_alignment(method_alignment) {
  setVisibleMenu('popup_alignment', false);
  var n = countCheckedEntries(document);
  if (n < 2) {
//    alert('Please check ORFs.(2 or more)');
//    return;
  }
  document.clusterForm.prog.value = method_alignment;
  document.clusterForm.target = "_blank";
  document.clusterForm.mali.value = "Start";
  for(var i = 0; i < document.clusterForm.align_seqtype.length; i++) {
    if (document.clusterForm.align_seqtype[i].checked) {
      document.clusterForm.seqtype.value = document.clusterForm.align_seqtype[i].value;
      break;
    }
  }
  document.clusterForm.up.value     = document.clusterForm.align_up.value;
  document.clusterForm.down.value   = document.clusterForm.align_down.value;
  document.clusterForm.submit();
  document.clusterForm.mali.value = "";
}


function exec_get_sequence(type_sequence) {
  setVisibleMenu('popup_sequence', false);
  var n = countCheckedEntries(document);
  if (n < 1) {
//    alert('Please check ORF(s).(1 or more)');
//    return;
  }
  document.clusterForm.target = "_blank";
  document.clusterForm.getseq.value = "Get";
  document.clusterForm.seqtype.value = type_sequence;
  document.clusterForm.up.value     = document.clusterForm.getseq_up.value;
  document.clusterForm.down.value   = document.clusterForm.getseq_down.value;
  document.clusterForm.submit();
  document.clusterForm.getseq.value = "";
}


function exec_clustering_tree() {
  var n = countCheckedEntries(document);
  if (n < 2) {
//    alert('Please check ORFs.(2 or more)');
//    return;
  }
  document.clusterForm.target = "_blank";
  document.clusterForm.drawtree.value = "Draw";
  document.clusterForm.submit();
  document.clusterForm.drawtree.value = "";
}

function exec_distmat() {
  setVisibleMenu('popup_distmat', false);

  var sta = changeDistmatOpt()
  if ((SAVE_distmat != '') && !sta) {
    display_distmat();
    return;
  }

  document.clusterForm.target = "_self";
  document.clusterForm.distmat.value = "Distance Matrix";
  document.clusterForm.submit();
  document.clusterForm.distmat.value = "";
}

function exec_homclust() {
  document.clusterForm.target = "_blank";
  document.clusterForm.homclust.value = "Find";
  document.clusterForm.submit();
  document.clusterForm.homclust.value = "";
}

function changeAlignmentParameters() {
  setVisibleMenu('popup_alignment', false);
  open('/htbin/SetParamScreen.pl?class=MalignParam&CloseWindow=1', 'alignment_parameters');
}

function disp_orfs(event, name) {
    var elm  = document.getElementById(name);

    //
    if (document.all) {
        elm.style.left       = window.event.clientX - 10 + 'px';
    }
    else {
        elm.style.left       = event.pageX - 10 + 'px';
    }

    if (document.all) {
//        elm.style.top        = window.event.clientY - 10 + 'px';
    }
    else {
        elm.style.top        = event.pageY - 10 + 'px';
    }

    elm.style.visibility = 'visible';
}

function hide_orfs(event, name) {
    var elm = document.getElementById(name);
    var x, y;
    if (document.all) {
        x = window.event.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
        y = window.event.clientY + document.body.scrollTop + document.documentElement.scrollTop;

        //
        var d = 2;
        if ((event.type == 'mouseout') &&
            (elm.offsetLeft < x - d) && (x < elm.offsetLeft + elm.offsetWidth) &&
            (elm.offsetTop < y - d) && (y < elm.offsetTop + elm.offsetHeight)) {
            return;
        }
    }
    else {
        x = event.pageX;
        y = event.pageY;
        if ((event.type == 'mouseout') &&
            (elm.offsetLeft < x) && (x < elm.offsetLeft + elm.offsetWidth) &&
            (elm.offsetTop < y) && (y < elm.offsetTop + elm.offsetHeight)) {
            return;
        }
    }

    elm.style.visibility='hidden';
}

