#!/usr/bin/perl -s
use strict;
use MBGD::DB;
use BuildStatus;

###############################################################################
#
sub checkBuildingStatus {
    my($db) = shift;
    my($sql);
    my($sth);

    #
    my($ver) = BuildStatus::get_ver_domclust();
    if (!defined($ver)) {
        print STDERR "ERROR :: Can not found command domclust.\n";
    }
    else {
        print STDERR "LOG :: Found domclust Ver $ver\n";
        if ($ver lt "1.1.6b") {
            print STDERR "ERROR :: Please install newer one.\n";
        }
    }

    #
    my(@splist);
    $sql = "select * from genome order by spid";
    $sth = $db->execute($sql);
    while (my$ref=$sth->fetchrow_hashref()) {
        push(@splist, $ref->{'sp'});
    }
    my($n_sp) = scalar(@splist);
    print STDERR "LOG :: Found $n_sp species\n";

    #
    my($file_query) = "$ENV{'RECOG_HOME'}/work/newprotseq";
    my($n_query) = BuildStatus::count_fasta_seq($file_query);
    if (!defined($n_query)) {
        print STDERR "ERROR :: Can not found file-query. ($file_query)\n";
    }
    else {
        print STDERR "LOG :: Found query file. ($file_query)\n";
        if ($n_query == 0) {
            print STDERR "WARNING :: But found no sequence.\n";
        }
        print STDERR "LOG :: Count :: $n_query\n";
    }

    #
    my($file_blastdb) = "$ENV{'RECOG_HOME'}/work/blastdb";
    my($n_blastdb) = BuildStatus::count_fasta_seq($file_blastdb);
    if (!defined($n_blastdb)) {
        print STDERR "ERROR :: Can not found file-blastdb. ($file_blastdb)\n";
    }
    else {
        print STDERR "LOG :: Found blastdb file. ($file_blastdb)\n";
        if ($n_blastdb == 0) {
            print STDERR "WARNING :: But found no sequence.\n";
        }
        print STDERR "LOG :: Count :: $n_blastdb\n";
    }
    $sql = "select count(*) as n from proteinseq";
    $sth = $db->execute($sql);
    my$ref=$sth->fetchrow_hashref();
    print STDERR "LOG :: Count(mysql) :: $ref->{'n'}\n";

    #
    my($file_blastdpres) = "$ENV{'RECOG_HOME'}/work/homology.blastdpres";
    my($n_blastdpres) = BuildStatus::count_line_text($file_blastdpres);
    if (!defined($n_blastdpres)) {
        print STDERR "ERROR :: Can not found file-blastdpres. ($file_blastdpres)\n";
    }
    else {
        print STDERR "LOG :: Found blastdpres file. ($file_blastdpres)\n";
        if ($n_blastdpres == 0) {
            print STDERR "WARNING :: But found no result.\n";
        }
        print STDERR "LOG :: Count :: $n_blastdpres\n";
    }

    #
    my($dir_bldp) = "$ENV{'RECOG_HOME'}/database.work/bldp";
    my($n_bldp) = BuildStatus::count_bldp_files($dir_bldp);
    if (!defined($n_bldp)) {
        print STDERR "ERROR :: Can not found dir-bldp. ($dir_bldp)\n";
    }
    else {
        print STDERR "LOG :: Found bldp dir. ($dir_bldp)\n";
        if ($n_bldp == 0) {
            print STDERR "WARNING :: But found no bldp data file.\n";
        }
        elsif ($n_bldp != $n_sp * ($n_sp+1) / 2) {
            print STDERR "WARNING :: But found no bldp data file.\n";
        }
        print STDERR "LOG :: Count :: $n_bldp\n";
    }

    #
    print STDERR "DBG :: Checking bldp file size...\n";
    my($fsize_bldp_ref) = BuildStatus::fsize_bldp_splist_files($dir_bldp, @splist);
    if (!defined($fsize_bldp_ref)) {
        print STDERR "ERROR :: Can not found dir-bldp. ($dir_bldp)\n";
    }
    else {
        foreach my$sp1 (@splist) {
            foreach my$sp2 (@splist) {
                if ($sp2 lt $sp1) {
                    next;
                }
                if (($fsize_bldp_ref->{"$sp1"}->{"$sp2"} == 0) ||
                     $main::FILE_SIZE) {
                    print STDERR "LOG :: file-size [$sp1-$sp2] :: ";
                    print STDERR $fsize_bldp_ref->{"$sp1"}->{"$sp2"};
                    print STDERR " :: WARNING" if (!$main::FILE_SIZE);
                    print STDERR "\n";
                }
            }
        }
        print STDERR "DBG :: Done.\n";
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_ACCUM;
    if (defined($main::DBNAME)) {
        $dbname = $main::DBNAME;
    }

    #
    my($db) = MBGD::DB->new($dbname);
    checkBuildingStatus($db);
}

###############################################################################
1;#
###############################################################################
