#!/usr/bin/perl -s

$DIRNAME = "../db" if (! $DIRNAME);

$nodes = "$DIRNAME/nodes.dmp";
$names = "$DIRNAME/names.dmp";

open(NODES, $nodes) || die("Can not open $nodes($!)");
while (<NODES>) {
	($taxid, $parent, $rank, $embcode, $divid, $inh_div, $gencode,
		$inh_gc, $mito_gen, $inh_mgc, $gb_flg, $noseq_flg, $comm)
			= split(/\t\|\t/);
	$Info{$taxid}->{parent} =  $parent;
	$Info{$taxid}->{rank} = $rank;
	$Info{$taxid}->{divid} = $divid;
	$Info{$taxid}->{gencode} = $gencode;
	$Info{$taxid}->{mitogen} = $mito_gen;
	if ($taxid ne '1') {	## not a root
		push(@{$Info{$parent}->{child}}, $taxid)
	}
}
close(NODES);


open(NAMES, $names) || die("Can not open $names($!)");
while (<NAMES>) {
	chomp;
	s/\t\|$//;
	($taxid, $name, $uniq_name, $class) = split(/\t\|\t/);
	push(@Names, [$taxid, $name, $uname, $class]);
	if ($class eq 'scientific name') {
		$Info{$taxid}->{name} = $name;
	}
}
close(NAMES);

foreach $taxid (keys %Info) {
	if (! $Info{$taxid}->{hier}) {
		&create_hier($taxid);
	}
}

&sort_hier();

foreach $n (@Names) {
	($taxid, $name, $uname, $class) = @{$n};
	$level = 0 + split(/\./, $Info{$taxid}->{hier});
	$lname = $name; $lname =~ tr/A-Z/a-z/;
	print join("\t", $taxid, $name, $lname, $Info{$taxid}->{rank}, $class, $level, $Info{$taxid}->{hier}, $TaxOrder{$taxid}), "\n";
}

sub create_hier {
	my($taxid) = @_;
	my($parent_hier, $hier, $parent);

	return '' if ($taxid eq '1');	## root

	$parent = $Info{$taxid}->{parent};
	if ($Info{$taxid}->{hier}) {
		return $Info{$taxid}->{hier};
	} elsif ($parent) {
		$parent_hier = &create_hier($parent);
		my($i) = 0;
		foreach $child (sort by_name @{$Info{$parent}->{child}}) {
			$i++;
##			$ii = sprintf("%03d", $i);
			if ($parent_hier) {
				$Info{$child}->{hier} = "$parent_hier.$i";
			} else {
				$Info{$child}->{hier} = "$i";
			}
			if ($child eq $taxid) {
				$hier = $Info{$child}->{hier};
			}
		}
	} else {
		return 9999;
	}
	return $hier;
}

sub sort_hier {
	foreach $taxid (keys %Info) {
		my @Hier = split(/\./, $Info{$taxid}->{hier});
		$TaxHier{$taxid} = \@Hier;
	}
	$ord = 0;
	foreach $taxid (sort by_hier (keys %TaxHier)) {
		$TaxOrder{$taxid} = ++$ord;
	}
}
sub by_name {
	$Info{$a}->{name} cmp $Info{$b}->{name};
}
sub by_hier {
	my $i = 0;
	while ($TaxHier{$a}->[$i] && $TaxHier{$a}->[$i] == $TaxHier{$b}->[$i]) {
		$i++;
	}
	if ($TaxHier{$a}->[$i] == $TaxHier{$b}->[$i]) {
		return $a <=> $b;
	} else {
		return $TaxHier{$a}->[$i] <=> $TaxHier{$b}->[$i];
	}
}
