#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
use MBGD;
use MBGD::Taxonomy;

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_ACCUM;
    $dbname = $main::DBNAME if ($main::DBNAME);
    my($db) = new MBGD::DB($dbname);
    my($tax) = new MBGD::Taxonomy($main::TAX);

    # hmmer $BMQ(B DB
    my($fileDb) = "$ENV{'MBGD_HOME'}/package/tigrfams/6.0/TIGRFAMs_6.0_HMM.LIB";
    $fileDb = $main::DB if ($main::DB && (-e $main::DB));

    # $B#1(BJOB$B$G=hM}$9$kG[Ns?t(B
    my($mx) = 50;
    $mx = $main::MX if ($main::MX && (0 < $main::MX));

    # $BJBNs<B9T(B JOB $B?t(B
    my($mxJob) = 5;
    $mxJob = $main::MXJOB if ($main::MXJOB && (0 < $main::MXJOB));

    # $B=PNO%U%!%$%k(B
    my($fileOut) = "hmmer.out";
    $fileOut = $main::OUT if ($main::OUT);

    #
    my(@spList) = @ARGV;
    my(%hashSpec);
    if ($main::RANK) {
        # RANK $B;XDj$GBP>]@8J*<o$r7hDj$9$k(B
        my(@refSpList) = $tax->get_species( { all_strains => "$main::RANK" } );
        foreach my$refSp (@refSpList) {
            push(@spList, $refSp->[0]);  # $BBeI=(B sp $B$N$_(B
        }
    }
    foreach my$sp (@spList) {
        next if ($sp =~ /^\s*$/);
        $hashSpec{"$sp"} = 1;
    }

    #
    my($nSpec) = 0;
    my($whereSpec) = '';
    foreach my$sp (sort(keys(%hashSpec))) {
        $whereSpec .= "," if ($whereSpec ne '');
        $whereSpec .= "'$sp'";
        $nSpec++;
    }
    print STDERR "DBG :: total $nSpec species\n";

    # $BBP>]G[Ns$N<hF@(B
    my($fileSeq) = "$ENV{'MBGD_HOME'}/work/protseq.hmmer.$$";
    my($fh) = new FileHandle(">$fileSeq") || die("Can not open $fileSeq($!)");
    my($tabs) = "gene g, proteinseq ps";
    my($opt) = {};
    $opt->{'columns'} = "ps.chksum as chksum, ps.seq as seq";
    $opt->{'where'} = "g.sp in($whereSpec)"
                    . " and "
                    . "g.aaseq=ps.id";
    my($res) = $db->select_fetch($tabs, $opt);
    foreach my$ref (@{$res->{'INFO'}}) {
        $fh->print(">$ref->{'chksum'}\n");

        my($seq) = $ref->{'seq'};
        $seq =~ s#(.{1,60})#$1\n#g;
        $fh->print($seq);
    }
    $fh->close();
die;
    # hmmer $B$N<B9T(B
    my($cmd) = "$ENV{'MBGD_HOME'}/build/0550ExecHmmer.pl";
    $cmd .= " -MX=$mx -MXJOB=$mxJob -DB='$fileDb' -OUT=$fileOut $fileSeq";
    system("$cmd");

#    unlink($fileSeq);
}

###############################################################################
1;#
###############################################################################
