#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;
use MBGD;

###############################################################################
#
sub printUsage {
    print "Usage :: $0 -func_dbname='FunctionDbName' data-files\n";
    print "    FunctionDbName :: e.g. 'mbgd_orig'\n";
}

###############################################################################
#
sub deleteGeneFunction {
    my($dbname) = shift;
    my($funcDbname) = shift;

    my($db) = new MBGD::DB($dbname);
    my($sql) = "delete from gene_function gf useing function f where gf.funcid=f.id and f.dbname='$funcDbname'";

    #
    $db->do($sql);
}

###############################################################################
#
sub getFunction {
    my($dbname) = shift;
    my($funcDbname) = shift;
    my($ref) = {};
    $ref->{'id2name'} = {};
    $ref->{'name2id'} = {};

    my($db) = new MBGD::DB($dbname);
    my($tab) = "function";
    my($opt) = {};
    $opt->{'columns'} = "*";
    $opt->{'where'} = "dbname='$funcDbname'";
    my($res) = $db->select_fetch($tab, $opt);
    foreach my$ent (@{$res->{'INFO'}}) {
        my($funcId)   = $ent->{'id'};
        my($funcName) = $ent->{'funcname'};
        $ref->{'id2name'}->{"$funcId"}   = $funcName;
        $ref->{'name2id'}->{"$funcName"} = $funcId;
    }

    return $ref;
}

###############################################################################
#
sub loadGeneFunction {
    my($dbname) = shift;
    my($funcDbname) = shift;
    my($filename) = shift;
    my($line);

    #
    my($refFunc) = getFunction($dbname, $funcDbname);

    my($fh) = new FileHandle("$filename");
    if (! $fh) {
        print "Can not open $filename($!)\n";
        return;
    }

    my($fileGeneFunc) = "$ENV{'MBGD_HOME'}/work/gene_function.$$";
    my($fhw) = new FileHandle(">$fileGeneFunc") || die("Can not open $fileGeneFunc($!)");
    while($line = $fh->getline()) {
        next if ($line =~ /^\s*#/);
        next if ($line =~ /^\s*$/);

        $line =~ s#[\r\n]*$##;
        my($sp, $orf, $funcName) = split(/\t/, $line);

        if (! exists($refFunc->{'name2id'}->{"$funcName"})) {
            next;
        }

        my($funcId) = $refFunc->{'name2id'}->{"$funcName"};
        $fhw->print(join("\t", $sp, $orf, $funcId), "\n");
    }
    $fh->close();
    $fhw->close();

    #
    my($db) = new MBGD::DB($dbname);
    my($sql) = "load data local infile '$fileGeneFunc' into table gene_function fields terminated by '\\t' (sp, name, funcid)";
    $db->do($sql);

    unlink($fileGeneFunc);
}

###############################################################################
if ($0 eq __FILE__) {
    if (! $main::func_dbname) {
        printUsage();
        exit;
    }

    foreach my$file (@ARGV) {
#        loadGeneFunction($main::dbname, $main::func_dbname, $file);
        loadGeneFunction('test_function', $main::func_dbname, $file);
    }
}

###############################################################################
1;#
###############################################################################
