#!/usr/bin/perl -s
use strict;
use DirHandle;
use File::Path;
use FileHandle;
require "MBGD_common.pl";
require "MBGD_Conf.pl";

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 [-DIR=dir]\n";
}

###############################################################################
#
sub createCddDb {
    my($dir) = shift;
    my($fileCdd) = shift;
    my($dbType) = shift;
    my($cmd);

    #
    chdir($dir);

    #
    if (!$main::NOT_DOWNLOAD) {
        print STDERR "Download :: cdd.tar.gz\n";
        my($url) = "ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/cdd.tar.gz";
        $cmd = "$main::CMD_curl -L -O $url";
        system("$cmd");
    }

    #
    print STDERR "Decompress :: cdd.tar.gz\n";
    $cmd = "$main::CMD_gzip -dc $fileCdd | (cd $dir; $main::CMD_tar xf -)";
    system("$cmd");

    #
    if ($dbType =~ /^all$/i) {
        my(@dbType);
        my($dh) = new DirHandle("$dir") || die("Can not open $dir($!)");
        foreach my$file ($dh->read()) {
            if ($file =~ /^(.+)\.pn$/) {
                push(@dbType, $1);
            }
        }
        $dbType = join(',', @dbType);
    }

    #
    my($dir_endian) = 'little_endian';      # 'big_endian'
    my($ext_endian) = '_LE';                # '_BE'
    foreach my$type (split(',', $dbType)) {
        my($t) = ucfirst(lc($type));
        next if (! -e "$t.pn");

#        print STDERR "Formatrpsdb($t)...\n";
#        $cmd = "$main::CMD_formatrpsdb -i $t.pn -o T -f 9.82 -n $t -S 100.0";
#        system("$cmd");

        my($f) = "$t$ext_endian.tar.gz";
        print STDERR "Download :: $f\n";
        my($url) = "ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/$dir_endian/$f";
        $cmd = "$main::CMD_curl -L -O '$url'";
        system("$cmd") if (!$main::NOT_DOWNLOAD);

        $cmd = "$main::CMD_tar xvfz $f";
        system("$cmd");
    }

    #
    my($file_motif) = "$dir/motif";
    my($cmd) = "$ENV{'MBGD_HOME'}/package/motif/conv_cdd2motif.pl -DIR='$dir' > $file_motif";
    print STDERR "CMD :: $cmd\n";
    system("$cmd");

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($cmd) = "$ENV{'MBGD_HOME'}/package/motif/load_motif.pl -DBNAME='$dbname' $file_motif";
    print STDERR "CMD :: $cmd\n";
    system("$cmd");

    #
    my($dh) = new DirHandle("$dir") || die("Can not open $dir($!)");
    foreach my$file ($dh->read()) {
        if ($file =~ /\.smp$/) {
            unlink("$file");
        }
    }
    unlink($file_motif);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir) = $main::DIR;
    if (! $main::DIR) {
        $dir = $main::DIR_db_cdd;
    }
    mkpath($dir, 0, 0750) if (! -e "$dir");
    if (! -w "$dir") {
        print STDERR "It isn't writable directory. :: [$dir]";
        exit(0);
    }

    #
    my($fileCdd) = "$dir/cdd.tar.gz";
    if (! -e "$fileCdd") {
        $main::DOWNLOAD = 1;
    }

    my($dbType) = "all";
    if ($main::DB) {
        $dbType = $main::DB;
    }

    createCddDb($dir, $fileCdd, $dbType);
}

1;#
