#!/usr/bin/perl -s

###############################################################################
# 桼Ф BLAST  DB 
#
###############################################################################
use File::Path;
use FileHandle;
use MbgdUpdate;
require "MBGD_Conf.pl";
require "libMBGDaxes.pl";
require "MBGD_commonUpdate.pl";
require "InfoSpec.pl";
require "htblast.pl";

###############################################################################
# bldb/$sp κ
sub GetProteinSeq {
    my($spid) = shift;
    my($res);
    my($key);
    my($filename);
    my($cmd);
    my($fh);

    #
    my($sp) = spid2sp($spid);
print STDERR "DBG :: $spid ==> $sp\n";

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);
    my($sql) = "select count(*) as n from project p, geneset gs where p.id=gs.project_id and gs.selected is not null and spid=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($spid);
    my($ref) = $sth->fetchrow_hashref();
    if ($ref->{'n'} != 1) {
        my($sql) = "select gs.id as id from project p, geneset gs where p.id=gs.project_id and spid=? order by ver desc limit 1";
        my($sth) = $db->prepare($sql);
        $sth->execute($spid);
        my($ref) = $sth->fetchrow_hashref();
        my($id) = $ref->{'id'};

        my($sql) = "update geneset gs, project p set gs.selected=NULL where p.spid=? and p.id=gs.project_id";
        my($sth) = $db->prepare($sql);
        $sth->execute($spid);

        my($sql) = "update geneset set selected=1 where id=?";
        my($sth) = $db->prepare($sql);
        $sth->execute($id);
    }

    #
    $tab = "project p, geneset gs, geneset_gene gsg, gene g, transcript t, proteinseq ps";
    $opt = {};
    $opt->{'columns'} = "g.locus_tag locus_tag, ps.seq seq";
    $opt->{'where'}   = "p.spid='$spid'"
                      . " and "
                      . "p.id=gs.project_id"
#                      . " and "
#                      . "gs.selected is not null"
                      . " and "
                      . "gs.id=gsg.geneset_id"
                      . " and "
                      . "gsg.gene_id=g.id"
                      . " and "
                      . "g.id=t.gene_id"
                      . " and "
                      . "t.type='CDS'"
                      . " and "
                      . "t.seqno=1"
                      . " and "
                      . "t.proteinseq_id=ps.id";

    $res = $db->select_fetch($tab, $opt);

    #
    $filename = "$DIR_work/bldb/$sp";
    $fh = FileHandle->new(">$filename") || die("Can not open $filename($!)");

    foreach $ent (@{$res->{'INFO'}}) {
        my($name) = $ent->{'locus_tag'};
        my($seq)  = $ent->{'seq'};

        $seq =~ s#(.{1,60})#$1\n#g;

        $fh->print(">$sp:$name\n");
        $fh->print($seq, "\n");
    }
    $fh->close();

    # BLAST  DB κ
    my($logdir) = "$DIR_log/formatdb";
    mkpath($logdir, 0, 0750);
    &execFormatdb($filename, "-l $logdir/formatdb.$spid.log");

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    &openLogfile($log);

    if ($main::all) {
        @spidList = MBGD_SpecTableGetAllSpec();
    } else {
        @spidList = @ARGV;
    }

    if (-d "$DIR_work/bldb") {
        print STDERR "clear bldb\n";
        foreach $f (<$DIR_work/bldb/*>) {
            unlink($f);
        }
    }
    else {
        print STDERR "make bldb\n";
        mkpath("$DIR_work/bldb", 0, 0750);
    }

    foreach my$spid (@spidList) {
        &GetProteinSeq($spid);
    }

    exit;
}

###############################################################################
1;#
###############################################################################
