#!/usr/bin/perl -s
use strict;
use DirHandle;
use File::Basename;
use FileHandle;

###############################################################################
#
sub get_user_gene_attr {
    my($dir) = shift;

    #
    if (! $dir) {
        $dir = "$ENV{'MBGD_HOME'}/build/geneattr";
    }

    my(@uga_list);
    my($dh) = DirHandle->new("$dir") || die("Can not open $dir($!)");
    while (my$file=$dh->read()) {
        next if ($file =~ /^\./);
        next if ($file =~ /\.bak$/);
        next if ($file =~ /\.sample$/);
        next if (! -f "$dir/$file");
        next if (! -x "$dir/$file");

        push(@uga_list, $file);
    }

    return @uga_list;
}


###############################################################################
#
sub user_gene_attr {
    my($spid) = shift;

    my($dir_cmd) = "$ENV{'MBGD_HOME'}/build/geneattr";
    my(@uga_list) = get_user_gene_attr($dir_cmd);

    my($dir) = "$ENV{'MBGD_HOME'}/species/$spid/gm/data";
    my($dh) = DirHandle->new("$dir") || die("Can not open $dir($!)");
    foreach my$file ($dh->read()) {
        next if ($file =~ /^\./);
        next if ($file !~ /\.gene$/);

        my($file_base) = basename($file, ".gene");
        foreach my$uga (@uga_list) {
            my($file_nt)  = "$dir/$file_base.geneseq";
            my($file_aa)  = "$dir/$file_base.protseq";
            my($file_uga) = "$dir/$file_base.$uga";

            my($cmd) = "$dir_cmd/$uga $file_nt $file_aa > $file_uga";
            print STDERR "CMD :: $cmd\n";
            system("$cmd");
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    foreach my$spid (@ARGV) {
        user_gene_attr($spid);
    }
}

###############################################################################
1;#
###############################################################################
