#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;
use RecogProjectCommon;

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 [ -DIR=dir_database ] [-ALL] [project_id]\n";
    print STDERR "    -DIR :: directory of database.(default : \$RECOG_HOME/database.work\n";
    print STDERR "    -ALL :: build for all project\n";
    print STDERR "\n";

    return;
}

###############################################################################
#
sub base_clusters {
    my($project_id) = shift;
    my($dir_database) = shift;

    my($dir_base_cluster) = RecogProjectCommon::get_dir_cluster_conf($project_id,
                                                                     $dir_database);
    my(@id_list) = RecogProjectCommon::get_cluster_conf_id_list($project_id,
                                                                $dir_database);
    foreach my$id (@id_list) {
        my($file_out) = "$dir_base_cluster/$id.out";
        my($cmd) = "$main::CMD_get_base_cluster -PROJ_ID=$project_id "
                 .                             "-CONF_ID=$id "
                 .                             "-FILE=$file_out "
                 .                             "-DIR=$dir_database ";
print STDERR "DBG :: CMD :: $cmd\n" if ($main::DEBUG);
        system("$cmd");

        my($cmd) = "$main::CMD_dbInsert_base_cluster -PROJECT_ID=$project_id $file_out";
print STDERR "DBG :: CMD :: $cmd\n" if ($main::DEBUG);
        system("$cmd");
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir_database) = sprintf("%s/database.work", $ENV{'RECOG_HOME'});
    if ($main::DIR) {
        $dir_database = $main::DIR;
    }

    my(@id_list) = @ARGV;
    if ($main::ALL) {
        my($proj_ref) = RECOG::RecogProject->new();
        @id_list = $proj_ref->get_project_id_list();
    }
    foreach my$id (@id_list) {
        print STDERR "Start project id [$id]\n";
        base_clusters($id, $dir_database);
    }
}

###############################################################################
1;#
###############################################################################
