#!/usr/bin/perl -s
use strict;
use File::Path;
use MBGD::DB;
require "InfoSpec.pl";
require "MBGD_common.pl";

###############################################################################
#
sub init_function {
    my($dbname) = shift;

    my($fileFunction) = "$ENV{'MBGD_HOME'}/package/function/function.dump";
    my($sql) = "use $dbname; \\. $fileFunction";
    my($cmd) = "$main::CMD_mysql -e '$sql'";
#    print STDERR "CMD :: $cmd\n";
    system("$cmd");

    return;
}

###############################################################################
#
sub load_gene_function {
    my($dbname) = shift;
    my($spid) = shift;
    my($sp) = shift;

    #
    my($db) = MBGD::DB->new($dbname);

    my($sql) = "create table IF NOT EXISTS gene_category ("
             . "  id      int(11)     NOT NULL auto_increment,"
             . "  sp      varchar($main::SIZE_SP)  NOT NULL default '',"
             . "  name    varchar($main::SIZE_NAME) NOT NULL default '',"
             . "  dbname  varchar(32) NOT NULL default '',"
             . "  level   varchar(32)          default NULL,"
             . "  orig_id varchar(32)          default NULL,"
             . "  PRIMARY KEY  (id),"
             . "  KEY sp (sp,name)"
             . ");";
    $db->do($sql);

    #
    foreach my$dbname ('mbgd', 'cog', 'kegg', 'tigr') {
        my($fileGeneCategory) = "$ENV{'MBGD_HOME'}/species/$spid/gm/geneFunction.$sp.$dbname";
        if (! -e $fileGeneCategory) {
            next;
        }

        #
        my($sql) = "load data infile '$fileGeneCategory' "
                 . "replace into table gene_category "
                 . "ignore 1 lines "
                 . "(sp, name, dbname, level, orig_id)";
        $db->do($sql);

        #
        my($dirDst) = "$ENV{'MBGD_HOME'}/database.work/function/$dbname/";
        mkpath($dirDst, 0, 0750);
        my($cmd) = "$main::CMD_cp $fileGeneCategory $dirDst";
#        print STDERR "CMD :: $cmd\n";
        system("$cmd");
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_FUNCWK;
    if ($main::DB) {
        $dbname = $main::DB;
    }

    #
    my($refSpid) = getInfoSpecTab($main::FILE_spidtab);

    #
    init_function($dbname);

    #
    my(@spid_list) = @ARGV;
    if ($main::ALL) {
        @spid_list = keys(%{$refSpid->{'SPID2DIR'}});
    }

    #
    foreach my$spid (@spid_list) {
        my($sp) = $refSpid->{'SPID2NAME'}->{"$spid"};
        load_gene_function($dbname, $spid, $sp);
    }
}

###############################################################################
1;#
###############################################################################
