#!/usr/bin/perl -s

##############################################################################
# (domclust Ѥϥե) taball ɸϤ˽Ϥ
#
##############################################################################
use MBGD;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libMBGDaxes.pl";

##############################################################################
# MBGD_GetTaball4Domclust : domclust Ѥϥե(taball)뤿
# 
# input : 
# return: 
#
# taball λ
# (1) ԤϡʲΣ
#         ʪ̾     ʪ̾  'sce' 
#         ORF̾        ORF̾
#         ProtSeqĹ    ProteinĹ
#         Ϣ         Ϣ֡ñ̤դ
#                  '+'  +1  '-'  -1
# (2) [Ϣ] ϡʪñ̤ǣϤޤֹ
# (3) [ORF濴] ͤǡ [Ϣ] ֹդ
# (4) ñ̤ [Ϣ] ֹդԤ
# (5) ˡηɽǡϤ
#         linear ξ  #1
#         circular ξ硧#2
#
#
# ʲΤ褦 SQL ¹Ԥ
#       select c.id,
#              c.shape,
#              lower(g.sp),
#              upper(g.name),
#              p.length,
#              g.dir
#       from gene g,
#            proteinseq p,
#            chromosome c,
#            dnaseq d
#       where g.chrid=c.id
#         and c.seq=d.id
#         and g.aaseq=p.id
#       order by g.sp,
#                c.type,
#                d.length desc,
#                (g.from1+g.to1);
#
# ä chromosome/plasmid ζ̤ƽԤäƤʤchromosome.id 
# ۤʤ뤿ᡢchromosome/plasmid 줾ϢդƤΤʤ
#
#
sub ConvTaballFromDb {
    my($db);
    my($sth);
    my($sql);
    my($tab, $opt);
    my($rows);
    my(@dat);
    my($chrId, $chrShape);
    my($seqNo);
    my($idx);
    my($i);
    my($tabGene, $tabChr);
    my($tabDnaSeq, $tabProtSeq);

#    $dbname = $ENV{'MYSQL_DB'};
    my($dbname);
    if ($current) {
        $dbname = $UPD_dbiRelease;
    } elsif($main::dbname) {
        $dbname = $main::dbname;
    } else{
        $dbname = $UPD_dbiWork;
    }
    $tabGene    = "gene";
    $tabChr     = "chromosome";
    $tabDnaSeq  = "dnaseq";
    $tabProtSeq = "proteinseq";

    print STDERR "DBG :: DBNAME :: $dbname\n" if ($main::DEBUG);
    $db = MBGD::DB->new($dbname);

#    $tab        = "$tabGene g, $tabProtSeq p, $tabChr c, $tabDnaSeq d";
#    $opt->{'columns'} = "c.id cid, c.shape shape, lower(g.sp) low, upper(g.name) up, p.length len, g.dir dir";
#    $opt->{'where'}  = "g.chrid=c.id and c.seq=d.id and g.aaseq=p.id";
#    $opt->{'order'}  = "g.sp, c.type, d.length desc, (g.from1+g.to1)";


    $sth = $db->execute("select * from chromosome");
    while ($h = $sth->fetchrow_hashref) {
        $chrShape{ $h->{id} } = $h->{shape};
    }

    my($sql) = "select g.*,p.length aalen from gene g, proteinseq p where g.aaseq=p.id and g.type='CDS'";
    if ($main::splist) {
        my(@sqlSplist);
        foreach my $sp (split(',', $main::splist)) {
            push(@sqlSplist, "'$sp'");
        }
        $sql .= " and g.sp in(" . join(',', @sqlSplist) . ")";
    }
    $sql .= " order by g.sp,g.chrid,(g.from1+g.to1)";
    print STDERR "DBG :: SQL :: $sql\n" if ($main::DEBUG);
    $sth = $db->execute($sql);

    $seqNo = 1;
    while ($h = $sth->fetchrow_hashref) {

        if ($chrId ne $h->{chrid}) {
            if ($chrId ne '') {
                if ($chrShape{$chrId} =~ /circular/i) {
                    print "#2", "\n";  # circular
                } else {
                    print "#1", "\n";  # linear
                }
            }
            $chrId =  $h->{chrid};
            $seqNo = 1;
        }

        print "$h->{sp} $h->{name} $h->{aalen} $seqNo $h->{dir}\n";

        $seqNo++;
    }

    if ($chrShape{$chrId} =~ /circular/i) {
        print "#2", "\n";  # circular
    } else {
        print "#1", "\n";  # linear
    }

    return;
}

##############################################################################
if ($0 eq __FILE__) {

    # STDERR ˽ϤƤե˽
    &openLogfile($log);

    &ConvTaballFromDb();

    exit();
}

##############################################################################
1;
##############################################################################
