#!/usr/bin/perl -s

###############################################################################
#
###############################################################################

#$ENV{MBGD_HOME} = '/dbb/project/MBGD/TEST';
if ($main::mbgd_home) {
	$ENV{MBGD_HOME} = $main::mbgd_home;
}


use Property::HomolParam;
use POSIX;
use MbgdUserGenomeCommon;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libMBGDaxes.pl";
require "libCheckPoint.pl";
require "libMBGDClustMethod.pl";
##require "defaultClustOpt.pl";

if ($current) {
	$DATABASE_DIR = "$DIR_database";
	$DBNAME = $UPD_dbiCurrTmp;
} else {
	$DATABASE_DIR = "$DIR_database.work";
	$DBNAME = $UPD_dbiTmp;
}
$fileTaball = "$DATABASE_DIR/taball.domclust";

if ($main::usergenome) {
    $uid = $main::usergenome;
	$DATABASE_DIR = sprintf("%s/MBGDUserData/%s/database", $ENV{'MBGD_HOME'},
                                                           $uid);
	$fileTaball = "$DATABASE_DIR/taball";
}
if ($main::dbname) {
	$DBNAME = $main::dbname;
}


###############################################################################
#
sub makeDefaultCluster {
    my($splist, $outdir, $tabname) = @_;
    my($fileClustTree) = "$outdir/$tabname.clusterTree.$$";
    my($fileClustTab) = "$outdir/$tabname.clusterTab.$$";
    my($other_selopt);

print STDERR ">>>>Cluster\n";
    my($hom) = Property::HomolParam->new;	# default options

    $hom->setValue('species', $splist);

$SELECT_ONLY = 0;
if ($tabname eq 'all') {
	$other_selopt = '-BESTHIT=bi -RATIOCUT=90';
} else {
##	$SELECT_ONLY = 1;
}


###    $cmd = "$CMD_select -defaulttab -SPEC=$splist -PVAL=0.001 -SCORE=80";

    ## actual command for execution
    my $other_selopt2 = $other_selopt;
#    if (! $current) {
	$other_selopt2 .= (" -DIR='$DATABASE_DIR/bldp'".
			   " -tabout=$fileTaball");
	$clst_taball = "";
#    } else {
#	$clst_taball = "$DIR_work/taball.domclust";
#    }
    $sel_cmd_exec = &getCmdSelect($splist, $hom,
			  "$other_selopt2",
			1);	## no tabout

    $clst_cmd_exec = &getCmdClust($hom, $clst_taball);

    ## command description
    $sel_cmd = &getCmdSelect($splist, $hom, $other_selopt);
    $clst_cmd = &getCmdClust($hom,'');



    ## We do not need addinfo nor sort command here.
    $addinfo_cmd = "$CMD_addinfo -cons_gene -category_col=category ";
    $sort_cmd = '';

    ## actual command for execution
    my($cmd_exec1, $cmd_exec2, $cmd_exec3)
		= &execClustOpt($sel_cmd_exec, $clst_cmd_exec, $addinfo_cmd, $sort_cmd, $splist);

    ## command description
    my($cmd_desc) = &execClustOptInfo($sel_cmd, $clst_cmd, $addinfo_cmd, $sort_cmd, $splist);


if (-f $treefile) {
    $fh = new FileHandle(">$fileClustTree")
		|| die("Can not open $fileClustTree($!)");
    $fh->print("# $cmd_desc\n");
    open(F, $treefile) || die;
    while (<F>) {
	$fh->print($_);
    }
    close(F);
} elsif ($skip_clust && -f "$fileClustTree") {
    print STDERR "file found: $fileClusTree: skip\n";
} elsif ($SELECT_ONLY) {
	system("$sel_cmd_exec | $CMD_gzip > $outdir/selout.${tabname}.gz");
	return 0;
} else {
    $fh = new FileHandle(">$fileClustTree")
		|| die("Can not open $fileClustTree($!)");
    $fh->print("# $cmd_desc\n");
    $fh->close();
print STDERR "$cmd_exec1 >> $fileClustTree\n";
    system("$cmd_exec1 >> $fileClustTree");
    return -1 if (! WIFEXITED($?));
}

    $fh = new FileHandle(">$fileClustTab") || die("Can not open $fileClustTree($!)");
    $fh->print("# $cmd_desc\n");
    $fh->close();

#$CMD_dbInsert = "/dbb/project/MBGD/TEST/WWW/bin/dbInsert.pl";
#$CMD_dbInsert2 = "/dbb/project/MBGD/TEST/WWW/bin/dbInsert2.pl";

    if (! ($pid = fork)) {
print STDERR ">>>$tabname,$DBNAME,$fileClustTree<<<\n";
        exec("$CMD_dbInsert -dbname='$DBNAME' -tabID='$tabname' $fileClustTree");
	exit(0);
    }

#    $cmd = "$CMD_cat $fileClustTree";
#    $cmd = "$cmd | $CMD_clusttree2flat";
#    $cmd = "$cmd | $CMD_convClustFile -SPEC='$splist'";
#    $cmd = "$cmd | $CMD_addinfo -cons_gene -category_col=category";

    print STDERR "$CMD_cat $fileClustTree| $cmd_exec2| $cmd_exec3 >> $fileClustTab\n";

    system("$CMD_cat $fileClustTree| $cmd_exec2| $cmd_exec3 >> $fileClustTab");

    $cmd = "$CMD_dbInsert2 -dbname='$DBNAME' -tabID='$tabname' $fileClustTab";
    system("$cmd");
    return -1 if (! WIFEXITED($?));
    return 0;
}

###############################################################################
## Usage: $0 [-type='all,default'] [-treefile=TREEFILE] [-skip_clust]
##
###############################################################################
if ($0 eq __FILE__) {
    my($sp);
    my(%spHash);
    my(@spList);
    my($ret, $exitval);

    $type = "all,default" if (! $type);
    my($dir) = $DIR_work;
    if ($main::dir_work) {
        $dir = $main::dir_work;
    }

    foreach $t (split(/,/, $type)) {
print STDERR ">>>>Clustering type :: $t\n";
    	if ($t =~ /all/) {
       	    $splist_all = join(',', &MBGD_SpecTableGetAllSpec("$DATABASE_DIR"));
            $ret = &makeDefaultCluster($splist_all, $dir, $t);
        } elsif ($t =~ /default/) {
            $splist_def = join(',', &MBGD_SpecTableGetDefaultSpecies("$DATABASE_DIR"));
            $ret = &makeDefaultCluster($splist_def, $dir, $t);
        } elsif ($splist) {
            $ret = &makeDefaultCluster($splist, $dir, $t);
        }
        if ($ret < 0) {
            $exitval = -1;
        }
    }
    exit($exitval);
}

###############################################################################
1;#
###############################################################################
