#!/usr/bin/perl -s
use strict;
use MBGD::DB;
require "MBGD_Conf.pl";

###############################################################################
#
sub check_upd_spec {
    my($dbname_old) = shift;
    my($dbname_new) = shift;

    my(%upd_sp_hash);

    #
    my($db_old) = MBGD::DB->new($dbname_old);
    my($db_new) = MBGD::DB->new($dbname_new);

    #
    my(%genome_new_hash);
    my(@genome_new_list) = MBGD::Genome->get($db_new);
    foreach my$genome_ref (@genome_new_list) {
        my($sp) = $genome_ref->{'sp'};
        $genome_new_hash{"$sp"} = $genome_ref;
    }

    #
    my(%genome_old_hash);
    my(@genome_old_list) = MBGD::Genome->get($db_old);
    foreach my$genome_ref (@genome_old_list) {
        my($sp) = $genome_ref->{'sp'};
        $genome_old_hash{"$sp"} = $genome_ref;

        if (!exists($genome_new_hash{"$sp"})) {
            # '$sp' has not existed any longer. 
            $del_cluster_sp{"$sp"} = 1;

            #
            delete($genome_new_hash{"$sp"});
        }
    }

    #
    my(@sp_list) = sort(keys(%genome_new_hash));
    foreach my$sp (@sp_list) {
        my($sql) = "select count(*) as n from gene where sp=?";

        #
        my($sth) = $db_old->prepare($sql);
        $sth->execute($sp);
        my($ref_old) = $sth->fetchrow_hashref();

        #
        my($sth) = $db_new->prepare($sql);
        $sth->execute($sp);
        my($ref_new) = $sth->fetchrow_hashref();

        if ($ref_old->{'n'} != $ref_new->{'n'}) {
            # count($sp.gene) is not match
            $upd_sp_hash{"$sp"} = 1;
            next;
        }

        my($sql) = "select count(*) as n "
                 . "from $dbname_old.gene ogene, "
                 .      "$dbname_new.gene ngene "
                 . "where ogene.sp=? "
                 . " and  ogene.sp=ngene.sp "
                 . " and  ogene.name=ngene.name "
                 . " and  ogene.aaseq=ngene.aaseq";
        my($sth) = $db_new->prepare($sql);
        $sth->execute($sp);
        my($ref_same) = $sth->fetchrow_hashref();

        if ($ref_same->{'n'} == $ref_new->{'n'}) {
            # some gene has updated
            $upd_sp_hash{"$sp"} = 1;
            next;
        }
    }


    my(@upd_sp_list) = sort(keys(%upd_sp_hash));

    return @upd_sp_list;
}

###############################################################################
#
sub clear_clustres_upd_spec {
    my($dbname_old) = shift;
    my($dbname_new) = shift;
    my($dbname_recog) = shift;

    my(@upd_sp_list) = check_upd_spec($dbname_old, $dbname_new);

    my($db) = MBGD::DB->new($dbname_recog);
    foreach my$sp (@upd_sp_list) {
        deleteCacheTableBySpec($db, $sp);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    my($dbname_old)   = $main::DBANME_WORK;
    my($dbname_new)   = $main::DBANME_MBGD;
    my($dbname_recog) = $main::DBANME_RECOG;

    clear_clustres_upd_spec($dbname_old, $dbname_new, $dbname_recog);
}

###############################################################################
1;#
###############################################################################
